/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal;

import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.security.CodeSource;
import java.util.StringTokenizer;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.VersionDescription;
import org.apache.geode.internal.lang.SystemUtils;

public class GemFireVersion {
    @Immutable
    private static final VersionDescription description = GemFireVersion.createDescription();

    private GemFireVersion() {
    }

    private static VersionDescription createDescription() {
        String name = GemFireVersion.class.getPackage().getName().replace('.', '/') + "/" + "GemFireVersion.properties";
        return new VersionDescription(name);
    }

    private static VersionDescription getDescription() {
        return description;
    }

    public static String getProductName() {
        return GemFireVersion.getDescription().getProperty("Product-Name");
    }

    public static String getGemFireVersion() {
        return GemFireVersion.getDescription().getProperty("Product-Version");
    }

    public static String getSourceDate() {
        return GemFireVersion.getDescription().getProperty("Source-Date");
    }

    public static String getSourceRepository() {
        return GemFireVersion.getDescription().getProperty("Source-Repository");
    }

    public static String getSourceRevision() {
        return GemFireVersion.getDescription().getProperty("Source-Revision");
    }

    public static String getBuildId() {
        return GemFireVersion.getDescription().getProperty("Build-Id");
    }

    public static String getBuildPlatform() {
        return GemFireVersion.getDescription().getProperty("Build-Platform");
    }

    public static String getBuildJavaVersion() {
        return GemFireVersion.getDescription().getProperty("Build-Java-Version");
    }

    public static String getGemFireJarFileName() {
        return "geode-core-" + GemFireVersion.getGemFireVersion() + ".jar";
    }

    public static void print(PrintWriter pw) {
        GemFireVersion.getDescription().print(pw);
    }

    public static void print(PrintStream ps) {
        GemFireVersion.print(new PrintWriter(ps, true));
    }

    public static String asString() {
        StringWriter sw = new StringWriter(256);
        PrintWriter pw = new PrintWriter(sw);
        GemFireVersion.print(pw);
        pw.flush();
        return sw.toString();
    }

    public static URL getJarURL() {
        File gemfireJar;
        String jar;
        CodeSource cs = GemFireVersion.class.getProtectionDomain().getCodeSource();
        if (cs != null) {
            return cs.getLocation();
        }
        URL csLoc = null;
        StringTokenizer tokenizer = new StringTokenizer(SystemUtils.getClassPath(), File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            jar = tokenizer.nextToken();
            if (!jar.contains(GemFireVersion.getGemFireJarFileName())) continue;
            gemfireJar = new File(jar);
            try {
                csLoc = gemfireJar.toURI().toURL();
            }
            catch (Exception exception) {}
            break;
        }
        if (csLoc != null) {
            return csLoc;
        }
        tokenizer = new StringTokenizer(SystemUtils.getBootClassPath(), File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            jar = tokenizer.nextToken();
            if (!jar.contains(GemFireVersion.getGemFireJarFileName())) continue;
            gemfireJar = new File(jar);
            try {
                csLoc = gemfireJar.toURI().toURL();
            }
            catch (Exception exception) {}
            break;
        }
        return csLoc;
    }
}

