/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.Instantiator;
import org.apache.geode.distributed.internal.AdminMessageType;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.StartupMessage;
import org.apache.geode.distributed.internal.StartupMessageReplyProcessor;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.InternalInstantiator;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class StartupResponseMessage
extends DistributionMessage
implements AdminMessageType {
    private static final Logger logger = LogService.getLogger();
    protected String rejectionMessage;
    protected int processorId;
    protected boolean responderIsAdmin;
    protected Set interfaces;
    protected int distributedSystemId;
    protected String redundancyZone;
    protected int[] serializerIds = null;
    protected String[] serializerClasseNames = null;
    protected String[] instantiatorClasseNames = null;
    protected String[] instantiatedClasseNames = null;
    protected int[] instantiatorIds = null;
    protected transient StringBuffer fromDataProblems;

    public StartupResponseMessage() {
    }

    StartupResponseMessage(ClusterDistributionManager dm, int processorId, InternalDistributedMember recipient, String rejectionMessage, boolean responderIsAdmin) {
        this.setRecipient(recipient);
        this.setProcessorId(processorId);
        this.rejectionMessage = rejectionMessage;
        this.responderIsAdmin = responderIsAdmin;
        this.interfaces = StartupMessage.getMyAddresses(dm);
        this.distributedSystemId = dm.getDistributedSystemId();
        this.redundancyZone = dm.getRedundancyZone(dm.getId());
        Object[] instantiators = InternalInstantiator.getInstantiatorsForSerialization();
        this.instantiatorClasseNames = new String[instantiators.length];
        this.instantiatedClasseNames = new String[instantiators.length];
        this.instantiatorIds = new int[instantiators.length];
        for (int i = 0; i < instantiators.length; ++i) {
            Object inst;
            if (instantiators[i] instanceof Instantiator) {
                inst = (Instantiator)instantiators[i];
                this.instantiatorClasseNames[i] = inst.getClass().getName();
                this.instantiatedClasseNames[i] = ((Instantiator)inst).getInstantiatedClass().getName();
                this.instantiatorIds[i] = ((Instantiator)inst).getId();
                continue;
            }
            inst = (InternalInstantiator.InstantiatorAttributesHolder)instantiators[i];
            this.instantiatorClasseNames[i] = ((InternalInstantiator.InstantiatorAttributesHolder)inst).getInstantiatorClassName();
            this.instantiatedClasseNames[i] = ((InternalInstantiator.InstantiatorAttributesHolder)inst).getInstantiatedClassName();
            this.instantiatorIds[i] = ((InternalInstantiator.InstantiatorAttributesHolder)inst).getId();
        }
        InternalDataSerializer.SerializerAttributesHolder[] sahs = InternalDataSerializer.getSerializersForDistribution();
        this.serializerIds = new int[sahs.length];
        this.serializerClasseNames = new String[sahs.length];
        for (int i = 0; i < sahs.length; ++i) {
            this.serializerIds[i] = sahs[i].getId();
            this.serializerClasseNames[i] = sahs[i].getClassName();
        }
    }

    public void setProcessorId(int processorId) {
        this.processorId = processorId;
    }

    @Override
    public boolean getInlineProcess() {
        return true;
    }

    @Override
    public int getProcessorType() {
        return 77;
    }

    @Override
    public boolean sendViaUDP() {
        return true;
    }

    @Override
    protected void process(ClusterDistributionManager dm) {
        int i;
        if (this.interfaces != null && this.interfaces.size() != 0) {
            dm.setEquivalentHosts(this.interfaces);
        }
        dm.setDistributedSystemId(this.distributedSystemId);
        dm.setRedundancyZone(this.getSender(), this.redundancyZone);
        if (this.fromDataProblems != null && logger.isDebugEnabled()) {
            logger.debug((CharSequence)this.fromDataProblems);
        }
        if (this.serializerIds != null) {
            for (i = 0; i < this.serializerIds.length; ++i) {
                String cName = this.serializerClasseNames[i];
                if (cName == null) continue;
                InternalDataSerializer.register(cName, false, null, null, this.serializerIds[i]);
            }
        }
        if (this.instantiatorIds != null) {
            for (i = 0; i < this.instantiatorIds.length; ++i) {
                String instantiatorClassName = this.instantiatorClasseNames[i];
                String instantiatedClassName = this.instantiatedClasseNames[i];
                int id = this.instantiatorIds[i];
                if (instantiatorClassName == null || instantiatedClassName == null) continue;
                InternalInstantiator.register(instantiatorClassName, instantiatedClassName, id, false);
            }
        }
        dm.processStartupResponse(this.sender, this.rejectionMessage);
        StartupMessageReplyProcessor proc = (StartupMessageReplyProcessor)ReplyProcessor21.getProcessor(this.processorId);
        if (proc != null) {
            if (this.rejectionMessage != null) {
                proc.setReceivedRejectionMessage(true);
            } else if (!this.responderIsAdmin) {
                proc.setReceivedAcceptance(true);
            }
            proc.process(this);
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "{} Processed {}", (Object)proc, (Object)this);
            }
        }
    }

    public int getDSFID() {
        return 97;
    }

    @Override
    public KnownVersion[] getSerializationVersions() {
        return null;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        int i;
        super.toData(out, context);
        out.writeInt(this.processorId);
        DataSerializer.writeString(this.rejectionMessage, out);
        out.writeBoolean(this.responderIsAdmin);
        out.writeInt(this.serializerIds.length);
        for (i = 0; i < this.serializerIds.length; ++i) {
            DataSerializer.writeNonPrimitiveClassName(this.serializerClasseNames[i], out);
            out.writeInt(this.serializerIds[i]);
        }
        out.writeInt(this.instantiatorIds.length);
        for (i = 0; i < this.instantiatorIds.length; ++i) {
            DataSerializer.writeNonPrimitiveClassName(this.instantiatorClasseNames[i], out);
            DataSerializer.writeNonPrimitiveClassName(this.instantiatedClasseNames[i], out);
            out.writeInt(this.instantiatorIds[i]);
        }
        DataSerializer.writeObject(this.interfaces, out);
        out.writeInt(this.distributedSystemId);
        DataSerializer.writeString(this.redundancyZone, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.processorId = in.readInt();
        this.rejectionMessage = DataSerializer.readString(in);
        this.responderIsAdmin = in.readBoolean();
        int serializerCount = in.readInt();
        this.serializerClasseNames = new String[serializerCount];
        this.serializerIds = new int[serializerCount];
        for (int i = 0; i < serializerCount; ++i) {
            try {
                this.serializerClasseNames[i] = DataSerializer.readNonPrimitiveClassName(in);
                continue;
            }
            finally {
                this.serializerIds[i] = in.readInt();
            }
        }
        int instantiatorCount = in.readInt();
        this.instantiatorClasseNames = new String[instantiatorCount];
        this.instantiatedClasseNames = new String[instantiatorCount];
        this.instantiatorIds = new int[instantiatorCount];
        for (int i = 0; i < instantiatorCount; ++i) {
            this.instantiatorClasseNames[i] = DataSerializer.readNonPrimitiveClassName(in);
            this.instantiatedClasseNames[i] = DataSerializer.readNonPrimitiveClassName(in);
            this.instantiatorIds[i] = in.readInt();
        }
        this.interfaces = (Set)DataSerializer.readObject(in);
        this.distributedSystemId = in.readInt();
        this.redundancyZone = DataSerializer.readString(in);
    }

    @Override
    public String toString() {
        return "StartupResponse: rejectionMessage=" + this.rejectionMessage + " processor=" + this.processorId + " responderIsAdmin=" + this.responderIsAdmin + " distributed system id = " + this.distributedSystemId;
    }
}

