/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.distributed.internal.PoolStatHelper;
import org.apache.geode.internal.monitoring.ThreadsMonitoring;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class FunctionExecutionPooledExecutor
extends ThreadPoolExecutor {
    private static final Logger logger = LogService.getLogger();
    private static final int DEFAULT_RETRY_INTERVAL = 5000;
    private static final int DEFAULT_IDLE_THREAD_TIMEOUT_MILLIS = 1800000;
    private static final int OFFER_TIME_MILLIS = Integer.getInteger("gemfire.RETRY_INTERVAL", 5000);
    @MakeNotStatic
    private static final InheritableThreadLocal<Boolean> isFunctionExecutionThread = new InheritableThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private final PoolStatHelper stats;
    private final ThreadsMonitoring threadMonitoring;
    private BlockingQueue<Runnable> bufferQueue;
    private Thread bufferConsumer;

    public FunctionExecutionPooledExecutor(int poolSize, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, PoolStatHelper poolStatHelper, ThreadsMonitoring threadsMonitoring) {
        super(FunctionExecutionPooledExecutor.getCorePoolSize(poolSize), poolSize, Long.getLong("gemfire.IDLE_THREAD_TIMEOUT", 1800000L), TimeUnit.MILLISECONDS, FunctionExecutionPooledExecutor.getSynchronousQueue(workQueue), threadFactory, FunctionExecutionPooledExecutor.newRejectedExecutionHandler(workQueue, true));
        this.stats = poolStatHelper;
        this.threadMonitoring = threadsMonitoring;
        if (!(workQueue instanceof SynchronousQueue)) {
            this.bufferQueue = workQueue;
            BlockingQueue<Runnable> takeQueue = workQueue;
            BlockingQueue<Runnable> putQueue = this.getQueue();
            Runnable r = () -> {
                try {
                    while (true) {
                        SystemFailure.checkFailure();
                        Runnable task = (Runnable)takeQueue.take();
                        if (putQueue.offer(task, OFFER_TIME_MILLIS, TimeUnit.MILLISECONDS)) continue;
                        this.execute(task);
                    }
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    return;
                }
            };
            this.bufferConsumer = threadFactory.newThread(r);
            this.bufferConsumer.start();
        }
    }

    public static boolean isFunctionExecutionThread() {
        return (Boolean)isFunctionExecutionThread.get();
    }

    private static SynchronousQueue<Runnable> getSynchronousQueue(BlockingQueue<Runnable> blockingQueue) {
        if (blockingQueue instanceof SynchronousQueue) {
            return (SynchronousQueue)blockingQueue;
        }
        return new SynchronousQueue<Runnable>();
    }

    private static RejectedExecutionHandler newRejectedExecutionHandler(BlockingQueue<Runnable> blockingQueue, boolean forFunctionExecution) {
        if (forFunctionExecution) {
            return new FunctionExecutionRejectedExecutionHandler(blockingQueue);
        }
        if (blockingQueue instanceof SynchronousQueue) {
            return new ThreadPoolExecutor.CallerRunsPolicy();
        }
        return new BufferHandler();
    }

    static void setIsFunctionExecutionThread(Boolean isExecutionThread) {
        isFunctionExecutionThread.set(isExecutionThread);
    }

    @Override
    public void shutdown() {
        try {
            super.shutdown();
        }
        finally {
            this.terminated();
        }
    }

    @Override
    protected void terminated() {
        if (this.bufferConsumer != null) {
            this.bufferConsumer.interrupt();
        }
        super.terminated();
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.terminated();
        List<Runnable> l = super.shutdownNow();
        if (this.bufferQueue != null) {
            this.bufferQueue.drainTo(l);
        }
        return l;
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        if (this.stats != null) {
            this.stats.startJob();
        }
        if (this.threadMonitoring != null) {
            this.threadMonitoring.startMonitor(ThreadsMonitoring.Mode.FunctionExecutor);
        }
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        if (this.stats != null) {
            this.stats.endJob();
        }
        if (this.threadMonitoring != null) {
            this.threadMonitoring.endMonitor();
        }
    }

    @VisibleForTesting
    public BlockingQueue<Runnable> getBufferQueue() {
        return this.bufferQueue;
    }

    private static int getCorePoolSize(int maxSize) {
        if (maxSize == Integer.MAX_VALUE) {
            return 0;
        }
        return 1;
    }

    public static class BufferHandler
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            if (executor.isShutdown()) {
                throw new RejectedExecutionException("executor has been shutdown");
            }
            try {
                FunctionExecutionPooledExecutor pool = (FunctionExecutionPooledExecutor)executor;
                pool.bufferQueue.put(r);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new RejectedExecutionException("interrupted", ie);
            }
        }
    }

    @VisibleForTesting
    public static class FunctionExecutionRejectedExecutionHandler
    implements RejectedExecutionHandler {
        private final BlockingQueue<Runnable> blockingQueue;

        private FunctionExecutionRejectedExecutionHandler(BlockingQueue<Runnable> blockingQueue) {
            this.blockingQueue = blockingQueue;
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            if (executor.isShutdown()) {
                throw new RejectedExecutionException("executor has been shutdown");
            }
            if (this.isBufferConsumer((FunctionExecutionPooledExecutor)executor)) {
                this.handleRejectedExecutionForBufferConsumer(r, executor);
            } else if (this.isFunctionExecutionThread()) {
                this.handleRejectedExecutionForFunctionExecutionThread(r, executor);
            } else {
                try {
                    this.blockingQueue.put(r);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private boolean isBufferConsumer(FunctionExecutionPooledExecutor executor) {
            return Thread.currentThread() == executor.bufferConsumer;
        }

        private boolean isFunctionExecutionThread() {
            return (Boolean)isFunctionExecutionThread.get();
        }

        private void handleRejectedExecutionForBufferConsumer(Runnable r, ThreadPoolExecutor executor) {
            logger.warn("An additional Function Execution Processor thread is being launched because all " + executor.getMaximumPoolSize() + " thread pool threads are in use for greater than " + OFFER_TIME_MILLIS + " ms");
            this.launchAdditionalThread(r, executor);
        }

        private void handleRejectedExecutionForFunctionExecutionThread(Runnable r, ThreadPoolExecutor executor) {
            if (logger.isDebugEnabled()) {
                logger.warn("An additional {} thread is being launched to prevent slow performance due to nested function executions", (Object)"Function Execution Processor");
            }
            this.launchAdditionalThread(r, executor);
        }

        private void launchAdditionalThread(Runnable r, ThreadPoolExecutor executor) {
            Thread th = executor.getThreadFactory().newThread(r);
            th.start();
        }
    }
}

