/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.geode.CopyHelper;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.Struct;
import org.apache.geode.cache.query.internal.StructImpl;
import org.apache.geode.cache.query.internal.types.StructTypeImpl;
import org.apache.geode.cache.query.types.CollectionType;
import org.apache.geode.cache.query.types.ObjectType;

public class ResultsCollectionCopyOnReadWrapper
implements SelectResults {
    SelectResults results;

    public ResultsCollectionCopyOnReadWrapper(SelectResults results) {
        this.results = results;
    }

    @Override
    public Iterator iterator() {
        return new SelectResultsCopyOnReadIterator(this.results.iterator());
    }

    @Override
    public boolean add(Object e) {
        return this.results.add(e);
    }

    @Override
    public boolean addAll(Collection c) {
        return this.results.addAll(c);
    }

    @Override
    public void clear() {
        this.results.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.results.contains(o);
    }

    @Override
    public boolean containsAll(Collection c) {
        return this.results.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.results.isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        return this.results.remove(o);
    }

    @Override
    public boolean removeAll(Collection c) {
        return this.results.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection c) {
        return this.results.retainAll(c);
    }

    @Override
    public int size() {
        return this.results.size();
    }

    @Override
    public Object[] toArray() {
        ArrayList arrayList = new ArrayList();
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            arrayList.add(iter.next());
        }
        return arrayList.toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        Iterator iter = this.iterator();
        int i = 0;
        while (iter.hasNext()) {
            a[i++] = iter.next();
        }
        return a;
    }

    @Override
    public boolean isModifiable() {
        return this.results.isModifiable();
    }

    public int occurrences(Object element) {
        return this.results.occurrences(element);
    }

    public Set asSet() {
        return new HashSet(this);
    }

    public List asList() {
        return new ArrayList(this);
    }

    @Override
    public CollectionType getCollectionType() {
        return this.results.getCollectionType();
    }

    @Override
    public void setElementType(ObjectType elementType) {
        this.results.setElementType(elementType);
    }

    private class SelectResultsCopyOnReadIterator
    implements Iterator {
        Iterator iterator;

        SelectResultsCopyOnReadIterator(Iterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            Object object = this.iterator.next();
            if (object instanceof Struct) {
                Struct struct = (Struct)object;
                Object[] values = struct.getFieldValues();
                Object[] newValues = new Object[values.length];
                int length = values.length;
                for (int i = 0; i < length; ++i) {
                    newValues[i] = CopyHelper.copy(values[i]);
                }
                return new StructImpl((StructTypeImpl)struct.getStructType(), newValues);
            }
            return CopyHelper.copy(object);
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

