/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.InterestResultPolicy;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.client.PoolManager;
import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.ClearOp;
import org.apache.geode.cache.client.internal.ClientMetadataService;
import org.apache.geode.cache.client.internal.CommitOp;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.ContainsKeyOp;
import org.apache.geode.cache.client.internal.DestroyOp;
import org.apache.geode.cache.client.internal.DestroyRegionOp;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.cache.client.internal.ExecuteRegionFunctionNoAckOp;
import org.apache.geode.cache.client.internal.ExecuteRegionFunctionOp;
import org.apache.geode.cache.client.internal.ExecuteRegionFunctionSingleHopOp;
import org.apache.geode.cache.client.internal.GetAllOp;
import org.apache.geode.cache.client.internal.GetEntryOp;
import org.apache.geode.cache.client.internal.GetFunctionAttributeOp;
import org.apache.geode.cache.client.internal.GetOp;
import org.apache.geode.cache.client.internal.InternalPool;
import org.apache.geode.cache.client.internal.InvalidateOp;
import org.apache.geode.cache.client.internal.KeySetOp;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.client.internal.PutAllOp;
import org.apache.geode.cache.client.internal.PutOp;
import org.apache.geode.cache.client.internal.RegisterInterestListOp;
import org.apache.geode.cache.client.internal.RegisterInterestOp;
import org.apache.geode.cache.client.internal.RegisterInterestTracker;
import org.apache.geode.cache.client.internal.RemoveAllOp;
import org.apache.geode.cache.client.internal.RollbackOp;
import org.apache.geode.cache.client.internal.ServerProxy;
import org.apache.geode.cache.client.internal.ServerRegionDataAccess;
import org.apache.geode.cache.client.internal.SizeOp;
import org.apache.geode.cache.client.internal.TXSynchronizationOp;
import org.apache.geode.cache.client.internal.UnregisterInterestListOp;
import org.apache.geode.cache.client.internal.UnregisterInterestOp;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.internal.cache.ClientServerObserver;
import org.apache.geode.internal.cache.ClientServerObserverHolder;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.EventIDHolder;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.TXCommitMessage;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.cache.execute.ServerRegionFunctionExecutor;
import org.apache.geode.internal.cache.tier.sockets.VersionedObjectList;
import org.apache.geode.internal.cache.tx.ClientTXStateStub;
import org.apache.geode.internal.cache.tx.TransactionalOperation;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class ServerRegionProxy
extends ServerProxy
implements ServerRegionDataAccess {
    private static final Logger logger = LogService.getLogger();
    private final LocalRegion region;
    private final String regionName;

    public ServerRegionProxy(Region r) {
        super(ServerRegionProxy.calcPool(r));
        assert (r instanceof LocalRegion);
        this.region = (LocalRegion)r;
        this.regionName = r.getFullPath();
    }

    public ServerRegionProxy(String regionName, PoolImpl pool) {
        super(pool);
        this.region = null;
        this.regionName = regionName;
    }

    private static InternalPool calcPool(Region r) {
        String poolName = r.getAttributes().getPoolName();
        if (poolName == null || "".equals(poolName)) {
            throw new IllegalStateException("The region " + r.getFullPath() + " did not have a client pool configured.");
        }
        InternalPool pool = (InternalPool)PoolManager.find(poolName);
        if (pool == null) {
            throw new IllegalStateException("The pool " + poolName + " does not exist.");
        }
        return pool;
    }

    @Override
    public Object get(Object key, Object callbackArg, EntryEventImpl clientEvent) {
        this.recordTXOperation(TransactionalOperation.ServerRegionOperation.GET, key, callbackArg);
        return GetOp.execute(this.pool, this.region, key, callbackArg, this.pool.getPRSingleHopEnabled(), clientEvent);
    }

    @Override
    public int size() {
        return SizeOp.execute(this.pool, this.regionName);
    }

    public Object putForMetaRegion(Object key, Object value, byte[] deltaBytes, EntryEventImpl event, Object callbackArg) {
        if (this.region == null) {
            return PutOp.execute((ExecutablePool)this.pool, this.regionName, key, value, deltaBytes, event, Operation.CREATE, false, null, callbackArg, this.pool.getPRSingleHopEnabled());
        }
        return PutOp.execute((ExecutablePool)this.pool, this.region, key, value, deltaBytes, event, Operation.CREATE, false, null, callbackArg, this.pool.getPRSingleHopEnabled());
    }

    @Override
    public Object put(Object key, Object value, byte[] deltaBytes, EntryEventImpl event, Operation op, boolean requireOldValue, Object expectedOldValue, Object callbackArg, boolean isCreate) {
        this.recordTXOperation(TransactionalOperation.ServerRegionOperation.PUT, key, value, deltaBytes, event.getEventId(), op, requireOldValue, expectedOldValue, callbackArg, isCreate);
        Operation operation = op;
        if (!isCreate && this.region.getDataPolicy() == DataPolicy.EMPTY && op.isCreate() && op != Operation.PUT_IF_ABSENT) {
            operation = Operation.UPDATE;
        }
        if (this.region == null) {
            return PutOp.execute((ExecutablePool)this.pool, this.regionName, key, value, deltaBytes, event, operation, requireOldValue, expectedOldValue, callbackArg, this.pool.getPRSingleHopEnabled());
        }
        return PutOp.execute((ExecutablePool)this.pool, this.region, key, value, deltaBytes, event, operation, requireOldValue, expectedOldValue, callbackArg, this.pool.getPRSingleHopEnabled());
    }

    public void putOnForTestsOnly(Connection con, Object key, Object value, EventID eventId, Object callbackArg) {
        EventIDHolder event = new EventIDHolder(eventId);
        PutOp.execute(con, this.pool, this.regionName, key, value, event, callbackArg, this.pool.getPRSingleHopEnabled());
    }

    @Override
    public Object destroy(Object key, Object expectedOldValue, Operation operation, EntryEventImpl event, Object callbackArg) {
        if (event.isBulkOpInProgress()) {
            return null;
        }
        this.recordTXOperation(TransactionalOperation.ServerRegionOperation.DESTROY, key, expectedOldValue, operation, event.getEventId(), callbackArg);
        return DestroyOp.execute(this.pool, this.region, key, expectedOldValue, operation, event, callbackArg, this.pool.getPRSingleHopEnabled());
    }

    @Override
    public void invalidate(EntryEventImpl event) {
        this.recordTXOperation(TransactionalOperation.ServerRegionOperation.INVALIDATE, event.getKey(), event);
        InvalidateOp.execute(this.pool, this.region.getFullPath(), event, this.pool.getPRSingleHopEnabled(), this.region);
    }

    public void destroyOnForTestsOnly(Connection con, Object key, Object expectedOldValue, Operation operation, EntryEventImpl event, Object callbackArg) {
        DestroyOp.execute(con, this.pool, this.regionName, key, expectedOldValue, operation, event, callbackArg);
    }

    public void destroyRegion(EventID eventId, Object callbackArg) {
        DestroyRegionOp.execute(this.pool, this.regionName, eventId, callbackArg);
    }

    public void destroyRegionOnForTestsOnly(Connection con, EventID eventId, Object callbackArg) {
        DestroyRegionOp.execute(con, this.pool, this.regionName, eventId, callbackArg);
    }

    public TXCommitMessage commit(int txId) {
        return CommitOp.execute(this.pool, txId);
    }

    public void rollback(int txId) {
        RollbackOp.execute(this.pool, txId);
    }

    @Override
    public void clear(EventID eventId, Object callbackArg) {
        ClearOp.execute(this.pool, this.regionName, eventId, callbackArg);
    }

    public void clearOnForTestsOnly(Connection con, EventID eventId, Object callbackArg) {
        ClearOp.execute(con, this.pool, this.regionName, eventId, callbackArg);
    }

    @Override
    public boolean containsKey(Object key) {
        this.recordTXOperation(TransactionalOperation.ServerRegionOperation.CONTAINS_KEY, key, new Object[0]);
        return ContainsKeyOp.execute(this.pool, this.regionName, key, ContainsKeyOp.MODE.KEY);
    }

    @Override
    public boolean containsValueForKey(Object key) {
        this.recordTXOperation(TransactionalOperation.ServerRegionOperation.CONTAINS_VALUE_FOR_KEY, key, new Object[0]);
        return ContainsKeyOp.execute(this.pool, this.regionName, key, ContainsKeyOp.MODE.VALUE_FOR_KEY);
    }

    @Override
    public boolean containsValue(Object value) {
        this.recordTXOperation(TransactionalOperation.ServerRegionOperation.CONTAINS_VALUE, null, value);
        return ContainsKeyOp.execute(this.pool, this.regionName, value, ContainsKeyOp.MODE.VALUE);
    }

    @Override
    public Set keySet() {
        this.recordTXOperation(TransactionalOperation.ServerRegionOperation.KEY_SET, null, new Object[0]);
        return KeySetOp.execute(this.pool, this.regionName);
    }

    public List registerInterest(Object key, int interestType2, InterestResultPolicy policy, boolean isDurable, byte regionDataPolicy) {
        return this.registerInterest(key, interestType2, policy, isDurable, false, regionDataPolicy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List registerInterest(Object key, int interestType2, InterestResultPolicy policy, boolean isDurable, boolean receiveUpdatesAsInvalidates, byte regionDataPolicy) {
        if (interestType2 == 0 && key instanceof List) {
            logger.warn("Usage of registerInterest(List) has been deprecated. Please use registerInterestForKeys(Iterable)");
            return this.registerInterestList((List)key, policy, isDurable, receiveUpdatesAsInvalidates, regionDataPolicy);
        }
        RegisterInterestTracker rit = this.pool.getRITracker();
        boolean finished = false;
        try {
            rit.addSingleInterest(this.region, key, interestType2, policy, isDurable, receiveUpdatesAsInvalidates);
            List result = RegisterInterestOp.execute(this.pool, this.regionName, key, interestType2, policy, isDurable, receiveUpdatesAsInvalidates, regionDataPolicy);
            if (PoolImpl.AFTER_REGISTER_CALLBACK_FLAG) {
                ClientServerObserver bo = ClientServerObserverHolder.getInstance();
                bo.afterInterestRegistration();
            }
            finished = true;
            List list = result;
            return list;
        }
        finally {
            if (!finished) {
                rit.removeSingleInterest(this.region, key, interestType2, isDurable, receiveUpdatesAsInvalidates);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSingleInterest(Object key, int interestType2, InterestResultPolicy pol, boolean isDurable, boolean receiveUpdatesAsInvalidates) {
        RegisterInterestTracker rit = this.pool.getRITracker();
        boolean finished = false;
        try {
            rit.addSingleInterest(this.region, key, interestType2, pol, isDurable, receiveUpdatesAsInvalidates);
            finished = true;
        }
        finally {
            if (!finished) {
                rit.removeSingleInterest(this.region, key, interestType2, isDurable, receiveUpdatesAsInvalidates);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListInterest(List keys, InterestResultPolicy pol, boolean isDurable, boolean receiveUpdatesAsInvalidates) {
        RegisterInterestTracker rit = this.pool.getRITracker();
        boolean finished = false;
        try {
            rit.addInterestList(this.region, keys, pol, isDurable, receiveUpdatesAsInvalidates);
            finished = true;
        }
        finally {
            if (!finished) {
                rit.removeInterestList(this.region, keys, isDurable, receiveUpdatesAsInvalidates);
            }
        }
    }

    public void removeSingleInterest(Object key, int interestType2, boolean isDurable, boolean receiveUpdatesAsInvalidates) {
        this.pool.getRITracker().removeSingleInterest(this.region, key, interestType2, isDurable, receiveUpdatesAsInvalidates);
    }

    public void removeListInterest(List keys, boolean isDurable, boolean receiveUpdatesAsInvalidates) {
        this.pool.getRITracker().removeInterestList(this.region, keys, isDurable, receiveUpdatesAsInvalidates);
    }

    public List registerInterestOn(ServerLocation sl, Object key, int interestType2, InterestResultPolicy policy, boolean isDurable, byte regionDataPolicy) {
        return this.registerInterestOn(sl, key, interestType2, policy, isDurable, false, regionDataPolicy);
    }

    private List registerInterestOn(ServerLocation sl, Object key, int interestType2, InterestResultPolicy policy, boolean isDurable, boolean receiveUpdatesAsInvalidates, byte regionDataPolicy) {
        if (interestType2 == 0 && key instanceof List) {
            return RegisterInterestListOp.executeOn(sl, (ExecutablePool)this.pool, this.regionName, (List)key, policy, isDurable, receiveUpdatesAsInvalidates, regionDataPolicy);
        }
        return RegisterInterestOp.executeOn(sl, (ExecutablePool)this.pool, this.regionName, key, interestType2, policy, isDurable, receiveUpdatesAsInvalidates, regionDataPolicy);
    }

    List registerInterestOn(Connection conn, Object key, int interestType2, InterestResultPolicy policy, boolean isDurable, boolean receiveUpdatesAsInvalidates, byte regionDataPolicy) {
        if (interestType2 == 0 && key instanceof List) {
            return RegisterInterestListOp.executeOn(conn, (ExecutablePool)this.pool, this.regionName, (List)key, policy, isDurable, receiveUpdatesAsInvalidates, regionDataPolicy);
        }
        return RegisterInterestOp.executeOn(conn, (ExecutablePool)this.pool, this.regionName, key, interestType2, policy, isDurable, receiveUpdatesAsInvalidates, regionDataPolicy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List registerInterestList(List keys, InterestResultPolicy policy, boolean isDurable, boolean receiveUpdatesAsInvalidates, byte regionDataPolicy) {
        RegisterInterestTracker rit = this.pool.getRITracker();
        boolean finished = false;
        try {
            rit.addInterestList(this.region, keys, policy, isDurable, receiveUpdatesAsInvalidates);
            List result = RegisterInterestListOp.execute(this.pool, this.regionName, keys, policy, isDurable, receiveUpdatesAsInvalidates, regionDataPolicy);
            finished = true;
            if (PoolImpl.AFTER_REGISTER_CALLBACK_FLAG) {
                ClientServerObserver bo = ClientServerObserverHolder.getInstance();
                bo.afterInterestRegistration();
            }
            List list = result;
            return list;
        }
        finally {
            if (!finished) {
                rit.removeInterestList(this.region, keys, isDurable, receiveUpdatesAsInvalidates);
            }
        }
    }

    public void unregisterInterest(Object key, int interestType2, boolean isClosing, boolean keepAlive) {
        if (interestType2 == 0 && key instanceof List) {
            this.unregisterInterestList((List)key, isClosing, keepAlive);
        } else {
            boolean removed;
            RegisterInterestTracker rit = this.pool.getRITracker();
            boolean bl = removed = rit.removeSingleInterest(this.region, key, interestType2, false, false) || rit.removeSingleInterest(this.region, key, interestType2, true, false) || rit.removeSingleInterest(this.region, key, interestType2, false, true) || rit.removeSingleInterest(this.region, key, interestType2, true, true);
            if (removed) {
                UnregisterInterestOp.execute(this.pool, this.regionName, key, interestType2, isClosing, keepAlive);
            }
        }
    }

    public void unregisterInterestList(List keys, boolean isClosing, boolean keepAlive) {
        boolean removed;
        RegisterInterestTracker rit = this.pool.getRITracker();
        boolean bl = removed = rit.removeInterestList(this.region, keys, false, true) || rit.removeInterestList(this.region, keys, false, false) || rit.removeInterestList(this.region, keys, true, true) || rit.removeInterestList(this.region, keys, true, false);
        if (removed) {
            UnregisterInterestListOp.execute(this.pool, this.regionName, keys, isClosing, keepAlive);
        }
    }

    public List getInterestList(int interestType2) {
        return this.pool.getRITracker().getInterestList(this.regionName, interestType2);
    }

    @Override
    public VersionedObjectList putAll(Map<Object, Object> map, EventID eventId, boolean skipCallbacks, Object callbackArg) {
        this.recordTXOperation(TransactionalOperation.ServerRegionOperation.PUT_ALL, null, map, eventId);
        int txID = TXManagerImpl.getCurrentTXUniqueId();
        if (this.pool.getPRSingleHopEnabled() && txID == -1) {
            return PutAllOp.execute((ExecutablePool)this.pool, (Region<Object, Object>)this.region, map, eventId, skipCallbacks, this.pool.getRetryAttempts(), callbackArg);
        }
        return PutAllOp.execute((ExecutablePool)this.pool, (Region)this.region, map, eventId, skipCallbacks, false, callbackArg);
    }

    @Override
    public VersionedObjectList removeAll(Collection<Object> keys, EventID eventId, Object callbackArg) {
        this.recordTXOperation(TransactionalOperation.ServerRegionOperation.REMOVE_ALL, null, keys, eventId);
        int txID = TXManagerImpl.getCurrentTXUniqueId();
        if (this.pool.getPRSingleHopEnabled() && txID == -1) {
            return RemoveAllOp.execute((ExecutablePool)this.pool, (Region)this.region, keys, eventId, this.pool.getRetryAttempts(), callbackArg);
        }
        return RemoveAllOp.execute((ExecutablePool)this.pool, (Region)this.region, keys, eventId, false, callbackArg);
    }

    @Override
    public VersionedObjectList getAll(List keys, Object callback) {
        this.recordTXOperation(TransactionalOperation.ServerRegionOperation.GET_ALL, null, keys);
        int txID = TXManagerImpl.getCurrentTXUniqueId();
        VersionedObjectList result = this.pool.getPRSingleHopEnabled() && txID == -1 ? GetAllOp.execute(this.pool, this.region, keys, this.pool.getRetryAttempts(), callback) : GetAllOp.execute(this.pool, this.regionName, keys, callback);
        if (result != null) {
            VersionedObjectList.Iterator it = result.iterator();
            while (it.hasNext()) {
                VersionedObjectList.Entry entry = it.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                boolean isOnServer = entry.isKeyNotOnServer();
                if (isOnServer || !(value instanceof Throwable)) continue;
                logger.warn(String.format("%s: Caught the following exception attempting to get value for key=%s", value, key), (Throwable)value);
            }
        }
        return result;
    }

    public void detach(boolean keepalive) {
        this.pool.getRITracker().unregisterRegion(this, keepalive);
        super.detach();
    }

    @Override
    public String getRegionName() {
        return this.regionName;
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    public void executeFunction(org.apache.geode.cache.execute.Function function, ServerRegionFunctionExecutor serverRegionExecutor, ResultCollector resultCollector, byte hasResult, int timeoutMs) {
        this.recordTXOperation(TransactionalOperation.ServerRegionOperation.EXECUTE_FUNCTION, null, 1, function, serverRegionExecutor, resultCollector, hasResult);
        int retryAttempts = this.pool.getRetryAttempts();
        boolean inTransaction = TXManagerImpl.getCurrentTXState() != null;
        Supplier<AbstractOp> executeRegionFunctionOpSupplier = () -> new ExecuteRegionFunctionOp.ExecuteRegionFunctionOpImpl(this.region.getFullPath(), function, serverRegionExecutor, resultCollector, timeoutMs);
        if (this.pool.getPRSingleHopEnabled() && !inTransaction) {
            ClientMetadataService cms = this.region.getCache().getClientMetadataService();
            if (cms.isMetadataStable()) {
                if (serverRegionExecutor.getFilter().isEmpty()) {
                    Map<ServerLocation, Set<Integer>> serverToBuckets = cms.groupByServerToAllBuckets(this.region, function.optimizeForWrite());
                    if (serverToBuckets == null || serverToBuckets.isEmpty()) {
                        ExecuteRegionFunctionOp.execute(this.pool, resultCollector, retryAttempts, function.isHA(), (ExecuteRegionFunctionOp.ExecuteRegionFunctionOpImpl)executeRegionFunctionOpSupplier.get(), false, Collections.emptySet());
                        cms.scheduleGetPRMetaData(this.region, false);
                    } else {
                        Function<ServerRegionFunctionExecutor, AbstractOp> regionFunctionSingleHopOpFunction = executor -> new ExecuteRegionFunctionSingleHopOp.ExecuteRegionFunctionSingleHopOpImpl(this.region.getFullPath(), function, (ServerRegionFunctionExecutor)executor, resultCollector, hasResult, Collections.emptySet(), true, timeoutMs);
                        ExecuteRegionFunctionSingleHopOp.execute(this.pool, this.region, serverRegionExecutor, resultCollector, serverToBuckets, function.isHA(), regionFunctionSingleHopOpFunction, executeRegionFunctionOpSupplier);
                    }
                } else {
                    boolean isBucketFilter = serverRegionExecutor.getExecuteOnBucketSetFlag();
                    Map<ServerLocation, Set> serverToFilterMap = cms.getServerToFilterMap(serverRegionExecutor.getFilter(), this.region, function.optimizeForWrite(), isBucketFilter);
                    if (serverToFilterMap == null || serverToFilterMap.isEmpty()) {
                        ExecuteRegionFunctionOp.execute(this.pool, resultCollector, retryAttempts, function.isHA(), (ExecuteRegionFunctionOp.ExecuteRegionFunctionOpImpl)executeRegionFunctionOpSupplier.get(), false, Collections.emptySet());
                        cms.scheduleGetPRMetaData(this.region, false);
                    } else {
                        Function<ServerRegionFunctionExecutor, AbstractOp> regionFunctionSingleHopOpFunction = executor -> new ExecuteRegionFunctionSingleHopOp.ExecuteRegionFunctionSingleHopOpImpl(this.region.getFullPath(), function, (ServerRegionFunctionExecutor)executor, resultCollector, hasResult, Collections.emptySet(), isBucketFilter, timeoutMs);
                        ExecuteRegionFunctionSingleHopOp.execute(this.pool, this.region, serverRegionExecutor, resultCollector, serverToFilterMap, function.isHA(), regionFunctionSingleHopOpFunction, executeRegionFunctionOpSupplier);
                    }
                }
            } else {
                cms.scheduleGetPRMetaData(this.region, false);
                ExecuteRegionFunctionOp.execute(this.pool, resultCollector, retryAttempts, function.isHA(), (ExecuteRegionFunctionOp.ExecuteRegionFunctionOpImpl)executeRegionFunctionOpSupplier.get(), false, Collections.emptySet());
            }
        } else {
            ExecuteRegionFunctionOp.execute(this.pool, resultCollector, retryAttempts, function.isHA(), (ExecuteRegionFunctionOp.ExecuteRegionFunctionOpImpl)executeRegionFunctionOpSupplier.get(), false, Collections.emptySet());
        }
    }

    public void executeFunction(String functionId, ServerRegionFunctionExecutor serverRegionExecutor, ResultCollector resultCollector, byte hasResult, boolean isHA, boolean optimizeForWrite, int timeoutMs) {
        this.recordTXOperation(TransactionalOperation.ServerRegionOperation.EXECUTE_FUNCTION, null, 2, functionId, serverRegionExecutor, resultCollector, hasResult, isHA, optimizeForWrite);
        int retryAttempts = this.pool.getRetryAttempts();
        boolean inTransaction = TXManagerImpl.getCurrentTXState() != null;
        Supplier<AbstractOp> executeRegionFunctionOpSupplier = () -> new ExecuteRegionFunctionOp.ExecuteRegionFunctionOpImpl(this.region.getFullPath(), functionId, serverRegionExecutor, resultCollector, hasResult, isHA, optimizeForWrite, true, timeoutMs);
        if (this.pool.getPRSingleHopEnabled() && !inTransaction) {
            ClientMetadataService cms = this.region.getCache().getClientMetadataService();
            if (cms.isMetadataStable()) {
                if (serverRegionExecutor.getFilter().isEmpty()) {
                    Map<ServerLocation, Set<Integer>> serverToBuckets = cms.groupByServerToAllBuckets(this.region, optimizeForWrite);
                    if (serverToBuckets == null || serverToBuckets.isEmpty()) {
                        ExecuteRegionFunctionOp.execute(this.pool, resultCollector, retryAttempts, isHA, (ExecuteRegionFunctionOp.ExecuteRegionFunctionOpImpl)executeRegionFunctionOpSupplier.get(), false, Collections.emptySet());
                        cms.scheduleGetPRMetaData(this.region, false);
                    } else {
                        Function<ServerRegionFunctionExecutor, AbstractOp> regionFunctionSingleHopOpFunction = executor1 -> new ExecuteRegionFunctionSingleHopOp.ExecuteRegionFunctionSingleHopOpImpl(this.region.getFullPath(), functionId, (ServerRegionFunctionExecutor)executor1, resultCollector, hasResult, Collections.emptySet(), true, isHA, optimizeForWrite, timeoutMs);
                        ExecuteRegionFunctionSingleHopOp.execute(this.pool, this.region, serverRegionExecutor, resultCollector, serverToBuckets, isHA, regionFunctionSingleHopOpFunction, executeRegionFunctionOpSupplier);
                    }
                } else {
                    boolean isBucketsAsFilter = serverRegionExecutor.getExecuteOnBucketSetFlag();
                    Map<ServerLocation, Set> serverToFilterMap = cms.getServerToFilterMap(serverRegionExecutor.getFilter(), this.region, optimizeForWrite, isBucketsAsFilter);
                    if (serverToFilterMap == null || serverToFilterMap.isEmpty()) {
                        ExecuteRegionFunctionOp.execute(this.pool, resultCollector, retryAttempts, isHA, (ExecuteRegionFunctionOp.ExecuteRegionFunctionOpImpl)executeRegionFunctionOpSupplier.get(), false, Collections.emptySet());
                        cms.scheduleGetPRMetaData(this.region, false);
                    } else {
                        Function<ServerRegionFunctionExecutor, AbstractOp> regionFunctionSingleHopOpFunction = executor -> new ExecuteRegionFunctionSingleHopOp.ExecuteRegionFunctionSingleHopOpImpl(this.region.getFullPath(), functionId, (ServerRegionFunctionExecutor)executor, resultCollector, hasResult, Collections.emptySet(), isBucketsAsFilter, isHA, optimizeForWrite, timeoutMs);
                        ExecuteRegionFunctionSingleHopOp.execute(this.pool, this.region, serverRegionExecutor, resultCollector, serverToFilterMap, isHA, regionFunctionSingleHopOpFunction, executeRegionFunctionOpSupplier);
                    }
                }
            } else {
                cms.scheduleGetPRMetaData(this.region, false);
                ExecuteRegionFunctionOp.execute(this.pool, resultCollector, retryAttempts, isHA, (ExecuteRegionFunctionOp.ExecuteRegionFunctionOpImpl)executeRegionFunctionOpSupplier.get(), false, Collections.emptySet());
            }
        } else {
            ExecuteRegionFunctionOp.execute(this.pool, resultCollector, retryAttempts, isHA, (ExecuteRegionFunctionOp.ExecuteRegionFunctionOpImpl)executeRegionFunctionOpSupplier.get(), false, Collections.emptySet());
        }
    }

    public void executeFunctionNoAck(String rgnName, org.apache.geode.cache.execute.Function function, ServerRegionFunctionExecutor serverRegionExecutor, byte hasResult, boolean replaying) {
        this.recordTXOperation(TransactionalOperation.ServerRegionOperation.EXECUTE_FUNCTION, null, 3, function, serverRegionExecutor, hasResult);
        ExecuteRegionFunctionNoAckOp.execute(this.pool, rgnName, function, serverRegionExecutor, hasResult);
    }

    public void executeFunctionNoAck(String rgnName, String functionId, ServerRegionFunctionExecutor serverRegionExecutor, byte hasResult, boolean isHA, boolean optimizeForWrite, boolean replaying) {
        this.recordTXOperation(TransactionalOperation.ServerRegionOperation.EXECUTE_FUNCTION, null, 4, functionId, serverRegionExecutor, hasResult);
        ExecuteRegionFunctionNoAckOp.execute(this.pool, rgnName, functionId, serverRegionExecutor, hasResult, isHA, optimizeForWrite);
    }

    @Override
    public Region.Entry getEntry(Object key) {
        this.recordTXOperation(TransactionalOperation.ServerRegionOperation.GET_ENTRY, key, new Object[0]);
        return (Region.Entry)GetEntryOp.execute(this.pool, this.region, key);
    }

    public void beforeCompletion(int txId) {
        TXSynchronizationOp.execute(this.pool, 0, txId, TXSynchronizationOp.CompletionType.BEFORE_COMPLETION);
    }

    public TXCommitMessage afterCompletion(int status, int txId) {
        return TXSynchronizationOp.execute(this.pool, status, txId, TXSynchronizationOp.CompletionType.AFTER_COMPLETION);
    }

    public byte[] getFunctionAttributes(String functionId) {
        return (byte[])GetFunctionAttributeOp.execute(this.pool, functionId);
    }

    private void recordTXOperation(TransactionalOperation.ServerRegionOperation op, Object key, Object ... arguments) {
        if (ClientTXStateStub.transactionRecordingEnabled()) {
            TXStateProxy tx = TXManagerImpl.getCurrentTXState();
            if (tx == null) {
                return;
            }
            tx.recordTXOperation(this, op, key, arguments);
        }
    }
}

