/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.domain;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.geode.DataSerializer;
import org.apache.geode.internal.JarDeployer;
import org.apache.geode.internal.VersionedDataSerializable;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.internal.serialization.VersionOrdinal;
import org.apache.geode.internal.serialization.Versioning;
import org.apache.geode.management.configuration.Deployment;
import org.apache.geode.management.internal.configuration.utils.XmlUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Configuration
implements VersionedDataSerializable {
    private static final long serialVersionUID = 1L;
    private String configName;
    private String cacheXmlContent;
    private String cacheXmlFileName;
    private String propertiesFileName;
    private Properties gemfireProperties;
    private final Map<String, Deployment> deployments = new HashMap<String, Deployment>();

    public Configuration() {
    }

    public Configuration(Configuration that) {
        this.configName = that.configName;
        this.cacheXmlContent = that.cacheXmlContent;
        this.cacheXmlFileName = that.cacheXmlFileName;
        this.propertiesFileName = that.propertiesFileName;
        this.gemfireProperties = new Properties();
        this.gemfireProperties.putAll((Map<?, ?>)that.gemfireProperties);
        this.deployments.putAll(that.deployments);
    }

    public Configuration(String configName) {
        this.configName = configName;
        this.cacheXmlFileName = configName + ".xml";
        this.propertiesFileName = configName + ".properties";
        this.gemfireProperties = new Properties();
    }

    public String getCacheXmlContent() {
        return this.cacheXmlContent;
    }

    public void setCacheXmlContent(String cacheXmlContent) {
        this.cacheXmlContent = cacheXmlContent;
    }

    public void setCacheXmlFile(File cacheXmlFile) throws IOException {
        if (cacheXmlFile.length() == 0L) {
            this.cacheXmlContent = "";
        } else {
            try {
                Document doc = XmlUtils.getDocumentBuilder().parse(cacheXmlFile);
                this.cacheXmlContent = XmlUtils.elementToString(doc);
            }
            catch (ParserConfigurationException | TransformerException | SAXException e) {
                throw new IOException("Unable to parse existing cluster configuration from file: " + cacheXmlFile.getAbsolutePath(), e);
            }
        }
    }

    public void setPropertiesFile(File propertiesFile) throws IOException {
        if (!propertiesFile.exists()) {
            return;
        }
        try (FileInputStream fis = new FileInputStream(propertiesFile);){
            this.gemfireProperties.load(fis);
        }
    }

    public String getCacheXmlFileName() {
        return this.cacheXmlFileName;
    }

    public Properties getGemfireProperties() {
        return this.gemfireProperties;
    }

    public void setGemfireProperties(Properties gemfireProperties) {
        this.gemfireProperties = gemfireProperties;
    }

    public void addGemfireProperties(Properties gemfireProperties) {
        this.gemfireProperties.putAll((Map<?, ?>)gemfireProperties);
    }

    public String getConfigName() {
        return this.configName;
    }

    public String getPropertiesFileName() {
        return this.propertiesFileName;
    }

    public void putDeployment(Deployment deployment) {
        String artifactId = JarDeployer.getArtifactId(deployment.getFileName());
        this.deployments.values().removeIf(d -> JarDeployer.getArtifactId(d.getFileName()).equals(artifactId));
        this.deployments.put(deployment.getId(), deployment);
    }

    public Collection<Deployment> getDeployments() {
        return this.deployments.values();
    }

    public void removeJarNames(String[] jarNames) {
        if (jarNames == null) {
            this.deployments.clear();
        } else {
            Arrays.asList(jarNames).forEach(this.deployments::remove);
        }
    }

    public Set<String> getJarNames() {
        return this.deployments.keySet();
    }

    public void toDataPre_GEODE_1_12_0_0(DataOutput out) throws IOException {
        DataSerializer.writeString(this.configName, out);
        DataSerializer.writeString(this.cacheXmlFileName, out);
        DataSerializer.writeString(this.cacheXmlContent, out);
        DataSerializer.writeString(this.propertiesFileName, out);
        DataSerializer.writeProperties(this.gemfireProperties, out);
        HashSet<String> jarNames = new HashSet<String>(this.deployments.keySet());
        DataSerializer.writeHashSet(jarNames, out);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString(this.configName, out);
        DataSerializer.writeString(this.cacheXmlFileName, out);
        DataSerializer.writeString(this.cacheXmlContent, out);
        DataSerializer.writeString(this.propertiesFileName, out);
        DataSerializer.writeProperties(this.gemfireProperties, out);
        HashSet<String> jarNames = new HashSet<String>(this.deployments.keySet());
        DataSerializer.writeHashSet(jarNames, out);
        Version.getCurrentVersion().writeOrdinal(out, true);
        DataSerializer.writeHashMap(this.deployments, out);
    }

    public void fromDataPre_GEODE_1_12_0_0(DataInput in) throws IOException, ClassNotFoundException {
        this.configName = DataSerializer.readString(in);
        this.cacheXmlFileName = DataSerializer.readString(in);
        this.cacheXmlContent = DataSerializer.readString(in);
        this.propertiesFileName = DataSerializer.readString(in);
        this.gemfireProperties = DataSerializer.readProperties(in);
        HashSet jarNames = DataSerializer.readHashSet(in);
        jarNames.stream().map(x -> new Deployment(x, null, null)).forEach(deployment -> this.deployments.put(deployment.getFileName(), (Deployment)deployment));
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        block3: {
            this.configName = DataSerializer.readString(in);
            this.cacheXmlFileName = DataSerializer.readString(in);
            this.cacheXmlContent = DataSerializer.readString(in);
            this.propertiesFileName = DataSerializer.readString(in);
            this.gemfireProperties = DataSerializer.readProperties(in);
            HashSet jarNames = DataSerializer.readHashSet(in);
            try {
                VersionOrdinal version = Versioning.getVersionOrdinal((short)Version.readOrdinal((DataInput)in));
                if (version.isNotOlderThan((VersionOrdinal)Version.GEODE_1_12_0)) {
                    this.deployments.putAll(DataSerializer.readHashMap(in));
                }
            }
            catch (EOFException ex) {
                if (jarNames == null) break block3;
                jarNames.stream().map(x -> new Deployment(x, null, null)).forEach(deployment -> this.deployments.put(deployment.getFileName(), (Deployment)deployment));
            }
        }
    }

    public String toString() {
        return "Configuration{configName='" + this.configName + '\'' + ", cacheXmlContent='" + this.cacheXmlContent + '\'' + ", cacheXmlFileName='" + this.cacheXmlFileName + '\'' + ", propertiesFileName='" + this.propertiesFileName + '\'' + ", gemfireProperties=" + this.gemfireProperties + ", deployments=" + this.deployments + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Configuration that = (Configuration)o;
        return Objects.equals(this.configName, that.configName) && Objects.equals(this.cacheXmlContent, that.cacheXmlContent) && Objects.equals(this.cacheXmlFileName, that.cacheXmlFileName) && Objects.equals(this.propertiesFileName, that.propertiesFileName) && Objects.equals(this.gemfireProperties, that.gemfireProperties) && Objects.equals(this.deployments, that.deployments);
    }

    public int hashCode() {
        return Objects.hash(this.configName, this.cacheXmlContent, this.cacheXmlFileName, this.propertiesFileName, this.gemfireProperties, this.deployments);
    }

    public Version[] getSerializationVersions() {
        return new Version[]{Version.GEODE_1_12_0};
    }
}

