/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import javax.management.Notification;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.internal.MBeanProxyFactory;
import org.apache.geode.management.internal.NotificationBroadCasterProxy;
import org.apache.geode.management.internal.NotificationKey;
import org.apache.logging.log4j.Logger;

public class NotificationHubClient {
    private static final Logger logger = LogService.getLogger();
    private MBeanProxyFactory proxyFactory;

    protected NotificationHubClient(MBeanProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    public void sendNotification(EntryEvent<NotificationKey, Notification> event) {
        try {
            NotificationBroadCasterProxy notifBroadCaster = this.proxyFactory.findProxy(event.getKey().getObjectName(), NotificationBroadCasterProxy.class);
            if (notifBroadCaster != null) {
                notifBroadCaster.sendNotification(event.getNewValue());
            }
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug(" NOTIFICATION Not Done {}", (Object)e.getMessage(), (Object)e);
            }
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }
}

