/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.control;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.partition.PartitionRebalanceInfo;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.management.internal.operation.RestoreRedundancyResultsImpl;

public class SerializableRestoreRedundancyResultsImpl
extends RestoreRedundancyResultsImpl
implements DataSerializableFixedID {
    private static final long serialVersionUID = -6385537590999520662L;

    public void addPrimaryReassignmentDetails(PartitionRebalanceInfo details) {
        this.totalPrimaryTransfersCompleted += details.getPrimaryTransfersCompleted();
        this.totalPrimaryTransferTime += details.getPrimaryTransferTime();
    }

    public int getDSFID() {
        return -160;
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        DataSerializer.writeHashMap(this.satisfiedRedundancyRegionsResults, out);
        DataSerializer.writeHashMap(this.underRedundancyRegionsResults, out);
        DataSerializer.writeHashMap(this.zeroRedundancyRegionsResults, out);
        out.writeInt(this.totalPrimaryTransfersCompleted);
        DataSerializer.writeObject(this.totalPrimaryTransferTime, out);
        out.writeBoolean(this.success);
        DataSerializer.writeString(this.statusMessage, out);
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.satisfiedRedundancyRegionsResults = DataSerializer.readHashMap(in);
        this.underRedundancyRegionsResults = DataSerializer.readHashMap(in);
        this.zeroRedundancyRegionsResults = DataSerializer.readHashMap(in);
        this.totalPrimaryTransfersCompleted = in.readInt();
        this.totalPrimaryTransferTime = (Long)DataSerializer.readObject(in);
        this.success = DataSerializer.readBoolean(in);
        this.statusMessage = DataSerializer.readString(in);
    }

    public Version[] getSerializationVersions() {
        return null;
    }
}

