/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.geode.CancelException;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.InvalidDeltaException;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.CacheEvent;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.CacheLoader;
import org.apache.geode.cache.CacheLoaderException;
import org.apache.geode.cache.CacheWriter;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.DiskAccessException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.MembershipAttributes;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAccessException;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.RegionDistributionException;
import org.apache.geode.cache.RegionMembershipListener;
import org.apache.geode.cache.ResumptionAction;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.cache.asyncqueue.internal.AsyncEventQueueImpl;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.cache.persistence.PersistentReplicatesOfflineException;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.distributed.DistributedLockService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.LockServiceDestroyedException;
import org.apache.geode.distributed.Role;
import org.apache.geode.distributed.internal.DistributionAdvisee;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.MembershipListener;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.locks.DLockRemoteToken;
import org.apache.geode.distributed.internal.locks.DLockService;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.SystemTimer;
import org.apache.geode.internal.cache.AbstractRegionMap;
import org.apache.geode.internal.cache.CacheDistributionAdvisor;
import org.apache.geode.internal.cache.CacheObserverHolder;
import org.apache.geode.internal.cache.CreateRegionProcessor;
import org.apache.geode.internal.cache.DestroyOperation;
import org.apache.geode.internal.cache.DestroyRegionOperation;
import org.apache.geode.internal.cache.DiskRegion;
import org.apache.geode.internal.cache.DiskRegionStats;
import org.apache.geode.internal.cache.DistributedClearOperation;
import org.apache.geode.internal.cache.DistributedPutAllOperation;
import org.apache.geode.internal.cache.DistributedRegionFunctionStreamingMessage;
import org.apache.geode.internal.cache.DistributedRemoveAllOperation;
import org.apache.geode.internal.cache.DistributedTombstoneOperation;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EnumListenerEvent;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.ExpiryTask;
import org.apache.geode.internal.cache.FindVersionTagOperation;
import org.apache.geode.internal.cache.ImageState;
import org.apache.geode.internal.cache.InMemoryPersistentMemberView;
import org.apache.geode.internal.cache.InitialImageOperation;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalDistributedRegion;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.InvalidateOperation;
import org.apache.geode.internal.cache.InvalidateRegionOperation;
import org.apache.geode.internal.cache.KeyInfo;
import org.apache.geode.internal.cache.LatestLastAccessTimeOperation;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.MemoryThresholdInfo;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEventImpl;
import org.apache.geode.internal.cache.RegionMap;
import org.apache.geode.internal.cache.RemoteOperationException;
import org.apache.geode.internal.cache.RoleEventImpl;
import org.apache.geode.internal.cache.SearchLoadAndWriteProcessor;
import org.apache.geode.internal.cache.SenderIdMonitor;
import org.apache.geode.internal.cache.StateFlushOperation;
import org.apache.geode.internal.cache.TXStateInterface;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.cache.UpdateAttributesProcessor;
import org.apache.geode.internal.cache.UpdateEntryVersionOperation;
import org.apache.geode.internal.cache.UpdateOperation;
import org.apache.geode.internal.cache.VersionTagHolder;
import org.apache.geode.internal.cache.control.InternalResourceManager;
import org.apache.geode.internal.cache.control.MemoryEvent;
import org.apache.geode.internal.cache.event.DistributedEventTracker;
import org.apache.geode.internal.cache.event.EventTracker;
import org.apache.geode.internal.cache.eviction.EvictableEntry;
import org.apache.geode.internal.cache.execute.DistributedRegionFunctionExecutor;
import org.apache.geode.internal.cache.execute.DistributedRegionFunctionResultSender;
import org.apache.geode.internal.cache.execute.DistributedRegionFunctionResultWaiter;
import org.apache.geode.internal.cache.execute.LocalResultCollector;
import org.apache.geode.internal.cache.execute.RegionFunctionContextImpl;
import org.apache.geode.internal.cache.execute.ServerToClientFunctionResultSender;
import org.apache.geode.internal.cache.execute.metrics.FunctionStats;
import org.apache.geode.internal.cache.execute.metrics.FunctionStatsManager;
import org.apache.geode.internal.cache.persistence.CreatePersistentRegionProcessor;
import org.apache.geode.internal.cache.persistence.PersistenceAdvisor;
import org.apache.geode.internal.cache.persistence.PersistenceAdvisorImpl;
import org.apache.geode.internal.cache.persistence.PersistentMemberID;
import org.apache.geode.internal.cache.persistence.PersistentMemberManager;
import org.apache.geode.internal.cache.persistence.PersistentMemberView;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.VersionedObjectList;
import org.apache.geode.internal.cache.tx.RemoteClearMessage;
import org.apache.geode.internal.cache.tx.RemoteDestroyMessage;
import org.apache.geode.internal.cache.tx.RemoteFetchVersionMessage;
import org.apache.geode.internal.cache.tx.RemoteInvalidateMessage;
import org.apache.geode.internal.cache.tx.RemotePutMessage;
import org.apache.geode.internal.cache.versions.ConcurrentCacheModificationException;
import org.apache.geode.internal.cache.versions.RegionVersionHolder;
import org.apache.geode.internal.cache.versions.RegionVersionVector;
import org.apache.geode.internal.cache.versions.VersionSource;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.cache.wan.AsyncEventQueueConfigurationException;
import org.apache.geode.internal.cache.wan.GatewaySenderConfigurationException;
import org.apache.geode.internal.sequencelog.RegionLogger;
import org.apache.geode.internal.statistics.StatisticsClock;
import org.apache.geode.internal.util.concurrent.StoppableCountDownLatch;
import org.apache.geode.logging.internal.executors.LoggingThread;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class DistributedRegion
extends LocalRegion
implements InternalDistributedRegion {
    private static final Logger logger = LogService.getLogger();
    @MutableForTesting
    public static boolean TEST_HOOK_ADD_PROFILE = false;
    private final Object dlockMonitor = new Object();
    final CacheDistributionAdvisor distAdvisor;
    private final SenderIdMonitor senderIdMonitor;
    private DistributedLockService dlockService;
    final AdvisorListener advisorListener = new AdvisorListener();
    private final HashSet<Role> missingRequiredRoles = new HashSet();
    private volatile boolean isMissingRequiredRoles = false;
    private final boolean requiresReliabilityCheck;
    private final StoppableCountDownLatch initializationLatchAfterMemberTimeout;
    private final PersistenceAdvisor persistenceAdvisor;
    private final PersistentMemberID persistentId;
    private volatile boolean generateVersionTag = true;
    @MutableForTesting
    public static boolean ignoreReconnect = false;
    private final Object clearLock = new Object();
    private final ReentrantReadWriteLock failedInitialImageLock = new ReentrantReadWriteLock(true);
    @MakeNotStatic
    private static final AtomicBoolean loggedNetworkPartitionWarning = new AtomicBoolean(false);
    private boolean isInitializingThread = false;
    private boolean giiMissingRequiredRoles = false;
    private final Set<DistributedMember> memoryThresholdReachedMembers = new HashSet<DistributedMember>();

    protected DistributedRegion(String regionName, RegionAttributes attrs, LocalRegion parentRegion, InternalCache cache, InternalRegionArguments internalRegionArgs, StatisticsClock statisticsClock) {
        super(regionName, attrs, parentRegion, cache, internalRegionArgs, statisticsClock);
        this.initializationLatchAfterMemberTimeout = new StoppableCountDownLatch(this.getCancelCriterion(), 1);
        this.distAdvisor = this.createDistributionAdvisor(internalRegionArgs);
        this.senderIdMonitor = this.createSenderIdMonitor();
        if (this.getDistributionManager().getConfig().getEnableNetworkPartitionDetection() && !this.isInternalRegion() && !attrs.getScope().isAck() && !this.doesNotDistribute() && attrs.getDataPolicy().withStorage()) {
            logger.warn("Region {} is being created with scope {} but enable-network-partition-detection is enabled in the distributed system.  This can lead to cache inconsistencies if there is a network failure.", new Object[]{regionName, attrs.getScope()});
        }
        if (!this.getDistributionManager().getConfig().getEnableNetworkPartitionDetection() && attrs.getDataPolicy().withPersistence() && !loggedNetworkPartitionWarning.getAndSet(true)) {
            logger.warn("Creating persistent region {}, but enable-network-partition-detection is set to false. Running with network partition detection disabled can lead to an unrecoverable system in the event of a network split.", (Object)regionName);
        }
        boolean setRequiresReliabilityCheck = attrs.getMembershipAttributes().hasRequiredRoles() && !attrs.getMembershipAttributes().getLossAction().isAllAccess() && !attrs.getMembershipAttributes().getLossAction().isReconnect();
        HashSet<Role> reqRoles = new HashSet<Role>(attrs.getMembershipAttributes().getRequiredRoles());
        reqRoles.removeAll(this.getSystem().getDistributedMember().getRoles());
        if (reqRoles.isEmpty()) {
            setRequiresReliabilityCheck = false;
        }
        this.requiresReliabilityCheck = setRequiresReliabilityCheck;
        if (internalRegionArgs.isUsedForPartitionedRegionBucket()) {
            this.persistenceAdvisor = internalRegionArgs.getPersistenceAdvisor();
        } else if (this.allowsPersistence()) {
            DistributedLockService dl = cache.getPartitionedRegionLockService();
            try {
                DiskRegionStats diskStats;
                PersistentMemberView storage;
                if (this.getDataPolicy().withPersistence()) {
                    storage = this.getDiskRegion();
                    diskStats = this.getDiskRegion().getStats();
                } else {
                    storage = new InMemoryPersistentMemberView();
                    diskStats = null;
                }
                PersistentMemberManager memberManager = cache.getPersistentMemberManager();
                this.persistenceAdvisor = new PersistenceAdvisorImpl(this.distAdvisor, dl, storage, this.getFullPath(), diskStats, memberManager);
            }
            catch (Exception ignore) {
                throw new InternalGemFireError("Couldn't recover persistence");
            }
        } else {
            this.persistenceAdvisor = null;
        }
        this.persistentId = this.persistenceAdvisor != null ? this.persistenceAdvisor.generatePersistentID() : null;
    }

    @Override
    protected EventTracker createEventTracker() {
        DistributedEventTracker tracker = new DistributedEventTracker(this.cache, this.getCancelCriterion(), this.getName());
        tracker.start();
        return tracker;
    }

    protected void recordEventStateFromImageProvider(InternalDistributedMember provider) {
    }

    protected CacheDistributionAdvisor createDistributionAdvisor(InternalRegionArguments internalRegionArgs) {
        return CacheDistributionAdvisor.createCacheDistributionAdvisor(this);
    }

    public boolean allowsPersistence() {
        return true;
    }

    @Override
    boolean requiresOneHopForMissingEntry(EntryEventImpl event) {
        if (event.isOriginRemote()) {
            return false;
        }
        if (event.getOperation().isLocal()) {
            return false;
        }
        if (event.getVersionTag() != null && event.getVersionTag().getRegionVersion() > 0L) {
            return false;
        }
        if (!this.generateVersionTag) {
            return true;
        }
        return this.getConcurrencyChecksEnabled() && this.getServerProxy() == null && !this.isTX() && this.scope.isDistributed() && !this.getDataPolicy().withReplication();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean virtualPut(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed, boolean invokeCallbacks, boolean throwConcurrentModificaiton) throws TimeoutException, CacheWriterException {
        boolean isTraceEnabled = logger.isTraceEnabled();
        Lock dlock = null;
        if (!(!this.scope.isGlobal() || event.isOriginRemote() || event.isNetSearch() || event.isNetLoad() || event.isLocalLoad() || event.isSingleHopPutOp())) {
            dlock = this.getDistributedLockIfGlobal(event.getKey());
        }
        if (isTraceEnabled) {
            logger.trace("virtualPut invoked for event {}", (Object)event);
        }
        try {
            if (!this.hasSeenEvent(event)) {
                RegionEntry re;
                if (!(!this.requiresOneHopForMissingEntry(event) || (re = this.getRegionEntry(event.getKey())) != null && this.generateVersionTag || event.isBulkOpInProgress() && !this.getDataPolicy().withStorage())) {
                    boolean didDistribute = RemotePutMessage.distribute(event, lastModified, false, false, expectedOldValue, requireOldValue, !this.generateVersionTag);
                    if (!didDistribute && isTraceEnabled) {
                        logger.trace("Unable to perform one-hop messaging");
                    }
                    if (!this.generateVersionTag && !didDistribute) {
                        throw new PersistentReplicatesOfflineException();
                    }
                    if (didDistribute) {
                        if (isTraceEnabled) {
                            logger.trace("Event after remotePut operation: {}", (Object)event);
                        }
                        if (event.getVersionTag() == null) {
                            boolean bl = false;
                            return bl;
                        }
                    }
                }
                boolean bl = super.virtualPut(event, ifNew, ifOld, expectedOldValue, requireOldValue, lastModified, overwriteDestroyed, invokeCallbacks, throwConcurrentModificaiton);
                return bl;
            }
            if (event.getDeltaBytes() != null && event.getRawNewValue() == null) {
                throw new InvalidDeltaException("Cache encountered replay of event containing delta bytes for key " + event.getKey());
            }
            if (logger.isDebugEnabled()) {
                logger.debug("DR.virtualPut: this cache has already seen this event {}", (Object)event);
            }
            if (event.isBulkOpInProgress() && !event.isOriginRemote()) {
                event.getPutAllOperation().addEntry(event, true);
            }
            event.makeCreate();
            if (!this.getConcurrencyChecksEnabled() || event.hasValidVersionTag()) {
                this.distributeUpdate(event, lastModified, ifNew, ifOld, expectedOldValue, requireOldValue);
                event.invokeCallbacks(this, true, true);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (dlock != null) {
                dlock.unlock();
            }
        }
    }

    @Override
    RegionEntry basicPutEntry(EntryEventImpl event, long lastModified) throws TimeoutException, CacheWriterException {
        RegionEntry re;
        boolean isTraceEnabled = logger.isTraceEnabled();
        if (isTraceEnabled) {
            logger.trace("basicPutEntry invoked for event {}", (Object)event);
        }
        if (this.requiresOneHopForMissingEntry(event) && ((re = this.getRegionEntry(event.getKey())) == null || !this.generateVersionTag)) {
            boolean ifNew = false;
            boolean ifOld = false;
            boolean didDistribute = RemotePutMessage.distribute(event, lastModified, false, false, null, false, !this.generateVersionTag);
            if (!this.generateVersionTag && !didDistribute) {
                throw new PersistentReplicatesOfflineException();
            }
            if (didDistribute && isTraceEnabled) {
                logger.trace("Event after remotePut for basicPutEntry: {}", (Object)event);
            }
        }
        return super.basicPutEntry(event, lastModified);
    }

    @Override
    void performPutAllEntry(EntryEventImpl event) {
        if (this.isTX()) {
            event.getPutAllOperation().addEntry(event);
        } else {
            this.getSharedDataView().putEntry(event, false, false, null, false, 0L, false);
        }
    }

    @Override
    void performRemoveAllEntry(EntryEventImpl event) {
        if (this.isTX()) {
            event.getRemoveAllOperation().addEntry(event);
        } else {
            this.basicDestroy(event, true, null);
        }
    }

    @Override
    public void basicPutPart3(EntryEventImpl event, RegionEntry entry, boolean isInitialized, long lastModified, boolean invokeCallbacks, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue) {
        this.distributeUpdate(event, lastModified, false, false, null, false);
        super.basicPutPart3(event, entry, isInitialized, lastModified, invokeCallbacks, ifNew, ifOld, expectedOldValue, requireOldValue);
    }

    protected void distributeUpdate(EntryEventImpl event, long lastModified, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue) {
        if (!(event.isOriginRemote() || event.isNetSearch() || event.isBulkOpInProgress())) {
            boolean distribute = true;
            if (event.getInhibitDistribution()) {
                distribute = false;
            }
            if (distribute) {
                UpdateOperation op = new UpdateOperation(event, lastModified);
                if (logger.isTraceEnabled()) {
                    logger.trace("distributing operation for event : {} : for region : {}", (Object)event, (Object)this.getName());
                }
                op.distribute();
            }
        }
    }

    @Override
    public boolean hasSeenEvent(EntryEventImpl event) {
        boolean isDuplicate = this.getEventTracker().hasSeenEvent(event);
        if (isDuplicate) {
            this.markEventAsDuplicate(event);
        } else if (event.isPossibleDuplicate() && event.getRegion().getConcurrencyChecksEnabled() && event.getVersionTag() == null && event.getEventId() != null) {
            boolean isBulkOp = event.getOperation().isPutAll() || event.getOperation().isRemoveAll();
            VersionTag tag = FindVersionTagOperation.findVersionTag(event.getRegion(), event.getEventId(), isBulkOp);
            event.setVersionTag(tag);
        }
        return isDuplicate;
    }

    private void markEventAsDuplicate(EntryEventImpl event) {
        event.setPossibleDuplicate(true);
        if (this.getConcurrencyChecksEnabled() && event.getVersionTag() == null) {
            if (event.isBulkOpInProgress()) {
                event.setVersionTag(this.getEventTracker().findVersionTagForBulkOp(event.getEventId()));
            } else {
                event.setVersionTag(this.getEventTracker().findVersionTagForSequence(event.getEventId()));
            }
        }
    }

    void setGeneratedVersionTag(boolean generateVersionTag) {
        this.enableConcurrencyChecks();
        this.generateVersionTag = generateVersionTag;
    }

    protected boolean getGenerateVersionTag() {
        return this.generateVersionTag;
    }

    @Override
    boolean shouldGenerateVersionTag(RegionEntry entry, EntryEventImpl event) {
        if (logger.isTraceEnabled()) {
            logger.trace("shouldGenerateVersionTag this.generateVersionTag={} ccenabled={} dataPolicy={} event:{}", (Object)this.generateVersionTag, (Object)this.getConcurrencyChecksEnabled(), (Object)this.getDataPolicy(), (Object)event);
        }
        if (!this.getConcurrencyChecksEnabled() || this.getDataPolicy() == DataPolicy.EMPTY || !this.generateVersionTag) {
            return false;
        }
        if (this.getServerProxy() != null) {
            return false;
        }
        if (event.getVersionTag() != null && !event.getVersionTag().isGatewayTag()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Not to create a new version tag for retried event {}", (Object)event);
            }
            return false;
        }
        if (event.getOperation().isLocal()) {
            return false;
        }
        if (!event.isOriginRemote() && this.getDataPolicy().withReplication()) {
            return true;
        }
        if (!this.getDataPolicy().withReplication() && !this.getDataPolicy().withPersistence()) {
            return entry.getVersionStamp().hasValidVersion();
        }
        if (!event.isOriginRemote() && event.getDistributedMember() != null && !event.getDistributedMember().equals(this.getMyId())) {
            return event.getVersionTag() == null;
        }
        return false;
    }

    @Override
    protected void checkForNoAccess() {
        if (this.requiresReliabilityCheck && this.isMissingRequiredRoles && this.getMembershipAttributes().getLossAction().isNoAccess()) {
            HashSet<Role> hashSet = this.missingRequiredRoles;
            synchronized (hashSet) {
                if (!this.isMissingRequiredRoles) {
                    return;
                }
                Set<Role> roles = Collections.unmodifiableSet(new HashSet<Role>(this.missingRequiredRoles));
                throw new RegionAccessException(String.format("Operation is disallowed by LossAction %s because these required roles are missing: %s.", this.getMembershipAttributes().getLossAction(), roles), this.getFullPath(), roles);
            }
        }
    }

    @Override
    public void checkForLimitedOrNoAccess() {
        if (this.requiresReliabilityCheck && this.isMissingRequiredRoles && (this.getMembershipAttributes().getLossAction().isNoAccess() || this.getMembershipAttributes().getLossAction().isLimitedAccess())) {
            HashSet<Role> hashSet = this.missingRequiredRoles;
            synchronized (hashSet) {
                if (!this.isMissingRequiredRoles) {
                    return;
                }
                Set<Role> roles = Collections.unmodifiableSet(new HashSet<Role>(this.missingRequiredRoles));
                Assert.assertTrue(!roles.isEmpty());
                throw new RegionAccessException(String.format("Operation is disallowed by LossAction %s because these required roles are missing: %s.", this.getMembershipAttributes().getLossAction(), roles), this.getFullPath(), roles);
            }
        }
    }

    @Override
    public void handleReliableDistribution(Set successfulRecipients) {
        this.handleReliableDistribution(successfulRecipients, Collections.emptySet(), Collections.emptySet());
    }

    private void handleReliableDistribution(Set successfulRecipients, Set otherRecipients1, Set otherRecipients2) {
        if (this.requiresReliabilityCheck) {
            InternalDistributedMember mbr;
            MembershipAttributes ra = this.getMembershipAttributes();
            HashSet<Role> roles = new HashSet<Role>();
            for (Object successfulRecipient : successfulRecipients) {
                mbr = (InternalDistributedMember)successfulRecipient;
                if (mbr == null) continue;
                roles.addAll(mbr.getRoles());
            }
            for (Object anOtherRecipients1 : otherRecipients1) {
                mbr = (InternalDistributedMember)anOtherRecipients1;
                if (mbr == null) continue;
                roles.addAll(mbr.getRoles());
            }
            for (Object anOtherRecipients2 : otherRecipients2) {
                mbr = (InternalDistributedMember)anOtherRecipients2;
                if (mbr == null) continue;
                roles.addAll(mbr.getRoles());
            }
            HashSet<Role> failedRoles = new HashSet<Role>(ra.getRequiredRoles());
            failedRoles.removeAll(roles);
            if (failedRoles.isEmpty()) {
                return;
            }
            throw new RegionDistributionException(String.format("Operation distribution may have failed to notify these required roles: %s", failedRoles), this.getFullPath(), failedRoles);
        }
    }

    boolean isNoDistributionOk() {
        if (this.requiresReliabilityCheck) {
            MembershipAttributes ra = this.getMembershipAttributes();
            Set<Role> failedRoles = ra.getRequiredRoles();
            throw new RegionDistributionException(String.format("Operation distribution was not done to these required roles: %s", failedRoles), this.getFullPath(), failedRoles);
        }
        return true;
    }

    public boolean doesNotDistribute() {
        return false;
    }

    @Override
    public boolean shouldSyncForCrashedMember(InternalDistributedMember id) {
        return !this.doesNotDistribute() && super.shouldSyncForCrashedMember(id);
    }

    @Override
    public boolean requiresReliabilityCheck() {
        return this.requiresReliabilityCheck;
    }

    @Override
    protected boolean isExpirationAllowed(ExpiryTask expiry) {
        if (this.requiresReliabilityCheck && this.isMissingRequiredRoles) {
            if (this.getMembershipAttributes().getLossAction().isNoAccess()) {
                return false;
            }
            return !this.getMembershipAttributes().getLossAction().isLimitedAccess() || !expiry.isDistributedAction();
        }
        return true;
    }

    private boolean resumeReliability(InternalDistributedMember id, Set newlyAcquiredRoles) {
        boolean async = false;
        try {
            ResumptionAction ra = this.getMembershipAttributes().getResumptionAction();
            if (ra.isNone()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Reliability resumption for action of none");
                }
                this.resumeExpiration();
            } else if (ra.isReinitialize()) {
                async = true;
                this.asyncResumeReliability(id, newlyAcquiredRoles);
            }
        }
        catch (Exception e) {
            logger.fatal("Unexpected exception:", (Throwable)e);
        }
        return async;
    }

    private void asyncResumeReliability(InternalDistributedMember id, Set newlyAcquiredRoles) throws RejectedExecutionException {
        ResumptionAction ra = this.getMembershipAttributes().getResumptionAction();
        this.getDistributionManager().getExecutors().getWaitingThreadPool().execute(() -> {
            block8: {
                try {
                    Cloneable event;
                    if (!ra.isReinitialize()) break block8;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Reliability resumption for action of reinitialize");
                    }
                    if (!this.isDestroyed() && !this.cache.isClosed()) {
                        event = new RegionEventImpl((Region)this, Operation.REGION_REINITIALIZE, null, false, (DistributedMember)this.getMyId(), this.generateEventID());
                        this.reinitialize(null, (RegionEventImpl)event);
                    }
                    event = this.missingRequiredRoles;
                    synchronized (event) {
                        this.missingRequiredRoles.notifyAll();
                        if (this.hasListener() && id != null) {
                            RoleEventImpl relEvent = new RoleEventImpl((Region)this, Operation.REGION_CREATE, null, true, (DistributedMember)id, newlyAcquiredRoles);
                            this.dispatchListenerEvent(EnumListenerEvent.AFTER_ROLE_GAIN, relEvent);
                        }
                    }
                }
                catch (Exception e) {
                    logger.fatal("Unexpected exception:", (Throwable)e);
                }
            }
        });
    }

    private void resumeExpiration() {
        boolean isNoAccess = this.getMembershipAttributes().getLossAction().isNoAccess();
        boolean isLimitedAccess = this.getMembershipAttributes().getLossAction().isLimitedAccess();
        if (!isNoAccess && !isLimitedAccess) {
            return;
        }
        if (this.getEntryTimeToLive().getTimeout() > 0 && (isNoAccess || this.getEntryTimeToLive().getAction().isDistributed())) {
            this.rescheduleEntryExpiryTasks();
        } else if (this.getEntryIdleTimeout().getTimeout() > 0 && (isNoAccess || this.getEntryIdleTimeout().getAction().isDistributed())) {
            this.rescheduleEntryExpiryTasks();
        } else if (this.getCustomEntryTimeToLive() != null || this.getCustomEntryIdleTimeout() != null) {
            this.rescheduleEntryExpiryTasks();
        }
        if (this.getRegionTimeToLive().getTimeout() > 0 && (isNoAccess || this.getRegionTimeToLive().getAction().isDistributed())) {
            this.addTTLExpiryTask();
        }
        if (this.getRegionIdleTimeout().getTimeout() > 0 && (isNoAccess || this.getRegionIdleTimeout().getAction().isDistributed())) {
            this.addIdleExpiryTask();
        }
    }

    private boolean lostReliability(InternalDistributedMember id, Set newlyMissingRoles) {
        if (ignoreReconnect) {
            return false;
        }
        boolean async = false;
        try {
            if (this.getMembershipAttributes().getLossAction().isReconnect()) {
                async = true;
                this.doLostReliability(this.isInitializingThread, id, newlyMissingRoles);
            }
        }
        catch (CancelException cce) {
            throw cce;
        }
        catch (Exception e) {
            logger.fatal("Unexpected exception:", (Throwable)e);
        }
        return async;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLostReliability(boolean isInitializing, InternalDistributedMember id, Set newlyMissingRoles) {
        block8: {
            try {
                if (!isInitializing) {
                    LoggingThread thread = new LoggingThread("Reconnect Distributed System", () -> {
                        try {
                            logger.debug("Reliability loss with policy of reconnect and membership thread doing reconnect");
                            this.initializationLatchAfterMemberTimeout.await();
                            this.getSystem().tryReconnect(false, "Role Loss", this.getCache());
                            HashSet<Role> hashSet = this.missingRequiredRoles;
                            synchronized (hashSet) {
                                this.missingRequiredRoles.notifyAll();
                                if (this.hasListener() && id != null) {
                                    RoleEventImpl relEvent = new RoleEventImpl((Region)this, Operation.CACHE_RECONNECT, null, true, (DistributedMember)id, newlyMissingRoles);
                                    this.dispatchListenerEvent(EnumListenerEvent.AFTER_ROLE_LOSS, relEvent);
                                }
                            }
                        }
                        catch (Exception e) {
                            logger.fatal("Unexpected exception:", (Throwable)e);
                        }
                    });
                    thread.start();
                    break block8;
                }
                this.getSystem().tryReconnect(false, "Role Loss", this.getCache());
                HashSet<Role> thread = this.missingRequiredRoles;
                synchronized (thread) {
                    this.missingRequiredRoles.notifyAll();
                    if (this.hasListener() && id != null) {
                        RoleEventImpl relEvent = new RoleEventImpl((Region)this, Operation.CACHE_RECONNECT, null, true, (DistributedMember)id, newlyMissingRoles);
                        this.dispatchListenerEvent(EnumListenerEvent.AFTER_ROLE_LOSS, relEvent);
                    }
                }
            }
            catch (CancelException ignor) {
                throw ignor;
            }
            catch (Exception e) {
                logger.fatal("Unexpected exception:", (Throwable)e);
            }
        }
    }

    private void lockCheckReadiness() {
        this.cache.getCancelCriterion().checkCancelInProgress(null);
        this.checkReadiness();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Object validatedDestroy(Object key, EntryEventImpl event) throws TimeoutException, EntryNotFoundException, CacheWriterException {
        Lock dlock = this.getDistributedLockIfGlobal(key);
        try {
            Object object = super.validatedDestroy(key, event);
            return object;
        }
        finally {
            if (dlock != null) {
                dlock.unlock();
            }
        }
    }

    @Override
    void localDestroyNoCallbacks(Object key) {
        super.localDestroyNoCallbacks(key);
        if (this.getScope().isGlobal()) {
            try {
                this.getLockService().freeResources(key);
            }
            catch (LockServiceDestroyedException lockServiceDestroyedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void localDestroy(Object key, Object aCallbackArgument) throws EntryNotFoundException {
        super.localDestroy(key, aCallbackArgument);
        if (this.getScope().isGlobal()) {
            try {
                this.getLockService().freeResources(key);
            }
            catch (LockServiceDestroyedException lockServiceDestroyedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(Object key, Object aCallbackArgument) throws TimeoutException, EntryNotFoundException {
        this.validateKey(key);
        this.checkReadiness();
        this.checkForLimitedOrNoAccess();
        Lock dlock = this.getDistributedLockIfGlobal(key);
        try {
            this.validatedInvalidate(key, aCallbackArgument);
        }
        finally {
            if (dlock != null) {
                dlock.unlock();
            }
        }
    }

    @Override
    public Lock getRegionDistributedLock() throws IllegalStateException {
        this.lockCheckReadiness();
        this.checkForLimitedOrNoAccess();
        if (!this.scope.isGlobal()) {
            throw new IllegalStateException(String.format("Distribution locks are only supported for regions with GLOBAL scope, not %s", this.scope));
        }
        return new RegionDistributedLock();
    }

    @Override
    public Lock getDistributedLock(Object key) throws IllegalStateException {
        this.validateKey(key);
        this.lockCheckReadiness();
        this.checkForLimitedOrNoAccess();
        if (!this.scope.isGlobal()) {
            throw new IllegalStateException(String.format("Distribution locks are only supported for regions with GLOBAL scope, not %s", this.scope));
        }
        if (this.isLockingSuspendedByCurrentThread()) {
            throw new IllegalStateException("This thread has suspended all locking for this region");
        }
        return new DistributedLock(key);
    }

    @Override
    public void preInitialize() {
        Set<String> allGatewaySenderIds = this.getAllGatewaySenderIds();
        if (!allGatewaySenderIds.isEmpty()) {
            for (GatewaySender sender : this.cache.getAllGatewaySenders()) {
                if (!sender.isParallel() || !allGatewaySenderIds.contains(sender.getId())) continue;
                if (sender.getId().contains("AsyncEventQueue_")) {
                    throw new AsyncEventQueueConfigurationException(String.format("Parallel Async Event Queue %s can not be used with replicated region %s", AsyncEventQueueImpl.getAsyncEventQueueIdFromSenderId(sender.getId()), this.getFullPath()));
                }
                throw new GatewaySenderConfigurationException(String.format("Parallel gateway sender %s can not be used with replicated region %s", sender.getId(), this.getFullPath()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(InputStream snapshotInputStream, InternalDistributedMember imageTarget, InternalRegionArguments internalRegionArgs) throws TimeoutException, IOException, ClassNotFoundException {
        Assert.assertTrue(!this.isInitialized());
        if (logger.isDebugEnabled()) {
            logger.debug("DistributedRegion.initialize BEGIN: {}", (Object)this.getFullPath());
        }
        if (this.scope.isGlobal()) {
            this.getLockService();
        }
        try {
            try {
                PersistentMemberID persistentMemberId = null;
                boolean recoverFromDisk = this.isRecoveryNeeded();
                DiskRegion dskRgn = this.getDiskRegion();
                if (recoverFromDisk) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("DistributedRegion.getInitialImageAndRecovery: Starting Recovery");
                    }
                    dskRgn.initializeOwner(this);
                    if (logger.isDebugEnabled()) {
                        logger.debug("DistributedRegion.getInitialImageAndRecovery: Finished Recovery");
                    }
                    persistentMemberId = dskRgn.getMyPersistentID();
                }
                this.createOQLIndexes(internalRegionArgs, recoverFromDisk);
                if (this.getDataPolicy().withReplication() || this.getDataPolicy().withPreloaded()) {
                    this.getInitialImageAndRecovery(snapshotInputStream, imageTarget, internalRegionArgs, recoverFromDisk, persistentMemberId);
                } else {
                    new CreateRegionProcessor(this).initializeRegion();
                    if (snapshotInputStream != null) {
                        this.releaseBeforeGetInitialImageLatch();
                        this.loadSnapshotDuringInitialization(snapshotInputStream);
                    }
                }
            }
            catch (DiskAccessException dae) {
                this.handleDiskAccessException(dae, true);
                throw dae;
            }
            this.initMembershipRoles();
            this.isInitializingThread = false;
            super.initialize(null, null, null);
        }
        finally {
            this.getEventTracker().setInitialized();
        }
    }

    @Override
    void initialized() {
        new UpdateAttributesProcessor(this).distribute(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getInitialImageAndRecovery(InputStream snapshotInputStream, InternalDistributedMember imageSrc, InternalRegionArguments internalRegionArgs, boolean recoverFromDisk, PersistentMemberID persistentId) throws TimeoutException {
        logger.info("Initializing region {}", (Object)this.getName());
        ImageState imgState = this.getImageState();
        imgState.init();
        boolean targetRecreated = internalRegionArgs.getRecreateFlag();
        if (recoverFromDisk && snapshotInputStream != null) {
            throw new InternalGemFireError(String.format("if loading a snapshot, then should not be recovering; isRecovering= %s ,snapshotStream= %s", true, snapshotInputStream));
        }
        CreateRegionProcessor targetProvider = this.getDataPolicy().withPersistence() ? new CreatePersistentRegionProcessor(this, this.getPersistenceAdvisor(), recoverFromDisk) : new CreateRegionProcessor(this);
        imgState.setInRecovery(false);
        RegionVersionVector recovered_rvv = null;
        if (this.getDataPolicy().withPersistence()) {
            recovered_rvv = this.getVersionVector() == null ? null : this.getVersionVector().getCloneForTransmission();
        }
        targetProvider.initializeRegion();
        if (this.persistenceAdvisor != null) {
            this.persistenceAdvisor.initialize();
        }
        if (!this.isInternalRegion() && !this.isDestroyed) {
            this.cache.getInternalResourceManager().addResourceListener(InternalResourceManager.ResourceType.MEMORY, this);
        }
        this.releaseBeforeGetInitialImageLatch();
        InitialImageOperation.beforeGetInitialImage(this);
        if (snapshotInputStream != null) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("DistributedRegion.getInitialImageAndRecovery: About to load snapshot, isInitialized={}; {}", (Object)this.isInitialized(), (Object)this.getFullPath());
                }
                this.loadSnapshotDuringInitialization(snapshotInputStream);
            }
            catch (IOException | ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            this.cleanUpDestroyedTokensAndMarkGIIComplete(InitialImageOperation.GIIStatus.NO_GII);
            return;
        }
        InitialImageOperation iiop = new InitialImageOperation(this, this.entries);
        CacheDistributionAdvisor.InitialImageAdvice advice = null;
        while (!this.isDestroyed()) {
            boolean attemptGetFromOne;
            advice = targetProvider.getInitialImageAdvice(advice);
            boolean bl = attemptGetFromOne = imageSrc != null || this.getDataPolicy().withPreloaded() && !advice.preloaded.isEmpty() || !advice.replicates.isEmpty();
            if (attemptGetFromOne) {
                InitialImageOperation.GIIStatus ret_preload;
                InitialImageOperation.GIIStatus ret;
                if (recoverFromDisk && LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER) {
                    CacheObserverHolder.getInstance().afterMarkingGIIStarted();
                }
                if (imageSrc != null) {
                    try {
                        ret = iiop.getFromOne(Collections.singleton(imageSrc), targetRecreated, advice, recoverFromDisk, recovered_rvv);
                        if (InitialImageOperation.GIIStatus.didGII(ret)) {
                            this.giiMissingRequiredRoles = false;
                            this.cleanUpDestroyedTokensAndMarkGIIComplete(ret);
                            return;
                        }
                    }
                    finally {
                        imageSrc = null;
                    }
                }
                if (InitialImageOperation.GIIStatus.didGII(ret = iiop.getFromOne(advice.replicates, false, advice, recoverFromDisk, recovered_rvv))) {
                    this.cleanUpDestroyedTokensAndMarkGIIComplete(ret);
                    return;
                }
                if (this.getDataPolicy().isPreloaded() && InitialImageOperation.GIIStatus.didGII(ret_preload = iiop.getFromOne(advice.preloaded, false, advice, recoverFromDisk, recovered_rvv))) {
                    this.cleanUpDestroyedTokensAndMarkGIIComplete(ret_preload);
                    return;
                }
                this.cleanUpAfterFailedGII(recoverFromDisk);
                continue;
            }
            if (this.isDestroyed()) break;
            if (recoverFromDisk) {
                logger.info("Region {} recovered from the local disk. Old persistent ID: {}, new persistent ID {}", (Object)this.getFullPath(), (Object)persistentId, (Object)this.getPersistentID());
                if (persistentId != null) {
                    RegionLogger.logRecovery(this.getFullPath(), persistentId, this.getDistributionManager().getDistributionManagerId());
                }
            } else {
                RegionLogger.logCreate(this.getFullPath(), this.getDistributionManager().getDistributionManagerId());
                if (this.getPersistentID() != null) {
                    RegionLogger.logPersistence(this.getFullPath(), this.getDistributionManager().getDistributionManagerId(), this.getPersistentID());
                    logger.info("Region {} was created on this member with the persistent id {}.", new Object[]{this.getFullPath(), this.getPersistentID()});
                }
            }
            this.cleanUpDestroyedTokensAndMarkGIIComplete(InitialImageOperation.GIIStatus.NO_GII);
            return;
        }
    }

    public void scheduleSynchronizeForLostMember(final InternalDistributedMember member, final VersionSource lostVersionID, long delay) {
        this.getGemFireCache().getCCPTimer().schedule(new SystemTimer.SystemTimerTask(){

            @Override
            public void run2() {
                DistributedRegion.this.performSynchronizeForLostMemberTask(member, lostVersionID);
            }
        }, delay);
    }

    void performSynchronizeForLostMemberTask(InternalDistributedMember member, VersionSource lostVersionID) {
        if (!this.isInitializedWithWait()) {
            return;
        }
        this.synchronizeForLostMember(member, lostVersionID);
    }

    void synchronizeForLostMember(InternalDistributedMember lostMember, VersionSource lostVersionID) {
        if (!this.getConcurrencyChecksEnabled()) {
            return;
        }
        CacheDistributionAdvisor advisor = this.getCacheDistributionAdvisor();
        Set<InternalDistributedMember> targets = advisor.adviseInitializedReplicates();
        for (InternalDistributedMember target : targets) {
            this.synchronizeWith(target, lostVersionID, lostMember);
        }
    }

    private void synchronizeWith(InternalDistributedMember target, VersionSource versionMember, InternalDistributedMember lostMember) {
        InitialImageOperation op = new InitialImageOperation(this, this.entries);
        op.synchronizeWith(target, versionMember, lostMember);
    }

    public void setRegionSynchronizeScheduled(VersionSource lostMemberVersionID) {
        RegionVersionHolder<VersionSource> regionVersionHolder = this.getVersionVector().getHolderForMember(lostMemberVersionID);
        if (regionVersionHolder != null) {
            regionVersionHolder.setRegionSynchronizeScheduled();
        }
    }

    public boolean setRegionSynchronizedWithIfNotScheduled(VersionSource lostMemberVersionID) {
        RegionVersionHolder<VersionSource> regionVersionHolder = this.getVersionVector().getHolderForMember(lostMemberVersionID);
        if (regionVersionHolder != null) {
            return regionVersionHolder.setRegionSynchronizeScheduledOrDoneIfNot();
        }
        return false;
    }

    public boolean isInitializedWithWait() {
        while (!this.isInitialized()) {
            if (this.isDestroyed()) {
                return false;
            }
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("da.syncForCrashedMember waiting for region to finish initializing: {}", (Object)this);
                }
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanUpAfterFailedGII(boolean recoverFromDisk) {
        DiskRegion dskRgn = this.getDiskRegion();
        if (recoverFromDisk && dskRgn != null && dskRgn.isBackup()) {
            dskRgn.resetRecoveredEntries(this);
            return;
        }
        if (!this.getRegionMap().isEmpty()) {
            this.lockFailedInitialImageWriteLock();
            try {
                this.closeEntries();
                if (this.getDiskRegion() != null) {
                    this.getDiskRegion().clear(this, null);
                }
                this.getImageState().getLeftMembers();
                this.getImageState().getVersionTags();
                if (this.indexManager != null) {
                    try {
                        this.indexManager.rerunIndexCreationQuery();
                    }
                    catch (Exception ex) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Exception while clearing indexes after GII failure.", (Throwable)ex);
                        }
                    }
                }
            }
            finally {
                this.unlockFailedInitialImageWriteLock();
            }
        }
    }

    void lockFailedInitialImageWriteLock() {
        this.failedInitialImageLock.writeLock().lock();
    }

    void unlockFailedInitialImageWriteLock() {
        this.failedInitialImageLock.writeLock().unlock();
    }

    void lockFailedInitialImageReadLock() {
        this.failedInitialImageLock.readLock().lock();
    }

    private void unlockFailedInitialImageReadLock() {
        this.failedInitialImageLock.readLock().unlock();
    }

    @Override
    public boolean lockWhenRegionIsInitializing() {
        if (!this.isInitialized()) {
            this.lockFailedInitialImageReadLock();
            return true;
        }
        return false;
    }

    @Override
    public void unlockWhenRegionIsInitializing() {
        this.unlockFailedInitialImageReadLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMembershipRoles() {
        Object object;
        HashSet<Role> hashSet;
        Object others;
        AdvisorListener advisorListener = this.advisorListener;
        synchronized (advisorListener) {
            others = this.distAdvisor.addMembershipListenerAndAdviseGeneric(this.advisorListener);
            this.advisorListener.addMembers((Set<InternalDistributedMember>)others);
            if (this.getMembershipAttributes().hasRequiredRoles()) {
                hashSet = this.missingRequiredRoles;
                synchronized (hashSet) {
                    this.missingRequiredRoles.addAll(this.getMembershipAttributes().getRequiredRoles());
                    this.missingRequiredRoles.removeAll(this.getSystem().getDistributedMember().getRoles());
                    object = others.iterator();
                    while (object.hasNext()) {
                        InternalDistributedMember other1 = object.next();
                        DistributedMember other = other1;
                        this.missingRequiredRoles.removeAll(other.getRoles());
                    }
                }
            }
        }
        if (this.getMembershipAttributes().hasRequiredRoles()) {
            int memberTimeout = this.getSystem().getConfig().getMemberTimeout();
            if (logger.isDebugEnabled()) {
                logger.debug("Waiting up to {} for required roles.", (Object)memberTimeout);
            }
            try {
                if (this.giiMissingRequiredRoles) {
                    this.isInitializingThread = true;
                    others = this.advisorListener;
                    synchronized (others) {
                        hashSet = this.missingRequiredRoles;
                        synchronized (hashSet) {
                            this.isMissingRequiredRoles = true;
                            this.getCachePerfStats().incReliableRegionsMissing(1);
                            if (this.getMembershipAttributes().getLossAction().isAllAccess()) {
                                this.getCachePerfStats().incReliableRegionsMissingFullAccess(1);
                            } else if (this.getMembershipAttributes().getLossAction().isLimitedAccess()) {
                                this.getCachePerfStats().incReliableRegionsMissingLimitedAccess(1);
                            } else if (this.getMembershipAttributes().getLossAction().isNoAccess()) {
                                this.getCachePerfStats().incReliableRegionsMissingNoAccess(1);
                            }
                            if (logger.isDebugEnabled()) {
                                logger.debug("GetInitialImage had missing required roles.");
                            }
                            this.isInitializingThread = true;
                            this.lostReliability(null, null);
                            if (this.missingRequiredRoles.isEmpty()) {
                                this.isMissingRequiredRoles = false;
                                this.getCachePerfStats().incReliableRegionsMissing(-1);
                                if (this.getMembershipAttributes().getLossAction().isAllAccess()) {
                                    this.getCachePerfStats().incReliableRegionsMissingFullAccess(-1);
                                } else if (this.getMembershipAttributes().getLossAction().isLimitedAccess()) {
                                    this.getCachePerfStats().incReliableRegionsMissingLimitedAccess(-1);
                                } else if (this.getMembershipAttributes().getLossAction().isNoAccess()) {
                                    this.getCachePerfStats().incReliableRegionsMissingNoAccess(-1);
                                }
                                boolean async = this.resumeReliability(null, null);
                                if (async) {
                                    this.advisorListener.destroyed = true;
                                }
                            }
                        }
                    }
                }
                if (!this.getSystem().isLoner()) {
                    this.waitForRequiredRoles(memberTimeout);
                }
                boolean initiateLossAction = false;
                hashSet = this.advisorListener;
                synchronized (hashSet) {
                    object = this.missingRequiredRoles;
                    synchronized (object) {
                        if (this.missingRequiredRoles.isEmpty()) {
                            Assert.assertTrue(!this.isMissingRequiredRoles);
                            if (logger.isDebugEnabled()) {
                                logger.debug("Initialization completed with all required roles present.");
                            }
                        } else {
                            this.isMissingRequiredRoles = true;
                            this.getCachePerfStats().incReliableRegionsMissing(1);
                            if (this.getMembershipAttributes().getLossAction().isAllAccess()) {
                                this.getCachePerfStats().incReliableRegionsMissingFullAccess(1);
                            } else if (this.getMembershipAttributes().getLossAction().isLimitedAccess()) {
                                this.getCachePerfStats().incReliableRegionsMissingLimitedAccess(1);
                            } else if (this.getMembershipAttributes().getLossAction().isNoAccess()) {
                                this.getCachePerfStats().incReliableRegionsMissingNoAccess(1);
                            }
                            if (logger.isDebugEnabled()) {
                                logger.debug("Initialization completed with missing required roles: {}", this.missingRequiredRoles);
                            }
                            this.isInitializingThread = true;
                            initiateLossAction = true;
                        }
                    }
                }
                if (initiateLossAction) {
                    this.lostReliability(null, null);
                }
            }
            catch (RegionDestroyedException initiateLossAction) {
            }
            catch (CancelException e) {
                if (this.isInitializingThread) {
                    throw e;
                }
            }
            catch (Exception e) {
                logger.fatal("Unexpected exception:", (Throwable)e);
            }
        }
        this.initializationLatchAfterMemberTimeout.countDown();
    }

    private boolean isRecoveryNeeded() {
        return this.getDataPolicy().withPersistence() && this.getDiskRegion().isRecreated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanUpDestroyedTokensAndMarkGIIComplete(InitialImageOperation.GIIStatus giiStatus) {
        DiskRegion dskRgn = this.getDiskRegion();
        if (dskRgn != null && dskRgn.isBackup()) {
            dskRgn.finishInitializeOwner(this, giiStatus);
        }
        ImageState is = this.getImageState();
        is.lockGII();
        is.getVersionTags();
        is.getLeftMembers();
        RegionVersionVector rvv = is.getClearRegionVersionVector();
        try {
            Iterator<Object> keysIt = this.getImageState().getDestroyedEntries();
            while (keysIt.hasNext()) {
                this.entries.removeIfDestroyed(keysIt.next());
            }
            if (rvv != null) {
                this.clearEntries(rvv);
            }
            if (this.persistenceAdvisor != null) {
                this.persistenceAdvisor.setOnline(InitialImageOperation.GIIStatus.didGII(giiStatus), false, this.getPersistentID());
            }
        }
        finally {
            try {
                this.releaseAfterGetInitialImageLatch();
            }
            finally {
                is.unlockGII();
            }
        }
        if (LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER) {
            CacheObserverHolder.getInstance().afterMarkingGIICompleted();
        }
        logger.info("Initialization of region {} completed", (Object)this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void basicBridgeRemove(Object key, Object expectedOldValue, Object p_callbackArg, ClientProxyMembershipID memberId, boolean fromClient, EntryEventImpl clientEvent) throws TimeoutException, EntryNotFoundException, CacheWriterException {
        Lock lock = this.getDistributedLockIfGlobal(key);
        try {
            super.basicBridgeRemove(key, expectedOldValue, p_callbackArg, memberId, fromClient, clientEvent);
        }
        finally {
            if (lock != null) {
                logger.debug("releasing distributed lock on {}", key);
                lock.unlock();
                this.getLockService().freeResources(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void basicBridgeDestroy(Object key, Object p_callbackArg, ClientProxyMembershipID memberId, boolean fromClient, EntryEventImpl clientEvent) throws TimeoutException, EntryNotFoundException, CacheWriterException {
        Lock lock = this.getDistributedLockIfGlobal(key);
        try {
            super.basicBridgeDestroy(key, p_callbackArg, memberId, fromClient, clientEvent);
        }
        finally {
            if (lock != null) {
                logger.debug("releasing distributed lock on {}", key);
                lock.unlock();
                this.getLockService().freeResources(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void basicBridgeInvalidate(Object key, Object p_callbackArg, ClientProxyMembershipID memberId, boolean fromClient, EntryEventImpl clientEvent) throws TimeoutException, EntryNotFoundException, CacheWriterException {
        Lock lock = this.getDistributedLockIfGlobal(key);
        try {
            super.basicBridgeInvalidate(key, p_callbackArg, memberId, fromClient, clientEvent);
        }
        finally {
            if (lock != null) {
                logger.debug("releasing distributed lock on {}", key);
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void basicDestroy(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) throws EntryNotFoundException, CacheWriterException, TimeoutException {
        boolean hasSeen = false;
        if (this.hasSeenEvent(event)) {
            hasSeen = true;
        }
        this.checkIfReplicatedAndLocalDestroy(event);
        try {
            RegionEntry re;
            boolean invokeWriter = cacheWrite;
            if (this.requiresOneHopForMissingEntry(event) && ((re = this.getRegionEntry(event.getKey())) == null || !this.generateVersionTag)) {
                if (this.getServerProxy() == null) {
                    Assert.assertTrue(!this.getDataPolicy().withReplication() || !this.generateVersionTag);
                }
                if (!event.isBulkOpInProgress() || this.getDataPolicy().withStorage()) {
                    boolean didDistribute = RemoteDestroyMessage.distribute(event, expectedOldValue, !this.generateVersionTag);
                    if (!this.generateVersionTag && !didDistribute) {
                        throw new PersistentReplicatesOfflineException();
                    }
                    if (didDistribute) {
                        if (logger.isTraceEnabled()) {
                            logger.trace("Event after remoteDestroy operation: {}", (Object)event);
                        }
                        invokeWriter = false;
                        if (event.getVersionTag() == null) {
                            return;
                        }
                    }
                }
            }
            super.basicDestroy(event, invokeWriter, expectedOldValue);
            if (this.scope.isGlobal() && event.isOriginRemote()) {
                try {
                    this.getLockService().freeResources(event.getKey());
                }
                catch (LockServiceDestroyedException lockServiceDestroyedException) {
                    // empty catch block
                }
            }
        }
        finally {
            if (hasSeen) {
                if (event.isBulkOpInProgress() && !event.isOriginRemote()) {
                    event.getRemoveAllOperation().addEntry(event, true);
                }
                if (!this.getConcurrencyChecksEnabled() || event.hasValidVersionTag()) {
                    this.distributeDestroy(event, expectedOldValue);
                    event.invokeCallbacks(this, true, false);
                }
            }
        }
    }

    @Override
    public void basicDestroyPart3(RegionEntry re, EntryEventImpl event, boolean inTokenMode, boolean duringRI, boolean invokeCallbacks, Object expectedOldValue) {
        this.distributeDestroy(event, expectedOldValue);
        super.basicDestroyPart3(re, event, inTokenMode, duringRI, invokeCallbacks, expectedOldValue);
    }

    void distributeDestroy(EntryEventImpl event, Object expectedOldValue) {
        if (event.isDistributed() && !event.isOriginRemote() && !event.isBulkOpInProgress()) {
            boolean distribute;
            boolean bl = distribute = !event.getInhibitDistribution();
            if (distribute) {
                DestroyOperation op = new DestroyOperation(event);
                op.distribute();
            }
        }
    }

    @Override
    boolean evictDestroy(EvictableEntry entry) {
        boolean evictDestroyWasDone = super.evictDestroy(entry);
        if (evictDestroyWasDone && this.scope.isGlobal()) {
            try {
                this.getLockService().freeResources(entry.getKey());
            }
            catch (LockServiceDestroyedException lockServiceDestroyedException) {
                // empty catch block
            }
        }
        return evictDestroyWasDone;
    }

    @Override
    void basicInvalidateRegion(RegionEventImpl event) {
        if (!event.getOperation().isDistributed() && this.getScope().isDistributed() && this.getDataPolicy().withReplication()) {
            throw new IllegalStateException("Not allowed to do a local invalidation on a replicated region");
        }
        if (this.shouldDistributeInvalidateRegion(event)) {
            this.distributeInvalidateRegion(event);
        }
        super.basicInvalidateRegion(event);
    }

    protected boolean shouldDistributeInvalidateRegion(RegionEventImpl event) {
        return event.getOperation().isDistributed() && !event.isOriginRemote();
    }

    protected void distributeInvalidateRegion(RegionEventImpl event) {
        new InvalidateRegionOperation(event).distribute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void basicDestroyRegion(RegionEventImpl event, boolean cacheWrite, boolean lock, boolean callbackEvents) throws CacheWriterException, TimeoutException {
        String path = this.getFullPath();
        boolean isClose = event.getOperation().isClose();
        if (!isClose) {
            this.cache.beginDestroy(path, this);
        }
        try {
            super.basicDestroyRegion(event, cacheWrite, lock, callbackEvents);
            if (!event.isOriginRemote()) {
                this.distributeDestroyRegion(event, true);
            } else if (!event.isReinitializing()) {
                RegionEventImpl localEvent = new RegionEventImpl((Region)this, Operation.REGION_LOCAL_DESTROY, event.getCallbackArgument(), false, (DistributedMember)this.getMyId(), this.generateEventID());
                this.distributeDestroyRegion(localEvent, false);
            }
            this.notifyBridgeClients(event);
        }
        catch (CancelException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("basicDestroyRegion short-circuited due to cancellation");
            }
        }
        finally {
            if (!isClose) {
                this.cache.endDestroy(path, this);
            }
            RegionLogger.logDestroy(path, this.getMyId(), this.getPersistentID(), isClose);
        }
    }

    @Override
    void distributeDestroyRegion(RegionEventImpl event, boolean notifyOfRegionDeparture) {
        if (this.persistenceAdvisor != null) {
            this.persistenceAdvisor.releaseTieLock();
        }
        new DestroyRegionOperation(event, notifyOfRegionDeparture).distribute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void basicInvalidate(EntryEventImpl event) throws EntryNotFoundException {
        boolean hasSeen = false;
        if (this.hasSeenEvent(event)) {
            hasSeen = true;
        }
        try {
            RegionEntry re;
            if (event.isLocalInvalid() && !event.getOperation().isLocal() && this.getScope().isDistributed() && this.getDataPolicy().withReplication()) {
                throw new IllegalStateException("Not allowed to do a local invalidation on a replicated region");
            }
            if (this.requiresOneHopForMissingEntry(event) && ((re = this.getRegionEntry(event.getKey())) == null || !this.generateVersionTag)) {
                if (this.getServerProxy() == null) {
                    Assert.assertTrue(!this.getDataPolicy().withReplication() || !this.generateVersionTag);
                }
                boolean didDistribute = RemoteInvalidateMessage.distribute(event, !this.generateVersionTag);
                if (!this.generateVersionTag && !didDistribute) {
                    throw new PersistentReplicatesOfflineException();
                }
                if (didDistribute) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Event after remoteInvalidate operation: {}", (Object)event);
                    }
                    if (event.getVersionTag() == null) {
                        return;
                    }
                }
            }
            super.basicInvalidate(event);
        }
        finally {
            if (hasSeen && (!this.getConcurrencyChecksEnabled() || event.hasValidVersionTag())) {
                this.distributeInvalidate(event);
                event.invokeCallbacks(this, true, false);
            }
        }
    }

    @Override
    void basicInvalidatePart3(RegionEntry re, EntryEventImpl event, boolean invokeCallbacks) {
        this.distributeInvalidate(event);
        super.basicInvalidatePart3(re, event, invokeCallbacks);
    }

    void distributeInvalidate(EntryEventImpl event) {
        if (!this.isRegionInvalid() && event.isDistributed() && !event.isOriginRemote() && !this.isTX() && event.isDistributed() && !event.isOriginRemote()) {
            boolean distribute;
            boolean bl = distribute = !event.getInhibitDistribution();
            if (distribute) {
                InvalidateOperation op = new InvalidateOperation(event);
                op.distribute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void basicUpdateEntryVersion(EntryEventImpl event) throws EntryNotFoundException {
        InternalRegion internalRegion = event.getRegion();
        AbstractRegionMap regionMap = (AbstractRegionMap)internalRegion.getRegionMap();
        regionMap.lockForCacheModification(internalRegion, event);
        boolean locked = internalRegion.lockWhenRegionIsInitializing();
        try {
            try {
                if (!this.hasSeenEvent(event)) {
                    super.basicUpdateEntryVersion(event);
                }
            }
            finally {
                if (!this.getConcurrencyChecksEnabled() || event.hasValidVersionTag()) {
                    this.distributeUpdateEntryVersion(event);
                }
            }
        }
        finally {
            if (locked) {
                internalRegion.unlockWhenRegionIsInitializing();
            }
            regionMap.releaseCacheModificationLock(internalRegion, event);
        }
    }

    void distributeUpdateEntryVersion(EntryEventImpl event) {
        if (!this.isRegionInvalid() && event.isDistributed() && !event.isOriginRemote() && !this.isTX() && event.isDistributed() && !event.isOriginRemote()) {
            UpdateEntryVersionOperation op = new UpdateEntryVersionOperation(event);
            op.distribute();
        }
    }

    @Override
    protected void basicClear(RegionEventImpl regionEvent) {
        Lock dlock = this.getRegionDistributedLockIfGlobal();
        try {
            super.basicClear(regionEvent);
        }
        finally {
            if (dlock != null) {
                dlock.unlock();
            }
        }
    }

    @Override
    void basicClear(RegionEventImpl regionEvent, boolean cacheWrite) {
        if (this.getConcurrencyChecksEnabled() && !this.getDataPolicy().withReplication()) {
            boolean retry = false;
            do {
                Set<InternalDistributedMember> repls;
                if ((repls = this.distAdvisor.adviseReplicates()).isEmpty()) continue;
                InternalDistributedMember mbr = repls.iterator().next();
                RemoteClearMessage op = RemoteClearMessage.create(mbr, this);
                try {
                    op.distribute();
                    return;
                }
                catch (CancelException | RegionDestroyedException | RemoteOperationException e) {
                    this.getCancelCriterion().checkCancelInProgress(e);
                    retry = true;
                }
            } while (retry);
        }
        super.basicClear(regionEvent, cacheWrite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    void cmnClearRegion(RegionEventImpl regionEvent, boolean cacheWrite, boolean useRVV) {
        block11: {
            boolean enableRVV = useRVV && this.getDataPolicy().withReplication() && this.getConcurrencyChecksEnabled() && !this.getDistributionManager().isLoner();
            Object object = this.clearLock;
            synchronized (object) {
                if (enableRVV) {
                    this.distributedLockForClear();
                    try {
                        Set<InternalDistributedMember> participants = this.getCacheDistributionAdvisor().adviseInvalidateRegion();
                        try {
                            this.obtainWriteLocksForClear(regionEvent, participants);
                            this.clearRegionLocally(regionEvent, cacheWrite, null);
                            if (!regionEvent.isOriginRemote() && regionEvent.getOperation().isDistributed()) {
                                DistributedClearOperation.clear(regionEvent, null, participants);
                            }
                            break block11;
                        }
                        finally {
                            this.releaseWriteLocksForClear(regionEvent, participants);
                        }
                    }
                    finally {
                        this.distributedUnlockForClear();
                    }
                }
                Set<InternalDistributedMember> participants = this.getCacheDistributionAdvisor().adviseInvalidateRegion();
                this.clearRegionLocally(regionEvent, cacheWrite, null);
                if (!regionEvent.isOriginRemote() && regionEvent.getOperation().isDistributed()) {
                    DistributedClearOperation.clear(regionEvent, null, participants);
                }
            }
        }
        this.notifyBridgeClients(regionEvent);
    }

    private void distributedLockForClear() {
        if (!this.scope.isGlobal()) {
            try {
                this.getLockService().lock("_clearOperation", -1L, -1L);
            }
            catch (IllegalStateException e) {
                this.lockCheckReadiness();
                throw e;
            }
        }
    }

    private void distributedUnlockForClear() {
        if (!this.scope.isGlobal()) {
            try {
                this.getLockService().unlock("_clearOperation");
            }
            catch (IllegalStateException e) {
                this.lockCheckReadiness();
                throw e;
            }
        }
    }

    private void obtainWriteLocksForClear(RegionEventImpl regionEvent, Set<InternalDistributedMember> participants) {
        this.lockLocallyForClear(this.getDistributionManager(), this.getMyId(), regionEvent);
        DistributedClearOperation.lockAndFlushToOthers(regionEvent, participants);
    }

    void lockLocallyForClear(DistributionManager dm, InternalDistributedMember locker, CacheEvent event) {
        RegionVersionVector rvv = this.getVersionVector();
        RegionMap.ARMLockTestHook armLockTestHook = this.getRegionMap().getARMLockTestHook();
        if (armLockTestHook != null) {
            armLockTestHook.beforeLock(this, event);
        }
        if (rvv != null) {
            rvv.lockForClear(this.getFullPath(), dm, locker);
            this.checkReadiness();
            if (this.getAttributes().getScope().isDistributedNoAck()) {
                Set<InternalDistributedMember> members = this.getDistributionAdvisor().adviseCacheOp();
                StateFlushOperation.flushTo(members, this);
            }
        }
        if (armLockTestHook != null) {
            armLockTestHook.afterLock(this, null);
        }
    }

    private void releaseWriteLocksForClear(RegionEventImpl regionEvent, Set<InternalDistributedMember> participants) {
        RegionMap.ARMLockTestHook armLockTestHook = this.getRegionMap().getARMLockTestHook();
        if (armLockTestHook != null) {
            armLockTestHook.beforeRelease(this, regionEvent);
        }
        this.getVersionVector().unlockForClear(this.getMyId());
        DistributedClearOperation.releaseLocks(regionEvent, participants);
        if (armLockTestHook != null) {
            armLockTestHook.afterRelease(this, regionEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForInProgressClear() {
        RegionVersionVector rvv = this.getVersionVector();
        if (rvv != null) {
            Object object = this.clearLock;
            synchronized (object) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Done waiting for clear");
                }
            }
        }
    }

    protected EventID distributeTombstoneGC(Set<Object> keysRemoved) {
        this.getCachePerfStats().incTombstoneGCCount();
        EventID eventId = new EventID(this.getSystem());
        DistributedTombstoneOperation gc = DistributedTombstoneOperation.gc(this, eventId);
        gc.distribute();
        this.notifyClientsOfTombstoneGC(this.getVersionVector().getTombstoneGCVector(), keysRemoved, eventId, null);
        return eventId;
    }

    @Override
    void basicLocalClear(RegionEventImpl rEvent) {
        if (this.getScope().isDistributed() && this.getDataPolicy().withReplication()) {
            throw new UnsupportedOperationException("localClear is not supported on distributed replicated regions.");
        }
        super.basicLocalClear(rEvent);
    }

    public DistributionConfig getDistributionConfig() {
        return this.getSystem().getDistributionManager().getConfig();
    }

    @Override
    public CacheDistributionAdvisor getDistributionAdvisor() {
        return this.distAdvisor;
    }

    @Override
    public CacheDistributionAdvisor getCacheDistributionAdvisor() {
        return this.distAdvisor;
    }

    public PersistenceAdvisor getPersistenceAdvisor() {
        return this.persistenceAdvisor;
    }

    public PersistentMemberID getPersistentID() {
        return this.persistentId;
    }

    @Override
    public DistributionAdvisor.Profile getProfile() {
        return this.distAdvisor.createProfile();
    }

    @Override
    public void fillInProfile(DistributionAdvisor.Profile profile) {
        assert (profile instanceof CacheDistributionAdvisor.CacheProfile);
        CacheDistributionAdvisor.CacheProfile cacheProfile = (CacheDistributionAdvisor.CacheProfile)profile;
        cacheProfile.dataPolicy = this.getDataPolicy();
        cacheProfile.hasCacheLoader = this.basicGetLoader() != null;
        cacheProfile.hasCacheWriter = this.basicGetWriter() != null;
        cacheProfile.hasCacheListener = this.hasListener();
        Assert.assertTrue(this.scope.isDistributed());
        cacheProfile.scope = this.scope;
        boolean newInRecovery = this.getImageState().getInRecovery();
        if (cacheProfile.getInRecovery() != newInRecovery) {
            this.distAdvisor.incInRecoveryVersion();
        }
        cacheProfile.setInRecovery(newInRecovery);
        cacheProfile.isPersistent = this.getDataPolicy().withPersistence();
        cacheProfile.setSubscriptionAttributes(this.getSubscriptionAttributes());
        cacheProfile.isGatewayEnabled = this.isPdxTypesRegion();
        cacheProfile.serialNumber = this.getSerialNumber();
        cacheProfile.regionInitialized = this.isInitialized();
        cacheProfile.persistentID = this.getPersistentID();
        if (this.getPersistenceAdvisor() != null) {
            cacheProfile.persistenceInitialized = this.getPersistenceAdvisor().isOnline();
        }
        cacheProfile.hasCacheServer = !this.cache.getCacheServers().isEmpty();
        cacheProfile.requiresOldValueInEvents = this.getDataPolicy().withReplication() && this.filterProfile != null && this.filterProfile.hasCQs();
        cacheProfile.gatewaySenderIds = this.getGatewaySenderIds();
        cacheProfile.asyncEventQueueIds = this.getVisibleAsyncEventQueueIds();
        cacheProfile.isOffHeap = this.getOffHeap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DistributedLockService getLockService() {
        Object object = this.dlockMonitor;
        synchronized (object) {
            String dlsName = this.getFullPath();
            if (this.dlockService == null) {
                this.dlockService = DistributedLockService.getServiceNamed(dlsName);
                if (this.dlockService == null) {
                    this.dlockService = DLockService.create(this.getFullPath(), this.getSystem(), true, false, false);
                }
                if (this.isLockGrantor) {
                    this.dlockService.becomeLockGrantor();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("LockService for {} is using LockLease={}, LockTimeout={}", (Object)dlsName, (Object)this.getCache().getLockLease(), (Object)this.getCache().getLockTimeout());
                }
            }
            return this.dlockService;
        }
    }

    @Override
    boolean isCurrentlyLockGrantor() {
        return this.scope.isGlobal() && this.getLockService().isLockGrantor();
    }

    @Override
    public boolean isLockGrantor() {
        return this.scope.isGlobal() && this.isLockGrantor;
    }

    @Override
    public void becomeLockGrantor() {
        this.checkReadiness();
        this.checkForLimitedOrNoAccess();
        if (!this.scope.isGlobal()) {
            throw new IllegalStateException(String.format("Distribution locks are only supported for regions with GLOBAL scope, not %s", this.scope));
        }
        DistributedLockService svc = this.getLockService();
        try {
            super.becomeLockGrantor();
            if (!svc.isLockGrantor()) {
                svc.becomeLockGrantor();
            }
        }
        finally {
            if (!svc.isLockGrantor() && logger.isDebugEnabled()) {
                logger.debug("isLockGrantor is false after becomeLockGrantor for {}", (Object)this.getFullPath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Object findObjectInSystem(KeyInfo keyInfo, boolean isCreate, TXStateInterface txState, boolean generateCallbacks, Object localValue, boolean disableCopyOnRead, boolean preferCD, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent, boolean returnTombstones) throws CacheLoaderException, TimeoutException {
        EntryEventImpl event = null;
        this.checkForLimitedOrNoAccess();
        Operation op = isCreate ? Operation.CREATE : Operation.UPDATE;
        long lastModified = 0L;
        try {
            event = this.findOnServer(keyInfo, op, generateCallbacks, clientEvent);
            if (event == null) {
                event = this.createEventForLoad(keyInfo, generateCallbacks, requestingClient, op);
                lastModified = this.findUsingSearchLoad(txState, localValue, clientEvent, keyInfo, event, preferCD);
            }
            if (event.hasNewValue() && !this.isMemoryThresholdReachedForLoad()) {
                this.putNewValueInRegion(isCreate, clientEvent, lastModified, event);
            } else if (isCreate) {
                this.recordMiss(null, event.getKey());
            }
            Object object = this.determineResult(preferCD, event);
            return object;
        }
        finally {
            if (event != null) {
                event.release();
            }
        }
    }

    private EntryEventImpl createEventForLoad(KeyInfo keyInfo, boolean generateCallbacks, ClientProxyMembershipID requestingClient, Operation op) {
        EntryEventImpl event = EntryEventImpl.create(this, op, keyInfo.getKey(), null, keyInfo.getCallbackArg(), false, this.getMyId(), generateCallbacks);
        if (requestingClient != null) {
            event.setContext(requestingClient);
        }
        return event;
    }

    private Object determineResult(boolean preferCD, EntryEventImpl event) {
        if (preferCD) {
            return event.getRawNewValueAsHeapObject();
        }
        return event.getNewValue();
    }

    private void putNewValueInRegion(boolean isCreate, EntryEventImpl clientEvent, long lastModified, EntryEventImpl event) {
        RegionEntry re;
        block6: {
            re = null;
            event.setNewEventId(this.cache.getDistributedSystem());
            long startPut = this.getStatisticsClock().getTime();
            this.validateKey(event.getKey());
            try {
                re = this.basicPutEntry(event, lastModified);
                if (re != null && clientEvent != null) {
                    clientEvent.setVersionTag(event.getVersionTag());
                }
                if (!this.isTX()) {
                    this.getCachePerfStats().endPut(startPut, event.isOriginRemote());
                }
            }
            catch (ConcurrentCacheModificationException e) {
                this.updateEventWithCurrentRegionEntry(event, clientEvent);
            }
            catch (CacheWriterException cwe) {
                if (!logger.isDebugEnabled()) break block6;
                logger.debug("findObjectInSystem: writer exception putting entry {} : {}", (Object)event, (Object)cwe);
            }
        }
        if (isCreate) {
            this.recordMiss(re, event.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEventWithCurrentRegionEntry(EntryEventImpl event, EntryEventImpl clientEvent) {
        block12: {
            boolean disabled = this.entries.disableLruUpdateCallback();
            try {
                RegionEntry re = this.getRegionEntry(event.getKey());
                if (re == null) break block12;
                RegionEntry regionEntry = re;
                synchronized (regionEntry) {
                    if (clientEvent != null) {
                        clientEvent.setVersionTag(re.getVersionStamp().asVersionTag());
                    }
                    event.setNewValue(re.getValue(this));
                }
            }
            finally {
                if (disabled) {
                    this.entries.enableLruUpdateCallback();
                }
                try {
                    this.entries.lruUpdateCallback();
                }
                catch (DiskAccessException dae) {
                    this.handleDiskAccessException(dae);
                    throw dae;
                }
            }
        }
    }

    private EntryEventImpl findOnServer(KeyInfo keyInfo, Operation op, boolean generateCallbacks, EntryEventImpl clientEvent) {
        if (this.getServerProxy() == null) {
            return null;
        }
        EntryEventImpl event = null;
        VersionTagHolder holder = new VersionTagHolder();
        Object aCallbackArgument = keyInfo.getCallbackArg();
        Object value = this.getServerProxy().get(keyInfo.getKey(), aCallbackArgument, holder);
        if (value != null) {
            event = EntryEventImpl.create(this, op, keyInfo.getKey(), value, aCallbackArgument, false, this.getMyId(), generateCallbacks);
            event.setVersionTag(holder.getVersionTag());
            event.setFromServer(true);
            if (clientEvent != null && clientEvent.getVersionTag() == null) {
                clientEvent.setVersionTag(holder.getVersionTag());
            }
        }
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long findUsingSearchLoad(TXStateInterface txState, Object localValue, EntryEventImpl clientEvent, KeyInfo keyInfo, EntryEventImpl event, boolean preferCD) {
        boolean getForRegisterInterest;
        long lastModified = 0L;
        boolean bl = getForRegisterInterest = clientEvent != null && clientEvent.getOperation() != null && clientEvent.getOperation().isGetForRegisterInterest();
        if (!getForRegisterInterest) {
            SearchLoadAndWriteProcessor processor = SearchLoadAndWriteProcessor.getProcessor();
            try {
                processor.initialize(this, keyInfo.getKey(), keyInfo.getCallbackArg());
                processor.doSearchAndLoad(event, txState, localValue, preferCD);
                if (clientEvent != null && clientEvent.getVersionTag() == null) {
                    clientEvent.setVersionTag(event.getVersionTag());
                }
                lastModified = processor.getLastModified();
            }
            finally {
                processor.release();
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("DistributedRegion.findObjectInSystem skipping loader for region=" + this.getFullPath() + "; key=" + keyInfo.getKey());
        }
        return lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cacheWriteBeforeDestroy(EntryEventImpl event, Object expectedOldValue) throws CacheWriterException, EntryNotFoundException, TimeoutException {
        boolean result = false;
        if (event.isDistributed()) {
            Set netWriteRecipients;
            CacheWriter localWriter = this.basicGetWriter();
            Set set = netWriteRecipients = localWriter == null ? this.distAdvisor.adviseNetWrite() : null;
            if ((localWriter != null || netWriteRecipients != null && !netWriteRecipients.isEmpty()) && !event.inhibitAllNotifications()) {
                long start = this.getCachePerfStats().startCacheWriterCall();
                try {
                    event.setOldValueFromRegion();
                    SearchLoadAndWriteProcessor processor = SearchLoadAndWriteProcessor.getProcessor();
                    try {
                        processor.initialize(this, event.getKey(), null);
                        processor.doNetWrite(event, netWriteRecipients, localWriter, 1);
                        result = true;
                    }
                    finally {
                        processor.release();
                    }
                }
                finally {
                    this.getCachePerfStats().endCacheWriterCall(start);
                }
            }
            this.serverDestroy(event, expectedOldValue);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean cacheWriteBeforeRegionDestroy(RegionEventImpl event) throws CacheWriterException, TimeoutException {
        boolean result = false;
        if (event.getOperation().isDistributed()) {
            Set netWriteRecipients;
            CacheWriter localWriter = this.basicGetWriter();
            Set set = netWriteRecipients = localWriter == null ? this.distAdvisor.adviseNetWrite() : null;
            if (localWriter != null || netWriteRecipients != null && !netWriteRecipients.isEmpty()) {
                long start = this.getCachePerfStats().startCacheWriterCall();
                try {
                    SearchLoadAndWriteProcessor processor = SearchLoadAndWriteProcessor.getProcessor();
                    try {
                        processor.initialize(this, "preDestroyRegion", null);
                        processor.doNetWrite(event, netWriteRecipients, localWriter, 3);
                        result = true;
                    }
                    finally {
                        processor.release();
                    }
                }
                finally {
                    this.getCachePerfStats().endCacheWriterCall(start);
                }
            }
            this.serverRegionDestroy(event);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void distributedRegionCleanup(RegionEventImpl event) {
        if (event == null || event.getOperation() != Operation.REGION_REINITIALIZE) {
            HashSet<Role> hashSet = this.missingRequiredRoles;
            synchronized (hashSet) {
                this.missingRequiredRoles.notifyAll();
            }
        }
        if (this.persistenceAdvisor != null) {
            this.persistenceAdvisor.close();
        }
        this.distAdvisor.close();
        this.waitForInProgressClear();
        DLockService dls = null;
        Object object = this.dlockMonitor;
        synchronized (object) {
            if (this.dlockService != null) {
                dls = (DLockService)this.dlockService;
            }
        }
        if (dls != null) {
            try {
                dls.destroyAndRemove();
            }
            catch (CancelException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("DLS destroy abridged due to shutdown", (Throwable)e);
                }
            }
            catch (Exception ex) {
                logger.warn("DLS destroy may have failed for " + this.getFullPath(), (Throwable)ex);
            }
        }
        this.waitForCurrentOperations();
    }

    private void waitForCurrentOperations() {
        boolean flushOnClose;
        boolean bl = flushOnClose = !Boolean.getBoolean("gemfire.no-flush-on-close");
        if (!this.cache.forcedDisconnect() && flushOnClose && this.getDistributionManager().getDistribution() != null && this.getDistributionManager().getDistribution().isConnected()) {
            this.getDistributionAdvisor().forceNewMembershipVersion();
            try {
                this.getDistributionAdvisor().waitForCurrentOperations();
            }
            catch (Exception e) {
                logger.warn(String.format("%s: error closing region %s", this, this.getFullPath()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postCreateRegion() {
        super.postCreateRegion();
        AdvisorListener advisorListener = this.advisorListener;
        synchronized (advisorListener) {
            Set<InternalDistributedMember> others = this.advisorListener.getInitialMembers();
            CacheListener[] listeners = this.fetchCacheListenersField();
            if (listeners != null) {
                for (CacheListener listener : listeners) {
                    if (!(listener instanceof RegionMembershipListener)) continue;
                    RegionMembershipListener regionMembershipListener = (RegionMembershipListener)listener;
                    try {
                        DistributedMember[] otherDms = others.toArray(new DistributedMember[0]);
                        regionMembershipListener.initialMembers(this, otherDms);
                    }
                    catch (VirtualMachineError err) {
                        SystemFailure.initiateFailure(err);
                        throw err;
                    }
                    catch (Throwable t) {
                        SystemFailure.checkFailure();
                        logger.error("Exception occurred in RegionMembershipListener", t);
                    }
                }
            }
        }
    }

    @Override
    protected void postDestroyRegion(boolean destroyDiskRegion, RegionEventImpl event) {
        this.distributedRegionCleanup(event);
        try {
            super.postDestroyRegion(destroyDiskRegion, event);
        }
        catch (CancelException e) {
            logger.warn("postDestroyRegion: encountered cancellation", (Throwable)e);
        }
    }

    @Override
    public void cleanupFailedInitialization() {
        super.cleanupFailedInitialization();
        try {
            RegionEventImpl ev = new RegionEventImpl((Region)this, Operation.REGION_CLOSE, null, false, (DistributedMember)this.getMyId(), this.generateEventID());
            this.distributeDestroyRegion(ev, true);
            this.distributedRegionCleanup(null);
        }
        catch (RegionDestroyedException ev) {
        }
        catch (CancelException ev) {
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            logger.warn("Error cleaning up after failed region initialization of region " + this, t);
        }
    }

    @Override
    public void handleCacheClose(Operation operation) {
        try {
            super.handleCacheClose(operation);
        }
        finally {
            this.distributedRegionCleanup(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cacheWriteBeforePut(EntryEventImpl event, Set netWriteRecipients, CacheWriter localWriter, boolean requireOldValue, Object expectedOldValue) throws CacheWriterException, TimeoutException {
        if ((localWriter != null || netWriteRecipients != null && !netWriteRecipients.isEmpty()) && !event.inhibitAllNotifications()) {
            boolean isNewKey = event.getOperation().isCreate();
            long start = this.getCachePerfStats().startCacheWriterCall();
            try {
                SearchLoadAndWriteProcessor processor = SearchLoadAndWriteProcessor.getProcessor();
                processor.initialize(this, "preUpdate", null);
                try {
                    if (!isNewKey) {
                        processor.doNetWrite(event, netWriteRecipients, localWriter, 2);
                    } else {
                        processor.doNetWrite(event, netWriteRecipients, localWriter, 0);
                    }
                }
                finally {
                    processor.release();
                }
            }
            finally {
                this.getCachePerfStats().endCacheWriterCall(start);
            }
        }
        this.serverPut(event, requireOldValue, expectedOldValue);
    }

    @Override
    protected void cacheListenersChanged(boolean nowHasListener) {
        if (nowHasListener) {
            this.advisorListener.initRMLWrappers();
        }
        new UpdateAttributesProcessor(this).distribute();
    }

    @Override
    protected void cacheWriterChanged(CacheWriter oldWriter) {
        super.cacheWriterChanged(oldWriter);
        if (oldWriter == null ^ this.basicGetWriter() == null) {
            new UpdateAttributesProcessor(this).distribute();
        }
    }

    @Override
    protected void cacheLoaderChanged(CacheLoader oldLoader) {
        super.cacheLoaderChanged(oldLoader);
        if (oldLoader == null ^ this.basicGetLoader() == null) {
            new UpdateAttributesProcessor(this).distribute();
        }
    }

    @Override
    public void addGatewaySenderId(String gatewaySenderId) {
        super.addGatewaySenderId(gatewaySenderId);
        new UpdateAttributesProcessor(this).distribute();
        this.updateSenderIdMonitor();
    }

    @Override
    public void removeGatewaySenderId(String gatewaySenderId) {
        super.removeGatewaySenderId(gatewaySenderId);
        new UpdateAttributesProcessor(this).distribute();
        this.updateSenderIdMonitor();
    }

    @Override
    public void addAsyncEventQueueId(String asyncEventQueueId) {
        super.addAsyncEventQueueId(asyncEventQueueId);
        new UpdateAttributesProcessor(this).distribute();
        this.updateSenderIdMonitor();
    }

    @Override
    public void removeAsyncEventQueueId(String asyncEventQueueId) {
        super.removeAsyncEventQueueId(asyncEventQueueId);
        new UpdateAttributesProcessor(this).distribute();
        this.updateSenderIdMonitor();
    }

    SenderIdMonitor createSenderIdMonitor() {
        return SenderIdMonitor.createSenderIdMonitor(this, this.distAdvisor);
    }

    void updateSenderIdMonitor() {
        this.senderIdMonitor.update();
    }

    @Override
    void checkSameSenderIdsAvailableOnAllNodes() {
        this.senderIdMonitor.checkSenderIds();
    }

    private boolean isLockingSuspendedByCurrentThread() {
        try {
            return this.getLockService().isLockingSuspendedByCurrentThread();
        }
        catch (IllegalStateException e) {
            this.lockCheckReadiness();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lock getDistributedLockIfGlobal(Object key) throws TimeoutException {
        if (this.getScope().isGlobal()) {
            long timeLeft;
            if (this.isLockingSuspendedByCurrentThread()) {
                return null;
            }
            long start = System.currentTimeMillis();
            long lockTimeout = timeLeft = (long)this.getCache().getLockTimeout();
            String msg = null;
            Object[] msgArgs = null;
            while (timeLeft > 0L || lockTimeout == -1L) {
                this.cache.getCancelCriterion().checkCancelInProgress(null);
                boolean interrupted = Thread.interrupted();
                try {
                    Lock dlock = this.getDistributedLock(key);
                    if (dlock.tryLock(timeLeft, TimeUnit.SECONDS)) {
                        Lock lock = dlock;
                        return lock;
                    }
                    msg = "Attempt to acquire distributed lock for %s failed after waiting %s seconds.";
                    msgArgs = new Object[]{key, (System.currentTimeMillis() - start) / 1000L};
                    break;
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                    this.cache.getCancelCriterion().checkCancelInProgress(ex);
                    if (lockTimeout <= -1L) continue;
                    timeLeft = (long)this.getCache().getLockTimeout() - (System.currentTimeMillis() - start) / 1000L;
                }
                finally {
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                }
            }
            if (msg == null) {
                msg = "Timed out after waiting %s seconds for the distributed lock for %s.";
                msgArgs = new Object[]{this.getCache().getLockTimeout(), key};
            }
            throw new TimeoutException(String.format(msg, msgArgs));
        }
        return null;
    }

    protected boolean checkEntryNotValid(RegionEntry mapEntry) {
        return mapEntry == null || mapEntry.isRemoved() && !mapEntry.isTombstone();
    }

    @Override
    public Iterator<RegionEntry> getBestIterator(boolean includeValues) {
        DiskRegion dr = this.getDiskRegion();
        if (DiskPage.DISK_PAGE_SIZE > 0L && includeValues && dr != null) {
            dr.waitForAsyncRecovery();
            if (dr.getNumOverflowOnDisk() > 0L) {
                return new DiskSavvyIterator();
            }
        }
        return this.entries.regionEntries().iterator();
    }

    private long getLockLeaseForLock() {
        if (this.getCache().getLockLease() == -1) {
            return -1L;
        }
        return (long)this.getCache().getLockLease() * 1000L;
    }

    private long getLockTimeoutForLock(long time, TimeUnit unit) {
        if (time == -1L) {
            return -1L;
        }
        return TimeUnit.MILLISECONDS.convert(time, unit);
    }

    private Lock getRegionDistributedLockIfGlobal() throws TimeoutException {
        if (this.getScope().isGlobal()) {
            if (this.isLockingSuspendedByCurrentThread()) {
                return null;
            }
            Lock dlock = this.getRegionDistributedLock();
            dlock.lock();
            return dlock;
        }
        return null;
    }

    @Override
    public long postPutAllSend(DistributedPutAllOperation putAllOp, VersionedObjectList successfulPuts) {
        long token = -1L;
        if (putAllOp.putAllDataSize > 0) {
            token = putAllOp.startOperation();
        } else if (logger.isDebugEnabled()) {
            logger.debug("DR.postPutAll: no data to distribute");
        }
        return token;
    }

    @Override
    public long postRemoveAllSend(DistributedRemoveAllOperation op, VersionedObjectList successfulOps) {
        long token = -1L;
        if (op.removeAllDataSize > 0) {
            token = op.startOperation();
        } else {
            this.getCache().getLogger().fine("DR.postRemoveAll: no data to distribute");
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    VersionedObjectList basicPutAll(Map<?, ?> map, DistributedPutAllOperation putAllOp, Map<Object, VersionTag> retryVersions) {
        Lock dlock = this.getRegionDistributedLockIfGlobal();
        try {
            VersionedObjectList versionedObjectList = super.basicPutAll(map, putAllOp, retryVersions);
            return versionedObjectList;
        }
        finally {
            if (dlock != null) {
                dlock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VersionedObjectList basicRemoveAll(Collection<Object> keys, DistributedRemoveAllOperation removeAllOp, List<VersionTag> retryVersions) {
        Lock dlock = this.getRegionDistributedLockIfGlobal();
        try {
            VersionedObjectList versionedObjectList = super.basicRemoveAll(keys, removeAllOp, retryVersions);
            return versionedObjectList;
        }
        finally {
            if (dlock != null) {
                dlock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set waitForRequiredRoles(long timeout) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        this.checkReadiness();
        if (!this.getMembershipAttributes().hasRequiredRoles()) {
            throw new IllegalStateException("Region has not been configured with required roles.");
        }
        if (!this.isMissingRequiredRoles) {
            if (logger.isDebugEnabled()) {
                logger.debug("No missing required roles to wait for.");
            }
            return Collections.emptySet();
        }
        if (timeout != 0L) {
            if (timeout == -1L) {
                while (this.isMissingRequiredRoles) {
                    this.checkReadiness();
                    this.cache.getCancelCriterion().checkCancelInProgress(null);
                    HashSet<Role> hashSet = this.missingRequiredRoles;
                    synchronized (hashSet) {
                        if (this.isMissingRequiredRoles) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("About to wait for missing required roles.");
                            }
                            this.missingRequiredRoles.wait();
                        }
                    }
                }
            } else {
                long endTime = System.currentTimeMillis() + timeout;
                while (this.isMissingRequiredRoles) {
                    this.checkReadiness();
                    this.cache.getCancelCriterion().checkCancelInProgress(null);
                    HashSet<Role> hashSet = this.missingRequiredRoles;
                    synchronized (hashSet) {
                        if (this.isMissingRequiredRoles) {
                            long timeToWait = endTime - System.currentTimeMillis();
                            if (timeToWait <= 0L) {
                                break;
                            }
                            if (logger.isDebugEnabled()) {
                                logger.debug("About to wait up to {} milliseconds for missing required roles.", (Object)timeToWait);
                            }
                            this.missingRequiredRoles.wait(timeToWait);
                        }
                    }
                }
            }
        }
        this.checkReadiness();
        if (this.isMissingRequiredRoles) {
            HashSet<Role> hashSet = this.missingRequiredRoles;
            synchronized (hashSet) {
                return Collections.unmodifiableSet(new HashSet<Role>(this.missingRequiredRoles));
            }
        }
        return Collections.emptySet();
    }

    public boolean isRoleInRegionMembership(Role role) {
        this.checkReadiness();
        return this.basicIsRoleInRegionMembership(role);
    }

    private boolean basicIsRoleInRegionMembership(Role role) {
        if (this.getSystem().getDistributedMember().getRoles().contains(role)) {
            return true;
        }
        for (DistributedMember distributedMember : this.distAdvisor.adviseGeneric()) {
            Set<Role> roles = distributedMember.getRoles();
            if (!roles.contains(role)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remoteRegionInitialized(CacheDistributionAdvisor.CacheProfile profile) {
        AdvisorListener advisorListener = this.advisorListener;
        synchronized (advisorListener) {
            if (this.advisorListener.members == null && this.hasListener()) {
                CacheDistributionAdvisor.CacheProfile callback = TEST_HOOK_ADD_PROFILE ? profile : null;
                RegionEventImpl event = new RegionEventImpl(this, Operation.REGION_CREATE, callback, true, profile.peerMemberId);
                this.dispatchListenerEvent(EnumListenerEvent.AFTER_REMOTE_REGION_CREATE, event);
            }
        }
    }

    @Override
    void removeSenderFromAdvisor(InternalDistributedMember sender, int serial, boolean regionDestroyed) {
        this.getDistributionAdvisor().removeIdWithSerial(sender, serial, regionDestroyed);
    }

    @Override
    public DistributionAdvisee getParentAdvisee() {
        return (DistributionAdvisee)((Object)this.basicGetParentRegion());
    }

    @Override
    public DistributedMember getOwnerForKey(KeyInfo key) {
        assert (!this.isInternalRegion() || this.isMetaRegionWithTransactions());
        if (!this.getAttributes().getDataPolicy().withStorage() || this.getConcurrencyChecksEnabled() && this.getAttributes().getDataPolicy() == DataPolicy.NORMAL) {
            return this.getRandomReplicate();
        }
        if (this.getConcurrencyChecksEnabled() && !this.generateVersionTag) {
            return this.getRandomPersistentReplicate();
        }
        return super.getOwnerForKey(key);
    }

    @Override
    public ResultCollector executeFunction(DistributedRegionFunctionExecutor execution, Function function, Object args, ResultCollector rc, Set filter, ServerToClientFunctionResultSender sender) {
        DistributedMember target = this.getTransactionalNode();
        if (target != null) {
            if (target.equals(this.getMyId())) {
                return this.executeLocally(execution, function, args, 0, rc, filter, sender);
            }
            return this.executeOnReplicate(execution, function, args, rc, filter, target);
        }
        if (this.getAttributes().getDataPolicy().withReplication() || this.getAttributes().getDataPolicy().withPreloaded()) {
            Set<InternalDistributedMember> singleMember = Collections.singleton(this.getMyId());
            execution.validateExecution(function, singleMember);
            execution.setExecutionNodes(singleMember);
            return this.executeLocally(execution, function, args, 0, rc, filter, sender);
        }
        target = this.getRandomReplicate();
        if (target == null) {
            throw new FunctionException(String.format("No Replicated Region found for executing function : %s.", function.getId()));
        }
        LocalResultCollector<?, ?> localRC = execution.getLocalResultCollector(function, rc);
        return this.executeOnReplicate(execution, function, args, localRC, filter, target);
    }

    private ResultCollector executeOnReplicate(DistributedRegionFunctionExecutor execution, Function function, Object args, ResultCollector rc, Set filter, DistributedMember target) {
        Set<InternalDistributedMember> singleMember = Collections.singleton((InternalDistributedMember)target);
        execution.validateExecution(function, singleMember);
        execution.setExecutionNodes(singleMember);
        HashMap<InternalDistributedMember, Object> memberArgs = new HashMap<InternalDistributedMember, Object>();
        memberArgs.put((InternalDistributedMember)target, execution.getArgumentsForMember(target.getId()));
        DistributedRegionFunctionResultSender resultSender = new DistributedRegionFunctionResultSender(null, rc, function, execution.getServerResultSender());
        DistributedRegionFunctionResultWaiter waiter = new DistributedRegionFunctionResultWaiter(this.getSystem(), this.getFullPath(), rc, function, filter, Collections.singleton(target), memberArgs, resultSender);
        rc = waiter.getFunctionResultFrom(Collections.singleton(target), function, execution);
        return rc;
    }

    private DistributedMember getTransactionalNode() {
        if (this.cache.getTxManager().getTXState() != null) {
            return this.cache.getTxManager().getTXState().getTarget();
        }
        return null;
    }

    private InternalDistributedMember getRandomReplicate() {
        GetRandomReplicate getReplicate = new GetRandomReplicate();
        this.getCacheDistributionAdvisor().accept(getReplicate, null);
        return getReplicate.member;
    }

    private InternalDistributedMember getRandomPersistentReplicate() {
        GetRandomReplicate getPersistentReplicate = new GetRandomReplicate(true);
        this.getCacheDistributionAdvisor().accept(getPersistentReplicate, null);
        return getPersistentReplicate.member;
    }

    void executeOnRegion(DistributedRegionFunctionStreamingMessage msg, Function function, Object args, int prid, Set filter, boolean isReExecute) throws IOException {
        DistributionManager dm = this.getDistributionManager();
        DistributedRegionFunctionResultSender resultSender = new DistributedRegionFunctionResultSender(dm, msg, function);
        RegionFunctionContextImpl context = new RegionFunctionContextImpl(this.cache, function.getId(), this, args, filter, null, null, resultSender, isReExecute);
        FunctionStats stats = FunctionStatsManager.getFunctionStats(function.getId(), dm.getSystem());
        long start = stats.startFunctionExecution(function.hasResult());
        try {
            function.execute(context);
            stats.endFunctionExecution(start, function.hasResult());
        }
        catch (FunctionException functionException) {
            if (logger.isDebugEnabled()) {
                logger.debug("FunctionException occurred on remote node  while executing Function: {}", (Object)function.getId(), (Object)functionException);
            }
            stats.endFunctionExecutionWithException(start, function.hasResult());
            throw functionException;
        }
        catch (CacheClosedException cacheClosedexception) {
            if (logger.isDebugEnabled()) {
                logger.debug("CacheClosedException occurred on remote node  while executing Function: {}", (Object)function.getId(), (Object)cacheClosedexception);
            }
            throw cacheClosedexception;
        }
        catch (Exception exception) {
            if (logger.isDebugEnabled()) {
                logger.debug("Exception occurred on remote node  while executing Function: {}", (Object)function.getId(), (Object)exception);
            }
            stats.endFunctionExecutionWithException(start, function.hasResult());
            throw new FunctionException(exception);
        }
    }

    private ResultCollector executeLocally(DistributedRegionFunctionExecutor execution, Function function, Object args, int prid, ResultCollector rc, Set filter, ServerToClientFunctionResultSender sender) {
        LocalResultCollector<?, ?> localRC = execution.getLocalResultCollector(function, rc);
        DistributionManager dm = this.getDistributionManager();
        DistributedRegionFunctionResultSender resultSender = new DistributedRegionFunctionResultSender(dm, localRC, function, sender);
        RegionFunctionContextImpl context = new RegionFunctionContextImpl(this.cache, function.getId(), this, args, filter, null, null, resultSender, execution.isReExecute());
        execution.executeFunctionOnLocalNode(function, context, resultSender, dm, this.isTX());
        return localRC;
    }

    @Override
    void setMemoryThresholdFlag(MemoryEvent event) {
        Set<InternalDistributedMember> others = this.getCacheDistributionAdvisor().adviseGeneric();
        if (event.isLocal() || others.contains(event.getMember())) {
            if (event.getState().isCritical() && !event.getPreviousState().isCritical() && (event.getType() == InternalResourceManager.ResourceType.HEAP_MEMORY || event.getType() == InternalResourceManager.ResourceType.OFFHEAP_MEMORY && this.getOffHeap())) {
                this.addCriticalMember(event.getMember());
            } else if (!event.getState().isCritical() && event.getPreviousState().isCritical() && (event.getType() == InternalResourceManager.ResourceType.HEAP_MEMORY || event.getType() == InternalResourceManager.ResourceType.OFFHEAP_MEMORY && this.getOffHeap())) {
                this.removeCriticalMember(event.getMember());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCriticalMember(DistributedMember member) {
        if (logger.isDebugEnabled()) {
            logger.debug("DR: removing member {} from critical member list", (Object)member);
        }
        Set<DistributedMember> set = this.memoryThresholdReachedMembers;
        synchronized (set) {
            this.memoryThresholdReachedMembers.remove(member);
            if (this.memoryThresholdReachedMembers.isEmpty()) {
                this.setMemoryThresholdReached(false);
            }
        }
    }

    @Override
    void initialCriticalMembers(boolean localMemoryIsCritical, Set<InternalDistributedMember> criticalMembers) {
        Set<InternalDistributedMember> others = this.getCacheDistributionAdvisor().adviseGeneric();
        for (InternalDistributedMember idm : criticalMembers) {
            if (!others.contains(idm)) continue;
            this.addCriticalMember(idm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCriticalMember(DistributedMember idm) {
        Set<DistributedMember> set = this.memoryThresholdReachedMembers;
        synchronized (set) {
            if (this.memoryThresholdReachedMembers.isEmpty()) {
                this.setMemoryThresholdReached(true);
            }
            this.memoryThresholdReachedMembers.add(idm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MemoryThresholdInfo getAtomicThresholdInfo() {
        if (!this.isMemoryThresholdReached()) {
            return MemoryThresholdInfo.getNotReached();
        }
        Set<DistributedMember> set = this.memoryThresholdReachedMembers;
        synchronized (set) {
            return new MemoryThresholdInfo(this.isMemoryThresholdReached(), new HashSet<DistributedMember>(this.memoryThresholdReachedMembers));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected VersionTag fetchRemoteVersionTag(Object key) {
        VersionTag<?> tag = null;
        assert (this.getDataPolicy() != DataPolicy.REPLICATE);
        TXStateProxy tx = this.cache.getTXMgr().pauseTransaction();
        try {
            boolean retry = true;
            InternalDistributedMember member = this.getRandomReplicate();
            while (retry) {
                try {
                    if (member == null) {
                        break;
                    }
                    RemoteFetchVersionMessage.FetchVersionResponse response = RemoteFetchVersionMessage.send(member, this, key);
                    tag = response.waitForResponse();
                    retry = false;
                }
                catch (RemoteOperationException e) {
                    member = this.getRandomReplicate();
                    if (member == null || !logger.isDebugEnabled()) continue;
                    logger.debug("Retrying RemoteFetchVersionMessage on member:{}", (Object)member);
                }
            }
        }
        finally {
            this.cache.getTXMgr().unpauseTransaction(tx);
        }
        return tag;
    }

    public boolean hasNetLoader() {
        return this.hasNetLoader(this.getCacheDistributionAdvisor());
    }

    @Override
    long getLatestLastAccessTimeFromOthers(Object key) {
        LatestLastAccessTimeOperation<Object> op = new LatestLastAccessTimeOperation<Object>(this, key);
        return op.getLatestLastAccessTime();
    }

    @Override
    public Set adviseNetWrite() {
        return this.getCacheDistributionAdvisor().adviseNetWrite();
    }

    @VisibleForTesting
    public SenderIdMonitor getSenderIdMonitor() {
        return this.senderIdMonitor;
    }

    static class GetRandomReplicate
    implements DistributionAdvisor.ProfileVisitor<DistributedMember> {
        private boolean onlyPersistent = false;
        InternalDistributedMember member = null;
        private int randIndex = -1;

        GetRandomReplicate() {
        }

        GetRandomReplicate(boolean onlyPersistent) {
            this.onlyPersistent = onlyPersistent;
        }

        @Override
        public boolean visit(DistributionAdvisor advisor, DistributionAdvisor.Profile profile, int profileIndex, int numProfiles, DistributedMember member) {
            CacheDistributionAdvisor.CacheProfile cp = (CacheDistributionAdvisor.CacheProfile)profile;
            if (this.randIndex < 0) {
                this.randIndex = PartitionedRegion.RANDOM.nextInt(numProfiles);
            }
            if (cp.dataPolicy.withReplication() && cp.regionInitialized) {
                if (this.onlyPersistent && !cp.dataPolicy.withPersistence()) {
                    return true;
                }
                this.member = cp.getDistributedMember();
                return profileIndex < this.randIndex;
            }
            return true;
        }
    }

    protected class AdvisorListener
    implements MembershipListener {
        Set<InternalDistributedMember> members = new HashSet<InternalDistributedMember>();
        protected boolean destroyed = false;

        protected AdvisorListener() {
        }

        synchronized void addMembers(Set<InternalDistributedMember> newMembers) {
            this.members.addAll(newMembers);
        }

        protected synchronized Set<InternalDistributedMember> getInitialMembers() {
            Set<InternalDistributedMember> initMembers = this.members;
            this.members = null;
            return initMembers;
        }

        @Override
        public void quorumLost(DistributionManager distributionManager, Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
        }

        @Override
        public void memberSuspect(DistributionManager distributionManager, InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
        }

        synchronized void initRMLWrappers() {
            Set<InternalDistributedMember> membersWithThisRegion = DistributedRegion.this.distAdvisor.adviseGeneric();
            DistributedRegion.this.initPostCreateRegionMembershipListeners(membersWithThisRegion);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void memberJoined(DistributionManager distributionManager, InternalDistributedMember id) {
            if (this.destroyed) {
                return;
            }
            if (this.members != null) {
                this.members.add(id);
            }
            if (DistributedRegion.this.getMembershipAttributes().hasRequiredRoles()) {
                Set newlyAcquiredRoles = Collections.emptySet();
                HashSet hashSet = DistributedRegion.this.missingRequiredRoles;
                synchronized (hashSet) {
                    if (DistributedRegion.this.isMissingRequiredRoles) {
                        Set<Role> roles = id.getRoles();
                        newlyAcquiredRoles = new HashSet(DistributedRegion.this.missingRequiredRoles);
                        newlyAcquiredRoles.retainAll(roles);
                        if (!newlyAcquiredRoles.isEmpty()) {
                            DistributedRegion.this.missingRequiredRoles.removeAll(newlyAcquiredRoles);
                            if (this.members == null && DistributedRegion.this.missingRequiredRoles.isEmpty()) {
                                DistributedRegion.this.isMissingRequiredRoles = false;
                                DistributedRegion.this.getCachePerfStats().incReliableRegionsMissing(-1);
                                if (DistributedRegion.this.getMembershipAttributes().getLossAction().isAllAccess()) {
                                    DistributedRegion.this.getCachePerfStats().incReliableRegionsMissingFullAccess(-1);
                                } else if (DistributedRegion.this.getMembershipAttributes().getLossAction().isLimitedAccess()) {
                                    DistributedRegion.this.getCachePerfStats().incReliableRegionsMissingLimitedAccess(-1);
                                } else if (DistributedRegion.this.getMembershipAttributes().getLossAction().isNoAccess()) {
                                    DistributedRegion.this.getCachePerfStats().incReliableRegionsMissingNoAccess(-1);
                                }
                                boolean async = DistributedRegion.this.resumeReliability(id, newlyAcquiredRoles);
                                if (async) {
                                    this.destroyed = true;
                                }
                            }
                        }
                    }
                    if (!this.destroyed) {
                        DistributedRegion.this.missingRequiredRoles.notifyAll();
                    }
                }
                if (!this.destroyed && this.members == null && DistributedRegion.this.hasListener() && !newlyAcquiredRoles.isEmpty()) {
                    RoleEventImpl relEvent = new RoleEventImpl((Region)DistributedRegion.this, Operation.REGION_CREATE, null, true, (DistributedMember)id, newlyAcquiredRoles);
                    DistributedRegion.this.dispatchListenerEvent(EnumListenerEvent.AFTER_ROLE_GAIN, relEvent);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void memberDeparted(DistributionManager distributionManager, InternalDistributedMember id, boolean crashed) {
            if (this.destroyed) {
                return;
            }
            if (this.members != null) {
                this.members.remove(id);
            }
            if (this.members == null && DistributedRegion.this.hasListener()) {
                RegionEventImpl event = new RegionEventImpl(DistributedRegion.this, Operation.REGION_CLOSE, null, true, id);
                if (crashed) {
                    DistributedRegion.this.dispatchListenerEvent(EnumListenerEvent.AFTER_REMOTE_REGION_CRASH, event);
                } else if (DestroyRegionOperation.isRegionDepartureNotificationOk()) {
                    DistributedRegion.this.dispatchListenerEvent(EnumListenerEvent.AFTER_REMOTE_REGION_DEPARTURE, event);
                }
            }
            if (DistributedRegion.this.getMembershipAttributes().hasRequiredRoles()) {
                Set newlyMissingRoles = Collections.emptySet();
                HashSet hashSet = DistributedRegion.this.missingRequiredRoles;
                synchronized (hashSet) {
                    Set<Role> roles = id.getRoles();
                    for (Role role : roles) {
                        boolean async;
                        if (!DistributedRegion.this.getMembershipAttributes().getRequiredRoles().contains(role) || DistributedRegion.this.basicIsRoleInRegionMembership(role)) continue;
                        if (newlyMissingRoles.isEmpty()) {
                            newlyMissingRoles = new HashSet();
                        }
                        newlyMissingRoles.add(role);
                        if (this.members != null || DistributedRegion.this.isMissingRequiredRoles) continue;
                        DistributedRegion.this.isMissingRequiredRoles = true;
                        DistributedRegion.this.getCachePerfStats().incReliableRegionsMissing(1);
                        if (DistributedRegion.this.getMembershipAttributes().getLossAction().isAllAccess()) {
                            DistributedRegion.this.getCachePerfStats().incReliableRegionsMissingFullAccess(1);
                        } else if (DistributedRegion.this.getMembershipAttributes().getLossAction().isLimitedAccess()) {
                            DistributedRegion.this.getCachePerfStats().incReliableRegionsMissingLimitedAccess(1);
                        } else if (DistributedRegion.this.getMembershipAttributes().getLossAction().isNoAccess()) {
                            DistributedRegion.this.getCachePerfStats().incReliableRegionsMissingNoAccess(1);
                        }
                        if (!(async = DistributedRegion.this.lostReliability(id, newlyMissingRoles))) continue;
                        this.destroyed = true;
                    }
                    if (!this.destroyed) {
                        DistributedRegion.this.missingRequiredRoles.addAll(newlyMissingRoles);
                        DistributedRegion.this.missingRequiredRoles.notifyAll();
                    }
                }
                if (!this.destroyed && this.members == null && DistributedRegion.this.hasListener() && !newlyMissingRoles.isEmpty()) {
                    RoleEventImpl relEvent = new RoleEventImpl((Region)DistributedRegion.this, Operation.REGION_CLOSE, null, true, (DistributedMember)id, newlyMissingRoles);
                    DistributedRegion.this.dispatchListenerEvent(EnumListenerEvent.AFTER_ROLE_LOSS, relEvent);
                }
            }
        }
    }

    private class RegionDistributedLock
    implements Lock {
        RegionDistributedLock() {
        }

        @Override
        public void lock() {
            try {
                boolean locked = DistributedRegion.this.getLockService().suspendLocking(-1L);
                Assert.assertTrue(locked, "Failed to acquire RegionDistributedLock");
            }
            catch (IllegalStateException ex) {
                DistributedRegion.this.lockCheckReadiness();
                throw ex;
            }
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            try {
                boolean locked = DistributedRegion.this.getLockService().suspendLockingInterruptibly(-1L);
                Assert.assertTrue(locked, "Failed to acquire RegionDistributedLock");
            }
            catch (IllegalStateException ex) {
                DistributedRegion.this.lockCheckReadiness();
                throw ex;
            }
        }

        @Override
        public boolean tryLock() {
            try {
                return DistributedRegion.this.getLockService().suspendLocking(0L);
            }
            catch (IllegalStateException ex) {
                DistributedRegion.this.lockCheckReadiness();
                throw ex;
            }
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            try {
                return DistributedRegion.this.getLockService().suspendLockingInterruptibly(DistributedRegion.this.getLockTimeoutForLock(time, unit));
            }
            catch (IllegalStateException ex) {
                DistributedRegion.this.lockCheckReadiness();
                throw ex;
            }
        }

        @Override
        public void unlock() {
            try {
                DistributedRegion.this.getLockService().resumeLocking();
            }
            catch (IllegalStateException ex) {
                DistributedRegion.this.lockCheckReadiness();
                throw ex;
            }
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException("newCondition unsupported");
        }
    }

    private class DistributedLock
    implements Lock {
        private final Object key;

        DistributedLock(Object key) {
            this.key = key;
        }

        @Override
        public void lock() {
            try {
                boolean locked = this.basicTryLock(-1L, TimeUnit.MILLISECONDS, false);
                if (!locked) {
                    DistributedRegion.this.lockCheckReadiness();
                }
                Assert.assertTrue(locked, "Failed to acquire DistributedLock");
            }
            catch (IllegalStateException ex) {
                DistributedRegion.this.lockCheckReadiness();
                throw ex;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                DistributedRegion.this.lockCheckReadiness();
                Assert.assertTrue(false, "Failed to acquire DistributedLock");
            }
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            try {
                boolean locked = this.basicTryLock(-1L, TimeUnit.MILLISECONDS, true);
                if (!locked) {
                    DistributedRegion.this.lockCheckReadiness();
                }
                Assert.assertTrue(locked, "Failed to acquire DistributedLock");
            }
            catch (IllegalStateException ex) {
                DistributedRegion.this.lockCheckReadiness();
                throw ex;
            }
        }

        @Override
        public boolean tryLock() {
            try {
                ReplyProcessor21.forceSevereAlertProcessing();
                boolean bl = DistributedRegion.this.getLockService().lock(this.key, 0L, DistributedRegion.this.getLockLeaseForLock());
                return bl;
            }
            catch (IllegalStateException ex) {
                DistributedRegion.this.lockCheckReadiness();
                throw ex;
            }
            finally {
                ReplyProcessor21.unforceSevereAlertProcessing();
            }
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return this.basicTryLock(time, unit, true);
        }

        private boolean basicTryLock(long time, TimeUnit unit, boolean interruptible) throws InterruptedException {
            long waitInterval;
            long ackWaitThreshold;
            long end;
            DistributionManager dm = DistributedRegion.this.getDistributionManager();
            long start = System.currentTimeMillis();
            long timeoutMS = DistributedRegion.this.getLockTimeoutForLock(time, unit);
            if (timeoutMS < 0L) {
                timeoutMS = Long.MAX_VALUE;
                end = Long.MAX_VALUE;
            } else {
                end = start + timeoutMS;
            }
            long ackSAThreshold = (long)DistributedRegion.this.getSystem().getConfig().getAckSevereAlertThreshold() * 1000L;
            if (ackSAThreshold > 0L) {
                waitInterval = ackWaitThreshold = (long)DistributedRegion.this.getSystem().getConfig().getAckWaitThreshold() * 1000L;
            } else {
                waitInterval = timeoutMS;
                ackWaitThreshold = 0L;
            }
            boolean suspected = false;
            boolean severeAlertIssued = false;
            DistributedMember lockHolder = null;
            do {
                try {
                    DLockRemoteToken remoteToken;
                    long elapsed;
                    waitInterval = Math.min(end - System.currentTimeMillis(), waitInterval);
                    ReplyProcessor21.forceSevereAlertProcessing();
                    boolean gotLock = interruptible ? DistributedRegion.this.getLockService().lockInterruptibly(this.key, waitInterval, DistributedRegion.this.getLockLeaseForLock()) : DistributedRegion.this.getLockService().lock(this.key, waitInterval, DistributedRegion.this.getLockLeaseForLock());
                    if (gotLock) {
                        boolean bl = true;
                        return bl;
                    }
                    if (ackSAThreshold <= 0L || (elapsed = System.currentTimeMillis() - start) <= ackWaitThreshold) continue;
                    if (!suspected) {
                        suspected = true;
                        severeAlertIssued = false;
                        waitInterval = ackSAThreshold;
                        remoteToken = ((DLockService)DistributedRegion.this.getLockService()).queryLock(this.key);
                        lockHolder = remoteToken.getLessee();
                        if (lockHolder == null) continue;
                        dm.getDistribution().suspectMember((InternalDistributedMember)lockHolder, "Has not released a global region entry lock in over " + ackWaitThreshold / 1000L + " seconds");
                        continue;
                    }
                    if (elapsed <= ackSAThreshold) continue;
                    remoteToken = ((DLockService)DistributedRegion.this.getLockService()).queryLock(this.key);
                    if (lockHolder != null && remoteToken.getLessee() != null && lockHolder.equals(remoteToken.getLessee())) {
                        if (severeAlertIssued) continue;
                        severeAlertIssued = true;
                        logger.fatal("{} seconds have elapsed waiting for global region entry lock held by {}", (Object)(ackWaitThreshold + ackSAThreshold), (Object)lockHolder);
                        continue;
                    }
                    suspected = false;
                    waitInterval = ackWaitThreshold;
                    lockHolder = null;
                }
                catch (IllegalStateException ex) {
                    DistributedRegion.this.lockCheckReadiness();
                    throw ex;
                }
                finally {
                    ReplyProcessor21.unforceSevereAlertProcessing();
                }
            } while (System.currentTimeMillis() < end);
            return false;
        }

        @Override
        public void unlock() {
            try {
                ReplyProcessor21.forceSevereAlertProcessing();
                DistributedRegion.this.getLockService().unlock(this.key);
                if (!DistributedRegion.this.entries.containsKey(this.key)) {
                    DistributedRegion.this.getLockService().freeResources(this.key);
                }
            }
            catch (IllegalStateException ex) {
                DistributedRegion.this.lockCheckReadiness();
                throw ex;
            }
            finally {
                ReplyProcessor21.unforceSevereAlertProcessing();
            }
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException("newCondition unsupported");
        }
    }

    static class DiskPage
    extends DiskPosition {
        static final long DISK_PAGE_SIZE = Long.getLong("gemfire.DISK_PAGE_SIZE", 8192L);

        DiskPage(DiskPosition diskPosition) {
            this.setPosition(diskPosition.oplogId, diskPosition.offset / DISK_PAGE_SIZE);
        }
    }

    public static class DiskPosition
    implements Comparable<DiskPosition> {
        long oplogId;
        long offset;

        DiskPosition() {
        }

        public void setPosition(long oplogId, long offset) {
            this.oplogId = oplogId;
            this.offset = offset;
        }

        public int hashCode() {
            return Long.valueOf(this.oplogId ^ this.offset).hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof DiskPosition) {
                DiskPosition other = (DiskPosition)obj;
                return this.oplogId == other.oplogId && this.offset == other.offset;
            }
            return false;
        }

        @Override
        public int compareTo(DiskPosition o) {
            int result = Long.signum(this.oplogId - o.oplogId);
            if (result == 0) {
                result = Long.signum(this.offset - o.offset);
            }
            return result;
        }

        public String toString() {
            return "<" + this.oplogId + ':' + this.offset + '>';
        }
    }

    private class DiskSavvyIterator
    implements Iterator<RegionEntry> {
        private boolean usingIt = true;
        private Iterator<?> it;
        private Iterator<RegionEntry> subIt;
        private final TreeMap<DiskPage, Object> diskMap;

        DiskSavvyIterator() {
            this.it = DistributedRegion.this.entries.regionEntries().iterator();
            this.subIt = null;
            this.diskMap = new TreeMap();
        }

        @Override
        public boolean hasNext() {
            boolean result;
            if (this.subIt != null) {
                result = this.subIt.hasNext();
                if (!result) {
                    this.subIt = null;
                } else {
                    return result;
                }
            }
            result = this.it.hasNext();
            if (this.usingIt && !result) {
                this.usingIt = false;
                this.it = this.diskMap.values().iterator();
                result = this.it.hasNext();
            }
            return result;
        }

        @Override
        public RegionEntry next() {
            block5: {
                RegionEntry regionEntry;
                block6: {
                    do {
                        ArrayList<RegionEntry> list;
                        DiskPosition diskPosition;
                        if (this.subIt != null) {
                            return this.subIt.next();
                        }
                        if (!this.usingIt) break block5;
                        regionEntry = (RegionEntry)this.it.next();
                        if (!regionEntry.isOverflowedToDisk(DistributedRegion.this, diskPosition = new DiskPosition())) break block6;
                        DiskPage dPage = new DiskPage(diskPosition);
                        Object value = this.diskMap.get(dPage);
                        if (value == null) {
                            this.diskMap.put(dPage, regionEntry);
                            continue;
                        }
                        if (value instanceof ArrayList) {
                            list = (ArrayList<RegionEntry>)value;
                            list.add(regionEntry);
                            continue;
                        }
                        list = new ArrayList<RegionEntry>();
                        list.add((RegionEntry)value);
                        list.add(regionEntry);
                        this.diskMap.put(dPage, list);
                    } while (this.hasNext());
                    throw new NoSuchElementException();
                }
                return regionEntry;
            }
            Object value = this.it.next();
            if (value instanceof ArrayList) {
                List list = (List)value;
                this.subIt = list.iterator();
                return this.subIt.next();
            }
            return (RegionEntry)value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

