/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.UUID;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.cache.DiskStoreFactory;
import org.apache.geode.internal.cache.DiskDirSizesUnit;
import org.apache.geode.internal.cache.DiskStoreMonitor;
import org.apache.geode.internal.cache.persistence.DefaultDiskDirs;

public class DiskStoreAttributes
implements Serializable,
DiskStore {
    private static final long serialVersionUID = 1L;
    public boolean allowForceCompaction = false;
    public boolean autoCompact = true;
    public int compactionThreshold = 50;
    public int queueSize = 0;
    public int writeBufferSize = 32768;
    public long maxOplogSizeInBytes = DiskStoreFactory.DEFAULT_MAX_OPLOG_SIZE * 0x100000L;
    public long timeInterval = 1000L;
    public int[] diskDirSizes;
    private DiskDirSizesUnit diskDirSizesUnit;
    public File[] diskDirs = DefaultDiskDirs.getDefaultDiskDirs();
    public String name;
    private volatile float diskUsageWarningPct = 90.0f;
    private volatile float diskUsageCriticalPct = 99.0f;
    @Immutable
    static final DiskDirSizesUnit DEFAULT_DISK_DIR_SIZES_UNIT = DiskDirSizesUnit.MEGABYTES;

    public DiskStoreAttributes() {
        this.diskDirSizes = DiskStoreFactory.DEFAULT_DISK_DIR_SIZES;
        this.diskDirSizesUnit = DEFAULT_DISK_DIR_SIZES_UNIT;
    }

    @Override
    public UUID getDiskStoreUUID() {
        throw new UnsupportedOperationException("Not Implemented!");
    }

    @Override
    public boolean getAllowForceCompaction() {
        return this.allowForceCompaction;
    }

    @Override
    public boolean getAutoCompact() {
        return this.autoCompact;
    }

    @Override
    public int getCompactionThreshold() {
        return this.compactionThreshold;
    }

    @Override
    public int[] getDiskDirSizes() {
        int[] result = new int[this.diskDirSizes.length];
        System.arraycopy(this.diskDirSizes, 0, result, 0, this.diskDirSizes.length);
        return result;
    }

    public DiskDirSizesUnit getDiskDirSizesUnit() {
        return this.diskDirSizesUnit;
    }

    @Override
    public File[] getDiskDirs() {
        File[] result = new File[this.diskDirs.length];
        System.arraycopy(this.diskDirs, 0, result, 0, this.diskDirs.length);
        return result;
    }

    @Override
    public long getMaxOplogSize() {
        return this.maxOplogSizeInBytes / 0x100000L;
    }

    public long getMaxOplogSizeInBytes() {
        return this.maxOplogSizeInBytes;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getQueueSize() {
        return this.queueSize;
    }

    @Override
    public long getTimeInterval() {
        return this.timeInterval;
    }

    @Override
    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    @Override
    public void flush() {
    }

    @Override
    public void forceRoll() {
    }

    @Override
    public boolean forceCompaction() {
        return false;
    }

    @Override
    public void destroy() {
    }

    @Override
    public float getDiskUsageWarningPercentage() {
        return this.diskUsageWarningPct;
    }

    @Override
    public float getDiskUsageCriticalPercentage() {
        return this.diskUsageCriticalPct;
    }

    @Override
    public void setDiskUsageWarningPercentage(float warningPercent) {
        DiskStoreMonitor.checkWarning(warningPercent);
        this.diskUsageWarningPct = warningPercent;
    }

    @Override
    public void setDiskUsageCriticalPercentage(float criticalPercent) {
        DiskStoreMonitor.checkCritical(criticalPercent);
        this.diskUsageCriticalPct = criticalPercent;
    }

    public void setDiskDirSizesUnit(DiskDirSizesUnit unit) {
        this.diskDirSizesUnit = unit;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.diskDirSizesUnit == null) {
            this.diskDirSizesUnit = DEFAULT_DISK_DIR_SIZES_UNIT;
        }
    }

    public static void checkMinAndMaxOplogSize(long maxOplogSize) {
        long MAX = 0x7FFFFFFFFFFL;
        if (maxOplogSize > MAX) {
            throw new IllegalArgumentException(String.format("%s has to be a number that does not exceed %s so the value given %s is not acceptable", "max oplog size", maxOplogSize, MAX));
        }
        DiskStoreAttributes.checkMinOplogSize(maxOplogSize);
    }

    public static void checkMinOplogSize(long maxOplogSize) {
        if (maxOplogSize < 0L) {
            throw new IllegalArgumentException(String.format("Maximum Oplog size specified has to be a non-negative number and the value given %s is not acceptable", maxOplogSize));
        }
    }

    public static void checkQueueSize(int queueSize) {
        if (queueSize < 0) {
            throw new IllegalArgumentException(String.format("Queue size specified has to be a non-negative number and the value given %s is not acceptable", queueSize));
        }
    }

    public static void checkWriteBufferSize(int writeBufferSize) {
        if (writeBufferSize < 0) {
            throw new IllegalArgumentException(String.format("Write buffer size specified has to be a non-negative number and the value given %s is not acceptable", writeBufferSize));
        }
    }

    public static void verifyNonNegativeDirSize(int[] sizes) {
        for (int size : sizes) {
            if (size >= 0) continue;
            throw new IllegalArgumentException(String.format("Dir size cannot be negative : %s", size));
        }
    }

    public static void checkTimeInterval(long timeInterval) {
        if (timeInterval < 0L) {
            throw new IllegalArgumentException(String.format("Time Interval specified has to be a non-negative number and the value given %s is not acceptable", timeInterval));
        }
    }
}

