/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DurableClientAttributes;
import org.apache.geode.distributed.Role;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.distributed.internal.membership.InternalRole;
import org.apache.geode.distributed.internal.membership.api.MemberData;
import org.apache.geode.distributed.internal.membership.api.MemberDataBuilder;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifier;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifierFactoryImpl;
import org.apache.geode.internal.cache.versions.VersionSource;
import org.apache.geode.internal.inet.LocalHostUtil;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.internal.serialization.VersionOrdinal;
import org.apache.geode.logging.internal.OSProcess;
import org.jgroups.util.UUID;

public class InternalDistributedMember
implements DistributedMember,
Externalizable,
DistributionAdvisor.ProfileId,
VersionSource<DistributedMember>,
MemberIdentifier,
DataSerializableFixedID {
    private static final long serialVersionUID = -2785249969777296507L;
    public static final int DEFAULT_DURABLE_CLIENT_TIMEOUT = 300;
    @Immutable
    public static final MemberIdentifierFactoryImpl MEMBER_IDENTIFIER_FACTORY = new MemberIdentifierFactoryImpl();
    private final MemberIdentifier memberIdentifier;
    @VisibleForTesting
    protected volatile DurableClientAttributes durableClientAttributes;

    public InternalDistributedMember() {
        this.memberIdentifier = MEMBER_IDENTIFIER_FACTORY.create(null);
    }

    public InternalDistributedMember(InetAddress i, int membershipPort, boolean splitBrainEnabled, boolean canBeCoordinator) {
        this.memberIdentifier = MEMBER_IDENTIFIER_FACTORY.create(MemberDataBuilder.newBuilder((InetAddress)i, (String)InternalDistributedMember.getHostName(i)).setMembershipPort(membershipPort).setNetworkPartitionDetectionEnabled(splitBrainEnabled).setPreferredForCoordinator(canBeCoordinator).build());
    }

    private static String getHostName(InetAddress i) {
        return SocketCreator.resolve_dns ? SocketCreator.getHostName(i) : i.getHostAddress();
    }

    public InternalDistributedMember(MemberData m) {
        this.memberIdentifier = MEMBER_IDENTIFIER_FACTORY.create(m);
        if (this.getHostName() == null || this.isPartial()) {
            String hostName = InternalDistributedMember.getHostName(m.getInetAddress());
            this.memberIdentifier.setHostName(hostName);
        }
    }

    @VisibleForTesting
    public InternalDistributedMember(String i, int p) {
        this(MemberDataBuilder.newBuilderForLocalHost((String)i).setMembershipPort(p).build());
    }

    public InternalDistributedMember(ServerLocation location) {
        this.memberIdentifier = MEMBER_IDENTIFIER_FACTORY.create(MemberDataBuilder.newBuilderForLocalHost((String)location.getHostName()).setMembershipPort(location.getPort()).setNetworkPartitionDetectionEnabled(false).setPreferredForCoordinator(true).build());
    }

    public InternalDistributedMember(String host, int p, String n, String u, int vmKind, String[] groups, DurableClientAttributes attr) {
        this.durableClientAttributes = attr;
        this.memberIdentifier = MEMBER_IDENTIFIER_FACTORY.create(InternalDistributedMember.createMemberData(host, p, n, vmKind, groups, attr, u));
        this.defaultToCurrentHost();
    }

    private static MemberData createMemberData(String host, int p, String n, int vmKind, String[] groups, DurableClientAttributes attr, String u) {
        InetAddress addr = LocalHostUtil.toInetAddress((String)host);
        MemberDataBuilder builder = MemberDataBuilder.newBuilder((InetAddress)addr, (String)host).setName(n).setMembershipPort(p).setDirectChannelPort(p).setPreferredForCoordinator(false).setNetworkPartitionDetectionEnabled(true).setVmKind(vmKind).setUniqueTag(u).setGroups(groups);
        if (attr != null) {
            builder.setDurableId(attr.getId()).setDurableTimeout(attr.getTimeout());
        }
        return builder.build();
    }

    public InternalDistributedMember(InetAddress i, int p) {
        this.memberIdentifier = MEMBER_IDENTIFIER_FACTORY.create(MemberDataBuilder.newBuilder((InetAddress)i, (String)"localhost").setMembershipPort(p).build());
        this.defaultToCurrentHost();
    }

    public InternalDistributedMember(InetAddress addr, int p, boolean isCurrentHost) {
        this.memberIdentifier = MEMBER_IDENTIFIER_FACTORY.create(MemberDataBuilder.newBuilder((InetAddress)addr, (String)"localhost").setMembershipPort(p).build());
        if (isCurrentHost) {
            this.defaultToCurrentHost();
        }
    }

    public static InternalDistributedMember readEssentialData(DataInput in) throws IOException, ClassNotFoundException {
        InternalDistributedMember mbr = new InternalDistributedMember();
        mbr._readEssentialData(in, InternalDistributedMember::getHostName);
        return mbr;
    }

    @Override
    public DurableClientAttributes getDurableClientAttributes() {
        assert (!this.isPartial());
        if (this.durableClientAttributes == null) {
            String durableId = this.memberIdentifier.getDurableId();
            this.durableClientAttributes = durableId == null || durableId.isEmpty() ? new DurableClientAttributes("", 300) : new DurableClientAttributes(durableId, this.memberIdentifier.getDurableTimeout());
        }
        return this.durableClientAttributes;
    }

    @Override
    public Set<Role> getRoles() {
        if (this.getGroups() == null) {
            return Collections.emptySet();
        }
        return this.getGroups().stream().map(InternalRole::getRole).collect(Collectors.toSet());
    }

    @Override
    public int compareTo(DistributedMember o) {
        return this.compareTo(o, false, true);
    }

    private int compareTo(DistributedMember o, boolean compareMemberData, boolean compareViewIds) {
        if (this == o) {
            return 0;
        }
        if (!(o instanceof InternalDistributedMember)) {
            throw new ClassCastException("InternalDistributedMember.compareTo(): comparison between different classes");
        }
        InternalDistributedMember other = (InternalDistributedMember)o;
        return this.compareTo(other.memberIdentifier, compareMemberData, compareViewIds);
    }

    public int compareTo(MemberIdentifier memberIdentifier, boolean compareMemberData, boolean compareViewIds) {
        return this.memberIdentifier.compareTo(memberIdentifier, compareMemberData, compareViewIds);
    }

    private void defaultToCurrentHost() {
        this.memberIdentifier.setProcessId(OSProcess.getId());
        try {
            if (SocketCreator.resolve_dns) {
                this.setHostName(LocalHostUtil.getLocalHostName());
            } else {
                this.setHostName(LocalHostUtil.getLocalHost().getHostAddress());
            }
        }
        catch (UnknownHostException ee) {
            throw new InternalGemFireError(ee);
        }
    }

    public int getDSFID() {
        return 92;
    }

    public void setDurableTimeout(int newValue) {
        this.memberIdentifier.setDurableTimeout(newValue);
        this.durableClientAttributes = null;
    }

    public void setDurableId(String id) {
        this.memberIdentifier.setDurableId(id);
        this.durableClientAttributes = null;
    }

    public void setMemberData(MemberData m) {
        this.memberIdentifier.setMemberData(m);
        this.durableClientAttributes = null;
    }

    public InetAddress getInetAddress() {
        return this.memberIdentifier.getInetAddress();
    }

    public int getMembershipPort() {
        return this.memberIdentifier.getMembershipPort();
    }

    public short getVersionOrdinal() {
        return this.memberIdentifier.getVersionOrdinal();
    }

    public int getDirectChannelPort() {
        return this.memberIdentifier.getDirectChannelPort();
    }

    public int getVmKind() {
        return this.memberIdentifier.getVmKind();
    }

    public int getMemberWeight() {
        return this.memberIdentifier.getMemberWeight();
    }

    public int getVmViewId() {
        return this.memberIdentifier.getVmViewId();
    }

    public boolean preferredForCoordinator() {
        return this.memberIdentifier.preferredForCoordinator();
    }

    @Override
    public List<String> getGroups() {
        return this.memberIdentifier.getGroups();
    }

    public void setVmViewId(int p) {
        this.memberIdentifier.setVmViewId(p);
    }

    public void setPreferredForCoordinator(boolean preferred) {
        this.memberIdentifier.setPreferredForCoordinator(preferred);
    }

    public void setDirectChannelPort(int dcPort) {
        this.memberIdentifier.setDirectChannelPort(dcPort);
    }

    public void setVmKind(int dmType) {
        this.memberIdentifier.setVmKind(dmType);
    }

    @Override
    public String getName() {
        return this.memberIdentifier.getName();
    }

    public boolean isPartial() {
        return this.memberIdentifier.isPartial();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalDistributedMember that = (InternalDistributedMember)o;
        return this.memberIdentifier.equals(that.memberIdentifier);
    }

    public int hashCode() {
        return this.memberIdentifier.hashCode();
    }

    public String toString() {
        return this.memberIdentifier.toString();
    }

    public void addFixedToString(StringBuilder sb, boolean useIpAddress) {
        this.memberIdentifier.addFixedToString(sb, useIpAddress);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.memberIdentifier.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.memberIdentifier.readExternal(in);
        this.durableClientAttributes = null;
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        this.memberIdentifier.toData(out, context);
    }

    public void toDataPre_GFE_9_0_0_0(DataOutput out, SerializationContext context) throws IOException {
        this.memberIdentifier.toDataPre_GFE_9_0_0_0(out, context);
    }

    public void toDataPre_GFE_7_1_0_0(DataOutput out, SerializationContext context) throws IOException {
        this.memberIdentifier.toDataPre_GFE_7_1_0_0(out, context);
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.memberIdentifier.fromData(in, context);
        this.durableClientAttributes = null;
    }

    public void fromDataPre_GFE_9_0_0_0(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.memberIdentifier.fromDataPre_GFE_9_0_0_0(in, context);
        this.durableClientAttributes = null;
    }

    public void fromDataPre_GFE_7_1_0_0(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.memberIdentifier.fromDataPre_GFE_7_1_0_0(in, context);
        this.durableClientAttributes = null;
    }

    public void _readEssentialData(DataInput in, Function<InetAddress, String> hostnameResolver) throws IOException, ClassNotFoundException {
        this.memberIdentifier._readEssentialData(in, hostnameResolver);
    }

    @Override
    public void writeEssentialData(DataOutput out) throws IOException {
        this.memberIdentifier.writeEssentialData(out);
    }

    public void setPort(int p) {
        this.memberIdentifier.setPort(p);
    }

    public MemberData getMemberData() {
        return this.memberIdentifier.getMemberData();
    }

    public String getHostName() {
        return this.memberIdentifier.getHostName();
    }

    @Override
    public String getHost() {
        return this.memberIdentifier.getHost();
    }

    @Override
    public int getProcessId() {
        return this.memberIdentifier.getProcessId();
    }

    @Override
    public String getId() {
        return this.memberIdentifier.getId();
    }

    @Override
    public String getUniqueId() {
        return this.memberIdentifier.getUniqueId();
    }

    public void setVersionObjectForTest(Version v) {
        this.memberIdentifier.setVersionObjectForTest(v);
    }

    public VersionOrdinal getVersionOrdinalObject() {
        return this.memberIdentifier.getVersionOrdinalObject();
    }

    public Version getVersionObject() {
        return Version.fromOrdinalNoThrow((short)this.getVersionOrdinalObject().ordinal(), (boolean)false);
    }

    public Version[] getSerializationVersions() {
        return this.memberIdentifier.getSerializationVersions();
    }

    public String getUniqueTag() {
        return this.memberIdentifier.getUniqueTag();
    }

    public void setUniqueTag(String tag) {
        this.memberIdentifier.setUniqueTag(tag);
    }

    public void setIsPartial(boolean value) {
        this.memberIdentifier.setIsPartial(value);
    }

    public void setName(String name) {
        this.memberIdentifier.setName(name);
    }

    public String getDurableId() {
        return this.memberIdentifier.getDurableId();
    }

    public int getDurableTimeout() {
        return this.memberIdentifier.getDurableTimeout();
    }

    public void setHostName(String hostName) {
        this.memberIdentifier.setHostName(hostName);
    }

    public void setProcessId(int id) {
        this.memberIdentifier.setProcessId(id);
    }

    public boolean hasUUID() {
        return this.memberIdentifier.hasUUID();
    }

    public long getUuidLeastSignificantBits() {
        return this.memberIdentifier.getUuidLeastSignificantBits();
    }

    public long getUuidMostSignificantBits() {
        return this.memberIdentifier.getUuidMostSignificantBits();
    }

    public boolean isNetworkPartitionDetectionEnabled() {
        return this.memberIdentifier.isNetworkPartitionDetectionEnabled();
    }

    public void setUUID(UUID randomUUID) {
        this.memberIdentifier.setUUID(randomUUID);
    }

    public void setMemberWeight(byte b) {
        this.memberIdentifier.setMemberWeight(b);
    }

    public void setUdpPort(int i) {
        this.memberIdentifier.setUdpPort(i);
    }

    public UUID getUUID() {
        return this.memberIdentifier.getUUID();
    }

    @FunctionalInterface
    public static interface HostnameResolver {
        public InetAddress getInetAddress(ServerLocation var1) throws UnknownHostException;
    }
}

