/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.util.concurrent.Callable;
import org.apache.geode.cache.client.AllConnectionsInUseException;
import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.ExecuteRegionFunctionOp;
import org.apache.geode.cache.client.internal.ExecuteRegionFunctionSingleHopOp;
import org.apache.geode.cache.client.internal.InternalPool;
import org.apache.geode.cache.client.internal.UserAttributes;
import org.apache.geode.distributed.internal.ServerLocation;

public class SingleHopOperationCallable
implements Callable {
    private final ServerLocation server;
    private final InternalPool pool;
    private final AbstractOp op;
    private final UserAttributes securityAttributes;

    public SingleHopOperationCallable(ServerLocation server, InternalPool pool, AbstractOp op, UserAttributes securityAttributes) {
        this.server = server;
        this.pool = pool;
        this.op = op;
        this.securityAttributes = securityAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object call() throws Exception {
        this.op.initMessagePart();
        Object result = null;
        boolean onlyUseExistingCnx = this.pool.getMaxConnections() != -1 && this.pool.getConnectionCount() >= this.pool.getMaxConnections();
        this.op.setAllowDuplicateMetadataRefresh(!onlyUseExistingCnx);
        try {
            UserAttributes.userAttributes.set(this.securityAttributes);
            result = this.pool.executeOn(this.server, this.op, true, onlyUseExistingCnx);
        }
        catch (AllConnectionsInUseException ex) {
            if (this.op instanceof ExecuteRegionFunctionSingleHopOp.ExecuteRegionFunctionSingleHopOpImpl) {
                ExecuteRegionFunctionSingleHopOp.ExecuteRegionFunctionSingleHopOpImpl newop = (ExecuteRegionFunctionSingleHopOp.ExecuteRegionFunctionSingleHopOpImpl)this.op;
                result = this.pool.execute(new ExecuteRegionFunctionOp.ExecuteRegionFunctionOpImpl(newop));
            } else {
                result = this.pool.execute(this.op);
            }
        }
        finally {
            UserAttributes.userAttributes.set(null);
        }
        return result;
    }

    public ServerLocation getServer() {
        return this.server;
    }

    public AbstractOp getOperation() {
        return this.op;
    }
}

