/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.jmx.internal;

import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBean;
import org.apache.geode.admin.AdminException;
import org.apache.geode.admin.internal.SystemMemberBridgeServerImpl;
import org.apache.geode.admin.internal.SystemMemberCacheImpl;
import org.apache.geode.admin.jmx.internal.MBeanUtil;
import org.apache.geode.admin.jmx.internal.ManagedResource;
import org.apache.geode.admin.jmx.internal.ManagedResourceType;
import org.apache.geode.internal.admin.AdminBridgeServer;
import org.apache.geode.internal.admin.GemFireVM;

public class SystemMemberBridgeServerJmxImpl
extends SystemMemberBridgeServerImpl
implements ManagedResource {
    private ObjectName objectName;
    private String mbeanName;
    private ModelMBean modelMBean;

    SystemMemberBridgeServerJmxImpl(SystemMemberCacheImpl cache, AdminBridgeServer bridgeInfo) throws AdminException {
        super(cache, bridgeInfo);
        this.initializeMBean(cache);
    }

    private void initializeMBean(SystemMemberCacheImpl cache) throws AdminException {
        GemFireVM vm = cache.getVM();
        this.mbeanName = new StringBuffer("GemFire.Cache:").append("name=").append(MBeanUtil.makeCompliantMBeanNameProperty(cache.getName())).append(",id=").append(this.getBridgeId()).append(",owner=").append(MBeanUtil.makeCompliantMBeanNameProperty(vm.getId().toString())).append(",type=CacheServer").toString();
        this.objectName = MBeanUtil.createMBean(this);
    }

    @Override
    public String getMBeanName() {
        return this.mbeanName;
    }

    @Override
    public ModelMBean getModelMBean() {
        return this.modelMBean;
    }

    @Override
    public void setModelMBean(ModelMBean modelMBean) {
        this.modelMBean = modelMBean;
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public ManagedResourceType getManagedResourceType() {
        return ManagedResourceType.SYSTEM_MEMBER_CACHE_SERVER;
    }

    @Override
    public void cleanupResource() {
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SystemMemberBridgeServerJmxImpl)) {
            return false;
        }
        SystemMemberBridgeServerJmxImpl other = (SystemMemberBridgeServerJmxImpl)obj;
        return this.getMBeanName().equals(other.getMBeanName());
    }

    public int hashCode() {
        return this.getMBeanName().hashCode();
    }
}

