/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.internal;

import java.io.File;
import java.util.Set;
import java.util.TreeSet;
import org.apache.geode.admin.AdminException;
import org.apache.geode.admin.SystemMemberRegion;
import org.apache.geode.admin.internal.SystemMemberCacheImpl;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.CacheLoader;
import org.apache.geode.cache.CacheStatistics;
import org.apache.geode.cache.CacheWriter;
import org.apache.geode.cache.CustomExpiry;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.DiskWriteAttributes;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.cache.MembershipAttributes;
import org.apache.geode.cache.MirrorType;
import org.apache.geode.cache.PartitionAttributes;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.SubscriptionAttributes;
import org.apache.geode.internal.admin.remote.AdminRegion;

public class SystemMemberRegionImpl
implements SystemMemberRegion {
    private AdminRegion r;
    private RegionAttributes ra;
    private CacheStatistics rs;
    private Set subregionNames;
    private Set subregionFullPaths;
    private int entryCount;
    private int subregionCount;
    private final SystemMemberCacheImpl cache;

    public SystemMemberRegionImpl(SystemMemberCacheImpl cache, Region r) {
        this.cache = cache;
        this.r = (AdminRegion)r;
    }

    private void refreshFields() {
        this.ra = this.r.getAttributes();
        this.rs = this.getStatisticsEnabled() && !this.ra.getDataPolicy().withPartitioning() ? this.r.getStatistics() : null;
        Set s = this.r.subregions(false);
        TreeSet<String> names = new TreeSet<String>();
        TreeSet<String> paths = new TreeSet<String>();
        for (Region r : s) {
            String name = r.getName();
            names.add(name);
            paths.add(this.getFullPath() + '/' + name);
        }
        this.subregionNames = names;
        this.subregionFullPaths = paths;
        try {
            int[] sizes = this.r.sizes();
            this.entryCount = sizes[0];
            this.subregionCount = sizes[1];
        }
        catch (CacheException ignore) {
            this.entryCount = 0;
            this.subregionCount = 0;
        }
    }

    @Override
    public String getName() {
        return this.r.getName();
    }

    @Override
    public String getFullPath() {
        return this.r.getFullPath();
    }

    @Override
    public Set getSubregionNames() {
        return this.subregionNames;
    }

    @Override
    public Set getSubregionFullPaths() {
        return this.subregionFullPaths;
    }

    @Override
    public String getUserAttribute() {
        return (String)this.r.getUserAttribute();
    }

    @Override
    public String getCacheLoader() {
        CacheLoader o = this.ra.getCacheLoader();
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    @Override
    public String getCacheWriter() {
        CacheWriter o = this.ra.getCacheWriter();
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    @Override
    public String getKeyConstraint() {
        Class constraint = this.ra.getKeyConstraint();
        if (constraint == null) {
            return "";
        }
        return constraint.getName();
    }

    @Override
    public String getValueConstraint() {
        Class constraint = this.ra.getValueConstraint();
        if (constraint == null) {
            return "";
        }
        return constraint.getName();
    }

    @Override
    public boolean getEarlyAck() {
        return this.ra.getEarlyAck();
    }

    @Override
    public int getRegionTimeToLiveTimeLimit() {
        return this.ra.getRegionTimeToLive().getTimeout();
    }

    @Override
    public ExpirationAction getRegionTimeToLiveAction() {
        return this.ra.getRegionTimeToLive().getAction();
    }

    @Override
    public int getEntryTimeToLiveTimeLimit() {
        return this.ra.getEntryTimeToLive().getTimeout();
    }

    @Override
    public ExpirationAction getEntryTimeToLiveAction() {
        return this.ra.getEntryTimeToLive().getAction();
    }

    @Override
    public String getCustomEntryTimeToLive() {
        CustomExpiry o = this.ra.getCustomEntryTimeToLive();
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    @Override
    public int getRegionIdleTimeoutTimeLimit() {
        return this.ra.getRegionIdleTimeout().getTimeout();
    }

    @Override
    public ExpirationAction getRegionIdleTimeoutAction() {
        return this.ra.getRegionIdleTimeout().getAction();
    }

    @Override
    public int getEntryIdleTimeoutTimeLimit() {
        return this.ra.getEntryIdleTimeout().getTimeout();
    }

    @Override
    public ExpirationAction getEntryIdleTimeoutAction() {
        return this.ra.getEntryIdleTimeout().getAction();
    }

    @Override
    public String getCustomEntryIdleTimeout() {
        CustomExpiry o = this.ra.getCustomEntryIdleTimeout();
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    @Override
    public MirrorType getMirrorType() {
        return this.ra.getMirrorType();
    }

    @Override
    public DataPolicy getDataPolicy() {
        return this.ra.getDataPolicy();
    }

    @Override
    public Scope getScope() {
        return this.ra.getScope();
    }

    @Override
    public EvictionAttributes getEvictionAttributes() {
        return this.ra.getEvictionAttributes();
    }

    @Override
    @Deprecated
    public String getCacheListener() {
        String[] o = this.getCacheListeners();
        if (o.length == 0) {
            return "";
        }
        return o[0].toString();
    }

    @Override
    public String[] getCacheListeners() {
        CacheListener<K, V>[] o = this.ra.getCacheListeners();
        String[] ret = null;
        if (o == null || o.length == 0) {
            ret = new String[]{};
        } else {
            ret = new String[o.length];
            for (int i = 0; i < o.length; ++i) {
                ret[i] = o[i].toString();
            }
        }
        return ret;
    }

    @Override
    public int getInitialCapacity() {
        return this.ra.getInitialCapacity();
    }

    @Override
    public float getLoadFactor() {
        return this.ra.getLoadFactor();
    }

    @Override
    public int getConcurrencyLevel() {
        return this.ra.getConcurrencyLevel();
    }

    @Override
    public boolean getConcurrencyChecksEnabled() {
        return this.ra.getConcurrencyChecksEnabled();
    }

    @Override
    public boolean getStatisticsEnabled() {
        return this.ra.getStatisticsEnabled();
    }

    @Override
    public boolean getPersistBackup() {
        return this.ra.getPersistBackup();
    }

    @Override
    public DiskWriteAttributes getDiskWriteAttributes() {
        return this.ra.getDiskWriteAttributes();
    }

    @Override
    public File[] getDiskDirs() {
        return this.ra.getDiskDirs();
    }

    @Override
    public int getEntryCount() {
        return this.entryCount;
    }

    @Override
    public int getSubregionCount() {
        return this.subregionCount;
    }

    @Override
    public long getLastModifiedTime() {
        if (this.rs == null) {
            return 0L;
        }
        return this.rs.getLastModifiedTime();
    }

    @Override
    public long getLastAccessedTime() {
        if (this.rs == null) {
            return 0L;
        }
        return this.rs.getLastAccessedTime();
    }

    @Override
    public long getHitCount() {
        if (this.rs == null) {
            return 0L;
        }
        return this.rs.getHitCount();
    }

    @Override
    public long getMissCount() {
        if (this.rs == null) {
            return 0L;
        }
        return this.rs.getMissCount();
    }

    @Override
    public float getHitRatio() {
        if (this.rs == null) {
            return 0.0f;
        }
        return this.rs.getHitRatio();
    }

    @Override
    public void refresh() {
        this.refreshFields();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public SystemMemberRegion createSubregion(String name, RegionAttributes attrs) throws AdminException {
        Region r = this.cache.getVM().createSubregion(this.cache.getCacheInfo(), this.getFullPath(), name, attrs);
        if (r == null) {
            return null;
        }
        return this.cache.createSystemMemberRegion(r);
    }

    @Override
    public MembershipAttributes getMembershipAttributes() {
        return this.ra.getMembershipAttributes();
    }

    @Override
    public SubscriptionAttributes getSubscriptionAttributes() {
        return this.ra.getSubscriptionAttributes();
    }

    @Override
    public PartitionAttributes getPartitionAttributes() {
        return this.ra.getPartitionAttributes();
    }
}

