/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.string;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.redis.internal.AutoCloseableLock;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.executor.string.StringExecutor;

public class IncrExecutor
extends StringExecutor {
    private final int INIT_VALUE_INT = 1;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        long value;
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() != 2) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the INCR command is \"INCR key\""));
            return;
        }
        Region<ByteArrayWrapper, ByteArrayWrapper> region = context.getRegionProvider().getStringsRegion();
        ByteArrayWrapper key = command.getKey();
        this.checkAndSetDataType(key, context);
        try (AutoCloseableLock regionLock = this.withRegionLock(context, key);){
            ByteArrayWrapper valueWrapper = (ByteArrayWrapper)region.get((Object)key);
            if (valueWrapper == null) {
                byte[] newValue = new byte[]{49};
                region.put((Object)key, (Object)new ByteArrayWrapper(newValue));
                command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 1));
                return;
            }
            String stringValue = valueWrapper.toString();
            try {
                value = Long.parseLong(stringValue);
            }
            catch (NumberFormatException e) {
                command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "value is not an integer or out of range"));
                if (regionLock != null) {
                    if (var9_9 != null) {
                        try {
                            regionLock.close();
                        }
                        catch (Throwable throwable) {
                            var9_9.addSuppressed(throwable);
                        }
                    } else {
                        regionLock.close();
                    }
                }
                return;
            }
            if (value == Long.MAX_VALUE) {
                command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "increment or decrement would overflow"));
                return;
            }
            stringValue = "" + ++value;
            region.put((Object)key, (Object)new ByteArrayWrapper(Coder.stringToBytes(stringValue)));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Thread interrupted."));
            return;
        }
        catch (TimeoutException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Timeout acquiring lock. Please try again."));
            return;
        }
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), value));
    }
}

