/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.sortedset;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.DoubleWrapper;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.SortedSetQuery;
import org.apache.geode.redis.internal.executor.sortedset.SortedSetExecutor;

public class ZCountExecutor
extends SortedSetExecutor {
    private static final String ERROR_NOT_NUMERIC = "The number provided is not numeric";
    private static final int NOT_EXISTS = 0;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        int count;
        double stop;
        double start;
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 4) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the ZCOUNT command is \"ZCOUNT key min max\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        Region<ByteArrayWrapper, DoubleWrapper> keyRegion = this.getRegion(context, key);
        this.checkDataType(key, RedisDataType.REDIS_SORTEDSET, context);
        if (keyRegion == null) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
            return;
        }
        boolean startInclusive = true;
        boolean stopInclusive = true;
        byte[] startArray = commandElems.get(2);
        byte[] stopArray = commandElems.get(3);
        String startString = Coder.bytesToString(startArray);
        String stopString = Coder.bytesToString(stopArray);
        if (startArray[0] == 40) {
            startString = startString.substring(1);
            startInclusive = false;
        }
        if (stopArray[0] == 40) {
            stopString = stopString.substring(1);
            stopInclusive = false;
        }
        try {
            start = Coder.stringToDouble(startString);
            stop = Coder.stringToDouble(stopString);
        }
        catch (NumberFormatException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), ERROR_NOT_NUMERIC));
            return;
        }
        try {
            count = this.getCount(key, keyRegion, context, start, stop, startInclusive, stopInclusive);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), count));
    }

    private int getCount(ByteArrayWrapper key, Region<ByteArrayWrapper, DoubleWrapper> keyRegion, ExecutionHandlerContext context, double start, double stop, boolean startInclusive, boolean stopInclusive) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        Object[] params;
        Query query;
        if (start == Double.NEGATIVE_INFINITY && stop == Double.POSITIVE_INFINITY) {
            return keyRegion.size();
        }
        if (start == Double.POSITIVE_INFINITY || stop == Double.NEGATIVE_INFINITY) {
            return 0;
        }
        if (start == Double.NEGATIVE_INFINITY) {
            query = stopInclusive ? this.getQuery(key, SortedSetQuery.ZCOUNTNINFI, context) : this.getQuery(key, SortedSetQuery.ZCOUNTNINF, context);
            params = new Object[]{stop};
        } else if (stop == Double.POSITIVE_INFINITY) {
            query = startInclusive ? this.getQuery(key, SortedSetQuery.ZCOUNTPINFI, context) : this.getQuery(key, SortedSetQuery.ZCOUNTPINF, context);
            params = new Object[]{start};
        } else {
            query = startInclusive ? (stopInclusive ? this.getQuery(key, SortedSetQuery.ZCOUNTSTISI, context) : this.getQuery(key, SortedSetQuery.ZCOUNTSTI, context)) : (stopInclusive ? this.getQuery(key, SortedSetQuery.ZCOUNTSI, context) : this.getQuery(key, SortedSetQuery.ZCOUNT, context));
            params = new Object[]{start, stop};
        }
        SelectResults results = (SelectResults)query.execute(params);
        return (Integer)results.asList().get(0);
    }
}

