/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.sortedset;

import java.util.HashMap;
import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.DoubleWrapper;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.sortedset.SortedSetExecutor;

public class ZAddExecutor
extends SortedSetExecutor {
    private final String ERROR_NOT_NUMERICAL = "The inteded score is not a float";

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 4 || commandElems.size() % 2 == 1) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the ZADD command is \"ZADD key score member [score member ...]\", or not every score matches to a member"));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        int numberOfAdds = 0;
        if (commandElems.size() > 4) {
            HashMap<ByteArrayWrapper, DoubleWrapper> map = new HashMap<ByteArrayWrapper, DoubleWrapper>();
            for (int i = 2; i < commandElems.size(); ++i) {
                Double score;
                byte[] scoreArray = commandElems.get(i++);
                byte[] memberArray = commandElems.get(i);
                try {
                    score = Coder.bytesToDouble(scoreArray);
                }
                catch (NumberFormatException e) {
                    command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The inteded score is not a float"));
                    return;
                }
                map.put(new ByteArrayWrapper(memberArray), new DoubleWrapper(score));
                ++numberOfAdds;
            }
            Region<ByteArrayWrapper, DoubleWrapper> keyRegion = this.getOrCreateRegion(context, key, RedisDataType.REDIS_SORTEDSET);
            keyRegion.putAll(map);
        } else {
            Double score;
            byte[] scoreArray = commandElems.get(2);
            byte[] memberArray = commandElems.get(3);
            try {
                score = Coder.bytesToDouble(scoreArray);
            }
            catch (NumberFormatException e) {
                command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The inteded score is not a float"));
                return;
            }
            Region<ByteArrayWrapper, DoubleWrapper> keyRegion = this.getOrCreateRegion(context, key, RedisDataType.REDIS_SORTEDSET);
            Object oldVal = keyRegion.put((Object)new ByteArrayWrapper(memberArray), (Object)new DoubleWrapper(score));
            if (oldVal == null) {
                numberOfAdds = 1;
            }
        }
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), numberOfAdds));
    }
}

