/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.sortedset;

import java.util.ArrayList;
import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.executor.sortedset.GeoSortedSetExecutor;

public class GeoHashExecutor
extends GeoSortedSetExecutor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        ByteArrayWrapper key = command.getKey();
        if (commandElems.size() < 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the GEOHASH command is \"GEOHASH key member [member...]\""));
            return;
        }
        ArrayList<String> hashes = new ArrayList<String>();
        Region<ByteArrayWrapper, ByteArrayWrapper> keyRegion = this.getRegion(context, key);
        for (int i = 2; i < commandElems.size(); ++i) {
            byte[] member = commandElems.get(i);
            ByteArrayWrapper hashWrapper = (ByteArrayWrapper)keyRegion.get((Object)new ByteArrayWrapper(member));
            if (hashWrapper != null) {
                hashes.add(hashWrapper.toString());
                continue;
            }
            hashes.add(null);
        }
        this.respondBulkStrings(command, context, hashes);
    }
}

