/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.sortedset;

import java.util.HashMap;
import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.GeoCoder;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.sortedset.GeoSortedSetExecutor;

public class GeoAddExecutor
extends GeoSortedSetExecutor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        int numberOfAdds = 0;
        List<byte[]> commandElems = command.getProcessedCommand();
        ByteArrayWrapper key = command.getKey();
        if (commandElems.size() < 5 || (commandElems.size() - 2) % 3 != 0) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the GEOADD command is \"GEOADD key longitude latitude member [longitude latitude member ...]\", or not every latitude/longitude pair matches to a member"));
            return;
        }
        Region<ByteArrayWrapper, ByteArrayWrapper> keyRegion = this.getOrCreateRegion(context, key, RedisDataType.REDIS_SORTEDSET);
        HashMap<ByteArrayWrapper, ByteArrayWrapper> tempMap = new HashMap<ByteArrayWrapper, ByteArrayWrapper>();
        for (int i = 2; i < commandElems.size(); i += 3) {
            String score;
            byte[] longitude = commandElems.get(i);
            byte[] latitude = commandElems.get(i + 1);
            byte[] member = commandElems.get(i + 2);
            try {
                score = GeoCoder.geohash(longitude, latitude);
            }
            catch (IllegalArgumentException e) {
                command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "ERR Invalid longitude-latitude pair " + longitude.toString() + " " + latitude.toString()));
                return;
            }
            tempMap.put(new ByteArrayWrapper(member), new ByteArrayWrapper(score.getBytes()));
        }
        for (ByteArrayWrapper m : tempMap.keySet()) {
            Object oldVal = keyRegion.put((Object)m, tempMap.get(m));
            if (oldVal != null) continue;
            ++numberOfAdds;
        }
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), numberOfAdds));
    }
}

