/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.set;

import java.util.ArrayList;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.internal.cache.execute.RegionFunctionContextImpl;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.executor.set.DeltaSet;

class SaddFunction
implements Function<ArrayList<ByteArrayWrapper>> {
    public static final String ID = "SADD_FUNCTION";

    SaddFunction() {
    }

    public void execute(FunctionContext<ArrayList<ByteArrayWrapper>> context) {
        RegionFunctionContextImpl regionFunctionContext = (RegionFunctionContextImpl)context;
        ByteArrayWrapper key = (ByteArrayWrapper)regionFunctionContext.getFilter().iterator().next();
        Region localRegion = regionFunctionContext.getLocalDataSet(regionFunctionContext.getDataSet());
        ArrayList membersToAdd = (ArrayList)regionFunctionContext.getArguments();
        long membersAdded = DeltaSet.sadd((Region<ByteArrayWrapper, DeltaSet>)localRegion, key, membersToAdd);
        regionFunctionContext.getResultSender().lastResult((Object)membersAdded);
    }

    public boolean optimizeForWrite() {
        return true;
    }

    public String getId() {
        return ID;
    }
}

