/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.set;

import java.util.ArrayList;
import java.util.List;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.set.GeodeRedisSetWithFunctions;
import org.apache.geode.redis.internal.executor.set.SetExecutor;

public class SAddExecutor
extends SetExecutor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<ByteArrayWrapper> commandElements = command.getProcessedCommandWrappers();
        if (commandElements.size() < 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the SADD command is \"SADD key member [member ...]\""));
            return;
        }
        context.getKeyRegistrar().register(command.getKey(), RedisDataType.REDIS_SET);
        ByteArrayWrapper key = command.getKey();
        GeodeRedisSetWithFunctions geodeRedisSet = new GeodeRedisSetWithFunctions(key, context.getRegionProvider().getSetRegion());
        ArrayList<ByteArrayWrapper> membersToAdd = new ArrayList<ByteArrayWrapper>(commandElements.subList(2, commandElements.size()));
        long entriesAdded = geodeRedisSet.sadd(membersToAdd);
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), entriesAdded));
    }
}

