/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.set;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.Delta;
import org.apache.geode.InvalidDeltaException;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;

public class DeltaSet
implements Delta,
DataSerializable {
    private HashSet<ByteArrayWrapper> members;
    private transient ArrayList<ByteArrayWrapper> deltas;
    private transient boolean deltasAreAdds;

    public static long sadd(Region<ByteArrayWrapper, DeltaSet> region, ByteArrayWrapper key, ArrayList<ByteArrayWrapper> membersToAdd) {
        long result = -1L;
        do {
            DeltaSet deltaSet;
            if ((deltaSet = (DeltaSet)region.get((Object)key)) != null) {
                result = deltaSet.saddInstance(membersToAdd, region, key);
                continue;
            }
            if (region.putIfAbsent((Object)key, (Object)new DeltaSet(membersToAdd)) != null) continue;
            return membersToAdd.size();
        } while (result == -1L);
        return result;
    }

    public static long srem(Region<ByteArrayWrapper, DeltaSet> region, ByteArrayWrapper key, ArrayList<ByteArrayWrapper> membersToRemove, AtomicBoolean setWasDeleted) {
        DeltaSet deltaSet;
        long result;
        do {
            if ((deltaSet = (DeltaSet)region.get((Object)key)) != null) continue;
            return 0L;
        } while ((result = deltaSet.sremInstance(membersToRemove, region, key, setWasDeleted)) == -1L);
        return result;
    }

    public static boolean del(Region<ByteArrayWrapper, DeltaSet> region, ByteArrayWrapper key) {
        DeltaSet deltaSet;
        do {
            if ((deltaSet = (DeltaSet)region.get((Object)key)) != null) continue;
            return false;
        } while (!deltaSet.delInstance(region, key));
        return true;
    }

    public static Set<ByteArrayWrapper> members(Region<ByteArrayWrapper, DeltaSet> region, ByteArrayWrapper key) {
        DeltaSet deltaSet = (DeltaSet)region.get((Object)key);
        if (deltaSet != null) {
            return deltaSet.members();
        }
        return Collections.emptySet();
    }

    public synchronized boolean contains(ByteArrayWrapper member) {
        return this.members.contains(member);
    }

    public synchronized int size() {
        return this.members.size();
    }

    DeltaSet(Collection<ByteArrayWrapper> members) {
        this.members = members instanceof HashSet ? (HashSet<Object>)members : new HashSet<ByteArrayWrapper>(members);
    }

    public DeltaSet() {
    }

    public boolean hasDelta() {
        return this.deltas != null;
    }

    public void toDelta(DataOutput out) throws IOException {
        DataSerializer.writeBoolean((Boolean)this.deltasAreAdds, (DataOutput)out);
        DataSerializer.writeArrayList(this.deltas, (DataOutput)out);
    }

    public synchronized void fromDelta(DataInput in) throws IOException, InvalidDeltaException {
        boolean deltaAdds = DataSerializer.readBoolean((DataInput)in);
        try {
            ArrayList deltas = DataSerializer.readArrayList((DataInput)in);
            if (deltas != null) {
                if (deltaAdds) {
                    this.members.addAll(deltas);
                } else {
                    this.members.removeAll(deltas);
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeHashSet(this.members, (DataOutput)out);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.members = DataSerializer.readHashSet((DataInput)in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized long saddInstance(ArrayList<ByteArrayWrapper> membersToAdd, Region<ByteArrayWrapper, DeltaSet> region, ByteArrayWrapper key) {
        if (region.get((Object)key) != this) {
            return -1L;
        }
        membersToAdd.removeIf(memberToAdd -> !this.members.add((ByteArrayWrapper)memberToAdd));
        int membersAdded = membersToAdd.size();
        if (membersAdded != 0) {
            this.deltasAreAdds = true;
            this.deltas = membersToAdd;
            try {
                region.put((Object)key, (Object)this);
            }
            finally {
                this.deltas = null;
            }
        }
        return membersAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized long sremInstance(ArrayList<ByteArrayWrapper> membersToRemove, Region<ByteArrayWrapper, DeltaSet> region, ByteArrayWrapper key, AtomicBoolean setWasDeleted) {
        if (region.get((Object)key) != this) {
            return -1L;
        }
        membersToRemove.removeIf(memberToRemove -> !this.members.remove(memberToRemove));
        int membersRemoved = membersToRemove.size();
        if (membersRemoved != 0) {
            if (this.members.isEmpty()) {
                region.remove((Object)key);
                if (setWasDeleted != null) {
                    setWasDeleted.set(true);
                }
            } else {
                this.deltasAreAdds = false;
                this.deltas = membersToRemove;
                try {
                    region.put((Object)key, (Object)this);
                }
                finally {
                    this.deltas = null;
                }
            }
        }
        return membersRemoved;
    }

    private synchronized boolean delInstance(Region<ByteArrayWrapper, DeltaSet> region, ByteArrayWrapper key) {
        return region.remove((Object)key, (Object)this);
    }

    synchronized Set<ByteArrayWrapper> members() {
        return new HashSet<ByteArrayWrapper>(this.members);
    }
}

