/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.list;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.Struct;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.ListQuery;
import org.apache.geode.redis.internal.executor.list.ListExecutor;

public class LRemExecutor
extends ListExecutor {
    private static final String ERROR_NOT_NUMERIC = "The count provided is not numeric";
    private static final int NOT_EXISTS = 0;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<Struct> removeList;
        int count;
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 4) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the LREM command is \"LREM key count value\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        byte[] countArray = commandElems.get(2);
        byte[] value = commandElems.get(3);
        this.checkDataType(key, RedisDataType.REDIS_LIST, context);
        Region<Object, Object> keyRegion = this.getRegion(context, key);
        if (keyRegion == null) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
            return;
        }
        try {
            count = Coder.bytesToInt(countArray);
        }
        catch (NumberFormatException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), ERROR_NOT_NUMERIC));
            return;
        }
        try {
            removeList = this.getRemoveList(context, key, new ByteArrayWrapper(value), count);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        int numRemoved = 0;
        if (removeList == null) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), numRemoved));
            return;
        }
        for (Struct entry : removeList) {
            Integer removeKey = (Integer)entry.getFieldValues()[0];
            Object oldVal = keyRegion.remove((Object)removeKey);
            if (oldVal == null) continue;
            ++numRemoved;
        }
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), numRemoved));
    }

    private List<Struct> getRemoveList(ExecutionHandlerContext context, ByteArrayWrapper key, ByteArrayWrapper value, int count) throws Exception {
        Object[] params;
        Query query;
        if (count > 0) {
            query = this.getQuery(key, ListQuery.LREMG, context);
            params = new Object[]{value, count};
        } else if (count < 0) {
            query = this.getQuery(key, ListQuery.LREML, context);
            params = new Object[]{value, -count};
        } else {
            query = this.getQuery(key, ListQuery.LREME, context);
            params = new Object[]{value};
        }
        SelectResults results = (SelectResults)query.execute(params);
        if (results == null || results.isEmpty()) {
            return null;
        }
        return results.asList();
    }
}

