/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc;

import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.reflect.internal.pickling.ByteCodecs$;
import scala.reflect.io.RootPath;
import scala.reflect.io.RootPath$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.tools.asm.Attribute;
import scala.tools.asm.ClassReader;
import scala.tools.asm.ClassWriter;
import scala.tools.asm.tree.AnnotationNode;
import scala.tools.asm.tree.ClassNode;
import scala.tools.nsc.PickleExtractor;
import scala.tools.nsc.PickleExtractor$Skip$;

public final class PickleExtractor$ {
    public static PickleExtractor$ MODULE$;

    static {
        new PickleExtractor$();
    }

    public void main(String[] args) {
        List<Object> list = new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])args)).toList();
        if (list instanceof $colon$colon) {
            $colon$colon $colon$colon = ($colon$colon)list;
            String input = (String)$colon$colon.head();
            List list2 = $colon$colon.tl$access$1();
            if (list2 instanceof $colon$colon) {
                $colon$colon $colon$colon2 = ($colon$colon)list2;
                String output = (String)$colon$colon2.head();
                List list3 = $colon$colon2.tl$access$1();
                if (((Object)Nil$.MODULE$).equals(list3)) {
                    this.process(Paths.get(input, new String[0]), Paths.get(output, new String[0]));
                    return;
                }
            }
        }
    }

    public void process(Path input, Path output) {
        RootPath inputPath = RootPath$.MODULE$.apply(input, false);
        RootPath outputPath = RootPath$.MODULE$.apply(output, true);
        try {
            Path root = inputPath.root();
            Files.createDirectories(outputPath.root(), new FileAttribute[0]);
            SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(root, outputPath, inputPath){
                private final Path root$1;
                private final RootPath outputPath$1;
                private final RootPath inputPath$1;

                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    Path path = dir;
                    Path path2 = this.root$1;
                    if (path == null ? path2 != null : !((Object)path).equals(path2)) {
                        Files.createDirectories(this.outputPath$1.root().resolve(((Object)this.root$1.relativize(dir)).toString()), new FileAttribute[0]);
                    }
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (((Object)file.getFileName()).toString().endsWith(".class")) {
                        try {
                            PickleExtractor.OutputFile outputFile = PickleExtractor$.MODULE$.stripClassFile(Files.readAllBytes(file));
                            if (outputFile instanceof PickleExtractor.Class) {
                                byte[] out = ((PickleExtractor.Class)outputFile).content();
                                Files.write(this.outputPath$1.root().resolve(((Object)this.root$1.relativize(file)).toString()), out, new OpenOption[0]);
                            } else if (outputFile instanceof PickleExtractor.Pickle) {
                                byte[] out = ((PickleExtractor.Pickle)outputFile).content();
                                Files.write(this.outputPath$1.root().resolve(((Object)this.root$1.relativize(file)).toString().replaceAll(".class$", ".sig")), out, new OpenOption[0]);
                            } else if (!PickleExtractor$Skip$.MODULE$.equals(outputFile)) {
                                throw new MatchError(outputFile);
                            }
                        }
                        catch (RuntimeException ex) {
                            throw new RuntimeException(new StringBuilder(19).append("While parsing: ").append(file).append(" in ").append(this.inputPath$1).toString(), ex);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
                {
                    this.root$1 = root$1;
                    this.outputPath$1 = outputPath$1;
                    this.inputPath$1 = inputPath$1;
                }
            };
            Files.walkFileTree(root, (FileVisitor<? super Path>)visitor);
        }
        finally {
            inputPath.close();
            outputPath.close();
        }
    }

    public PickleExtractor.OutputFile stripClassFile(byte[] classfile) {
        ClassNode input = new ClassNode();
        new ClassReader(classfile).accept(input, 7);
        ClassNode output = new ClassNode();
        output.name = input.name;
        output.access = input.access;
        output.version = input.version;
        BooleanRef foundScalaSig = BooleanRef.create(false);
        ObjectRef<Object> pickleData = ObjectRef.create(null);
        if (input.visibleAnnotations != null) {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(input.visibleAnnotations).asScala()).foreach((Function1<AnnotationNode, Object> & java.io.Serializable & Serializable)node -> {
                PickleExtractor$.$anonfun$stripClassFile$1(pickleData, node);
                return BoxedUnit.UNIT;
            });
            output.visibleAnnotations = JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(input.visibleAnnotations).asScala()).filter((Function1<AnnotationNode, Object> & java.io.Serializable & Serializable)node -> BoxesRunTime.boxToBoolean(PickleExtractor$.$anonfun$stripClassFile$3(foundScalaSig, node)))).asJava();
        }
        BooleanRef foundScalaAttr = BooleanRef.create(false);
        if (input.attrs != null) {
            output.attrs = JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(input.attrs).asScala()).filter((Function1<Attribute, Object> & java.io.Serializable & Serializable)attr -> BoxesRunTime.boxToBoolean(PickleExtractor$.$anonfun$stripClassFile$4(foundScalaAttr, attr)))).asJava();
        }
        ClassWriter writer = new ClassWriter(458752);
        if (foundScalaAttr.elem && !foundScalaSig.elem) {
            return PickleExtractor$Skip$.MODULE$;
        }
        if ((byte[])pickleData.elem == null) {
            output = input;
            output.accept(writer);
            return new PickleExtractor.Class(writer.toByteArray());
        }
        output.accept(writer);
        return new PickleExtractor.Pickle((byte[])pickleData.elem);
    }

    private static final boolean isScalaAnnotation$1(String desc, BooleanRef foundScalaSig$1) {
        block3: {
            block2: {
                String string = desc;
                String string2 = "Lscala/reflect/ScalaSignature;";
                if (string != null && string.equals(string2)) break block2;
                String string3 = desc;
                String string4 = "Lscala/reflect/ScalaLongSignature;";
                if (string3 == null || !string3.equals(string4)) break block3;
            }
            foundScalaSig$1.elem = true;
            return true;
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$stripClassFile$1(ObjectRef pickleData$1, AnnotationNode node) {
        block10: {
            Object data;
            block12: {
                Object[] objectArray;
                block11: {
                    block7: {
                        Object data2;
                        block9: {
                            Object[] objectArray2;
                            block8: {
                                String string = node.desc;
                                String string2 = "Lscala/reflect/ScalaSignature;";
                                if (string == null || !string.equals(string2)) break block7;
                                objectArray2 = node.values.toArray();
                                Option option = Array$.MODULE$.unapplySeq(objectArray2);
                                if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) break block8;
                                Object a = ((SeqLike)option.get()).apply(0);
                                data2 = ((SeqLike)option.get()).apply(1);
                                if ("bytes".equals(a) && data2 instanceof String) break block9;
                            }
                            throw new MatchError(objectArray2);
                        }
                        String string = (String)data2;
                        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
                        int len = ByteCodecs$.MODULE$.decode(bytes);
                        pickleData$1.elem = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).take(len);
                        return;
                    }
                    String string = node.desc;
                    String string3 = "Lscala/reflect/ScalaLongSignature;";
                    if (string == null) {
                        return;
                    }
                    if (!string.equals(string3)) break block10;
                    objectArray = node.values.toArray();
                    Option option = Array$.MODULE$.unapplySeq(objectArray);
                    if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) break block11;
                    Object a = ((SeqLike)option.get()).apply(0);
                    data = ((SeqLike)option.get()).apply(1);
                    if ("bytes".equals(a) && data instanceof Collection) break block12;
                }
                throw new MatchError(objectArray);
            }
            Collection collection = (Collection)data;
            byte[] encoded = (byte[])TraversableLike.flatMap$(new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(collection).asScala()).toArray(ClassTag$.MODULE$.apply(String.class)))), (Function1<String, Object> & java.io.Serializable & Serializable)x$1 -> new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(x$1.getBytes(StandardCharsets.UTF_8))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
            int len = ByteCodecs$.MODULE$.decode(encoded);
            pickleData$1.elem = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(encoded)).take(len);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$stripClassFile$3(BooleanRef foundScalaSig$1, AnnotationNode node) {
        return PickleExtractor$.isScalaAnnotation$1(node.desc, foundScalaSig$1);
    }

    public static final /* synthetic */ boolean $anonfun$stripClassFile$4(BooleanRef foundScalaAttr$1, Attribute attr) {
        block3: {
            block2: {
                String string = attr.type;
                String string2 = "Scala";
                if (string != null && string.equals(string2)) break block2;
                String string3 = attr.type;
                String string4 = "ScalaSig";
                if (string3 == null || !string3.equals(string4)) break block3;
            }
            foundScalaAttr$1.elem = true;
            return true;
        }
        return false;
    }

    private PickleExtractor$() {
        MODULE$ = this;
    }
}

