/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.flink.annotation.Internal;

@Internal
public class ObjectContainer {
    private final Object object;
    private final BiFunction<Object, Object, Boolean> equalsMethod;
    private final Function<Object, Integer> hashCodeMethod;

    public ObjectContainer(Object object, BiFunction<Object, Object, Boolean> equalsMethod, Function<Object, Integer> hashCodeMethod) {
        this.object = object;
        this.equalsMethod = equalsMethod;
        this.hashCodeMethod = hashCodeMethod;
    }

    public Object getObject() {
        return this.object;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ObjectContainer)) {
            return false;
        }
        ObjectContainer that = (ObjectContainer)other;
        return this.equalsMethod.apply(this.object, that.object);
    }

    public int hashCode() {
        return this.hashCodeMethod.apply(this.object);
    }
}

