/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.aggregate;

import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.dataview.PerKeyStateDataViewStore;
import org.apache.flink.table.runtime.generated.AggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedRecordEqualiser;
import org.apache.flink.table.runtime.generated.RecordEqualiser;
import org.apache.flink.table.runtime.operators.aggregate.RecordCounter;
import org.apache.flink.table.runtime.util.StateConfigUtil;
import org.apache.flink.table.types.logical.LogicalType;

public abstract class GroupAggFunctionBase
extends KeyedProcessFunction<RowData, RowData, RowData> {
    protected final GeneratedAggsHandleFunction genAggsHandler;
    protected final GeneratedRecordEqualiser genRecordEqualiser;
    protected final LogicalType[] accTypes;
    protected final RecordCounter recordCounter;
    protected final boolean generateUpdateBefore;
    protected final StateTtlConfig ttlConfig;
    protected transient AggsHandleFunction function = null;
    protected transient RecordEqualiser equaliser = null;

    public GroupAggFunctionBase(GeneratedAggsHandleFunction genAggsHandler, GeneratedRecordEqualiser genRecordEqualiser, LogicalType[] accTypes, int indexOfCountStar, boolean generateUpdateBefore, long stateRetentionTime) {
        this.genAggsHandler = genAggsHandler;
        this.genRecordEqualiser = genRecordEqualiser;
        this.accTypes = accTypes;
        this.recordCounter = RecordCounter.of(indexOfCountStar);
        this.generateUpdateBefore = generateUpdateBefore;
        this.ttlConfig = StateConfigUtil.createTtlConfig(stateRetentionTime);
    }

    public void open(OpenContext openContext) throws Exception {
        super.open(openContext);
        this.function = (AggsHandleFunction)this.genAggsHandler.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        this.function.open(new PerKeyStateDataViewStore(this.getRuntimeContext(), this.ttlConfig));
        this.equaliser = (RecordEqualiser)this.genRecordEqualiser.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
    }

    public void close() throws Exception {
        super.close();
        if (this.function != null) {
            this.function.close();
        }
    }
}

