/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference;

import java.util.Objects;
import java.util.Optional;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.types.inference.ArgumentCount;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class ConstantArgumentCount
implements ArgumentCount {
    private static final int OPEN_INTERVAL = -1;
    private final int minCount;
    private final int maxCount;

    private ConstantArgumentCount(int minCount, int maxCount) {
        this.minCount = minCount;
        this.maxCount = maxCount;
    }

    public static ConstantArgumentCount of(int count) {
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0);
        return new ConstantArgumentCount(count, count);
    }

    public static ConstantArgumentCount between(int minCount, int maxCount) {
        Preconditions.checkArgument((minCount <= maxCount ? 1 : 0) != 0);
        Preconditions.checkArgument((minCount >= 0 ? 1 : 0) != 0);
        return new ConstantArgumentCount(minCount, maxCount);
    }

    public static ConstantArgumentCount from(int minCount) {
        Preconditions.checkArgument((minCount >= 0 ? 1 : 0) != 0);
        return new ConstantArgumentCount(minCount, -1);
    }

    public static ConstantArgumentCount to(int maxCount) {
        Preconditions.checkArgument((maxCount >= 0 ? 1 : 0) != 0);
        return new ConstantArgumentCount(0, maxCount);
    }

    public static ConstantArgumentCount any() {
        return new ConstantArgumentCount(0, -1);
    }

    @Override
    public boolean isValidCount(int count) {
        return count >= this.minCount && (this.maxCount == -1 || count <= this.maxCount);
    }

    @Override
    public Optional<Integer> getMinCount() {
        return Optional.of(this.minCount);
    }

    @Override
    public Optional<Integer> getMaxCount() {
        if (this.maxCount == -1) {
            return Optional.empty();
        }
        return Optional.of(this.maxCount);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstantArgumentCount that = (ConstantArgumentCount)o;
        return this.minCount == that.minCount && this.maxCount == that.maxCount;
    }

    public int hashCode() {
        return Objects.hash(this.minCount, this.maxCount);
    }
}

