/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.TableDistribution;
import org.apache.flink.util.Preconditions;

@Internal
public class DefaultCatalogTable
implements CatalogTable {
    private final Schema schema;
    @Nullable
    private final String comment;
    @Nullable
    private final TableDistribution distribution;
    private final List<String> partitionKeys;
    private final Map<String, String> options;
    @Nullable
    private final Long snapshot;

    protected DefaultCatalogTable(Schema schema, @Nullable String comment, List<String> partitionKeys, Map<String, String> options) {
        this(schema, comment, partitionKeys, options, null, null);
    }

    protected DefaultCatalogTable(Schema schema, @Nullable String comment, List<String> partitionKeys, Map<String, String> options, @Nullable Long snapshot, @Nullable TableDistribution distribution) {
        this.schema = (Schema)Preconditions.checkNotNull((Object)schema, (String)"Schema must not be null.");
        this.comment = comment;
        this.partitionKeys = (List)Preconditions.checkNotNull(partitionKeys, (String)"Partition keys must not be null.");
        this.options = (Map)Preconditions.checkNotNull(options, (String)"Options must not be null.");
        this.snapshot = snapshot;
        this.distribution = distribution;
        Preconditions.checkArgument((boolean)options.entrySet().stream().allMatch(e -> e.getKey() != null && e.getValue() != null), (Object)"Options cannot have null keys or values.");
    }

    @Override
    public Schema getUnresolvedSchema() {
        return this.schema;
    }

    @Override
    public String getComment() {
        return this.comment != null ? this.comment : "";
    }

    @Override
    public boolean isPartitioned() {
        return !this.partitionKeys.isEmpty();
    }

    @Override
    public List<String> getPartitionKeys() {
        return this.partitionKeys;
    }

    @Override
    public Optional<TableDistribution> getDistribution() {
        return Optional.ofNullable(this.distribution);
    }

    @Override
    public Map<String, String> getOptions() {
        return this.options;
    }

    @Override
    public Optional<Long> getSnapshot() {
        return Optional.ofNullable(this.snapshot);
    }

    @Override
    public CatalogBaseTable copy() {
        return new DefaultCatalogTable(this.schema, this.comment, this.partitionKeys, this.options, this.snapshot, this.distribution);
    }

    @Override
    public CatalogTable copy(Map<String, String> options) {
        return new DefaultCatalogTable(this.schema, this.comment, this.partitionKeys, options, this.snapshot, this.distribution);
    }

    @Override
    public Optional<String> getDescription() {
        return Optional.of(this.getComment());
    }

    @Override
    public Optional<String> getDetailedDescription() {
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultCatalogTable that = (DefaultCatalogTable)o;
        return this.schema.equals(that.schema) && Objects.equals(this.comment, that.comment) && Objects.equals(this.distribution, that.distribution) && this.partitionKeys.equals(that.partitionKeys) && this.options.equals(that.options) && Objects.equals(this.snapshot, that.snapshot);
    }

    public int hashCode() {
        return Objects.hash(this.schema, this.comment, this.distribution, this.partitionKeys, this.options, this.snapshot);
    }

    public String toString() {
        return "DefaultCatalogTable{schema=" + String.valueOf(this.schema) + ", comment='" + this.comment + "', distribution=" + String.valueOf(this.distribution) + ", partitionKeys=" + String.valueOf(this.partitionKeys) + ", options=" + String.valueOf(this.options) + ", snapshot=" + this.snapshot + "}";
    }
}

