/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.rank;

import java.util.Comparator;
import java.util.function.Function;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.metrics.Counter;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.operators.KeyContext;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.rank.ConstantRankRange;
import org.apache.flink.table.runtime.operators.rank.RankRange;
import org.apache.flink.table.runtime.operators.rank.RankType;
import org.apache.flink.table.runtime.operators.rank.TopNBuffer;
import org.apache.flink.table.runtime.operators.rank.VariableRankRange;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTopNFunction
extends KeyedProcessFunction<RowData, RowData, RowData> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTopNFunction.class);
    private static final String RANK_UNSUPPORTED_MSG = "RANK() on streaming table is not supported currently";
    private static final String DENSE_RANK_UNSUPPORTED_MSG = "DENSE_RANK() on streaming table is not supported currently";
    private static final String WITHOUT_RANK_END_UNSUPPORTED_MSG = "Rank end is not specified. Currently rank only support TopN, which means the rank end must be specified.";
    private static final long DEFAULT_TOPN_SIZE = 100L;
    protected final StateTtlConfig ttlConfig;
    private GeneratedRecordComparator generatedSortKeyComparator;
    protected Comparator<RowData> sortKeyComparator;
    private final boolean generateUpdateBefore;
    protected final boolean outputRankNumber;
    protected final InternalTypeInfo<RowData> inputRowType;
    protected final KeySelector<RowData, RowData> sortKeySelector;
    protected KeyContext keyContext;
    private final boolean isConstantRankEnd;
    private final long rankStart;
    private final int rankEndIndex;
    protected long rankEnd;
    private transient Function<RowData, Long> rankEndFetcher;
    private ValueState<Long> rankEndState;
    private Counter invalidCounter;
    private JoinedRowData outputRow;
    protected long hitCount = 0L;
    protected long requestCount = 0L;

    AbstractTopNFunction(StateTtlConfig ttlConfig, InternalTypeInfo<RowData> inputRowType, GeneratedRecordComparator generatedSortKeyComparator, RowDataKeySelector sortKeySelector, RankType rankType, RankRange rankRange, boolean generateUpdateBefore, boolean outputRankNumber) {
        this.ttlConfig = ttlConfig;
        switch (rankType) {
            case ROW_NUMBER: {
                break;
            }
            case RANK: {
                LOG.error(RANK_UNSUPPORTED_MSG);
                throw new UnsupportedOperationException(RANK_UNSUPPORTED_MSG);
            }
            case DENSE_RANK: {
                LOG.error(DENSE_RANK_UNSUPPORTED_MSG);
                throw new UnsupportedOperationException(DENSE_RANK_UNSUPPORTED_MSG);
            }
            default: {
                LOG.error("Streaming tables do not support {}", (Object)rankType.name());
                throw new UnsupportedOperationException("Streaming tables do not support " + rankType.toString());
            }
        }
        if (rankRange instanceof ConstantRankRange) {
            ConstantRankRange constantRankRange = (ConstantRankRange)rankRange;
            this.isConstantRankEnd = true;
            this.rankStart = constantRankRange.getRankStart();
            this.rankEnd = constantRankRange.getRankEnd();
            this.rankEndIndex = -1;
        } else if (rankRange instanceof VariableRankRange) {
            VariableRankRange variableRankRange = (VariableRankRange)rankRange;
            this.rankEndIndex = variableRankRange.getRankEndIndex();
            this.isConstantRankEnd = false;
            this.rankStart = -1L;
            this.rankEnd = -1L;
        } else {
            LOG.error(WITHOUT_RANK_END_UNSUPPORTED_MSG);
            throw new UnsupportedOperationException(WITHOUT_RANK_END_UNSUPPORTED_MSG);
        }
        this.generatedSortKeyComparator = generatedSortKeyComparator;
        this.generateUpdateBefore = generateUpdateBefore;
        this.inputRowType = inputRowType;
        this.outputRankNumber = outputRankNumber;
        this.sortKeySelector = sortKeySelector;
    }

    public void open(OpenContext openContext) throws Exception {
        super.open(openContext);
        this.outputRow = new JoinedRowData();
        if (!this.isConstantRankEnd) {
            ValueStateDescriptor rankStateDesc = new ValueStateDescriptor("rankEnd", Types.LONG);
            if (this.ttlConfig.isEnabled()) {
                rankStateDesc.enableTimeToLive(this.ttlConfig);
            }
            this.rankEndState = this.getRuntimeContext().getState(rankStateDesc);
        }
        this.sortKeyComparator = (Comparator)this.generatedSortKeyComparator.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        this.generatedSortKeyComparator = null;
        this.invalidCounter = this.getRuntimeContext().getMetricGroup().counter("topn.invalidTopSize");
        if (!this.isConstantRankEnd) {
            LogicalType rankEndIdxType = this.inputRowType.toRowFieldTypes()[this.rankEndIndex];
            switch (rankEndIdxType.getTypeRoot()) {
                case BIGINT: {
                    this.rankEndFetcher = row -> row.getLong(this.rankEndIndex);
                    break;
                }
                case INTEGER: {
                    this.rankEndFetcher = row -> row.getInt(this.rankEndIndex);
                    break;
                }
                case SMALLINT: {
                    this.rankEndFetcher = row -> row.getShort(this.rankEndIndex);
                    break;
                }
                default: {
                    LOG.error("variable rank index column must be long, short or int type, while input type is {}", (Object)rankEndIdxType.getClass().getName());
                    throw new UnsupportedOperationException("variable rank index column must be long type, while input type is " + rankEndIdxType.getClass().getName());
                }
            }
        }
    }

    protected long getDefaultTopNSize() {
        return this.isConstantRankEnd ? this.rankEnd : 100L;
    }

    protected long initRankEnd(RowData row) throws Exception {
        if (this.isConstantRankEnd) {
            return this.rankEnd;
        }
        Long rankEndValue = (Long)this.rankEndState.value();
        long curRankEnd = this.rankEndFetcher.apply(row);
        if (rankEndValue == null) {
            this.rankEnd = curRankEnd;
            this.rankEndState.update((Object)this.rankEnd);
            return this.rankEnd;
        }
        this.rankEnd = rankEndValue;
        if (this.rankEnd != curRankEnd) {
            this.invalidCounter.inc();
        }
        return this.rankEnd;
    }

    protected boolean checkSortKeyInBufferRange(RowData sortKey, TopNBuffer buffer) {
        return buffer.checkSortKeyInBufferRange(sortKey, this.getDefaultTopNSize());
    }

    protected void registerMetric(long heapSize) {
        this.getRuntimeContext().getMetricGroup().gauge("topn.cache.hitRate", () -> this.requestCount == 0L ? 1.0 : Long.valueOf(this.hitCount).doubleValue() / (double)this.requestCount);
        this.getRuntimeContext().getMetricGroup().gauge("topn.cache.size", () -> heapSize);
    }

    protected void collectInsert(Collector<RowData> out, RowData inputRow, long rank) {
        if (this.isInRankRange(rank)) {
            out.collect((Object)this.createOutputRow(inputRow, rank, RowKind.INSERT));
        }
    }

    protected void collectInsert(Collector<RowData> out, RowData inputRow) {
        inputRow.setRowKind(RowKind.INSERT);
        out.collect((Object)inputRow);
    }

    protected void collectDelete(Collector<RowData> out, RowData inputRow, long rank) {
        if (this.isInRankRange(rank)) {
            out.collect((Object)this.createOutputRow(inputRow, rank, RowKind.DELETE));
        }
    }

    protected void collectDelete(Collector<RowData> out, RowData inputRow) {
        inputRow.setRowKind(RowKind.DELETE);
        out.collect((Object)inputRow);
    }

    protected void collectUpdateAfter(Collector<RowData> out, RowData inputRow, long rank) {
        if (this.isInRankRange(rank)) {
            out.collect((Object)this.createOutputRow(inputRow, rank, RowKind.UPDATE_AFTER));
        }
    }

    protected void collectUpdateAfter(Collector<RowData> out, RowData inputRow) {
        inputRow.setRowKind(RowKind.UPDATE_AFTER);
        out.collect((Object)inputRow);
    }

    protected void collectUpdateBefore(Collector<RowData> out, RowData inputRow, long rank) {
        if (this.generateUpdateBefore && this.isInRankRange(rank)) {
            out.collect((Object)this.createOutputRow(inputRow, rank, RowKind.UPDATE_BEFORE));
        }
    }

    protected void collectUpdateBefore(Collector<RowData> out, RowData inputRow) {
        if (this.generateUpdateBefore) {
            inputRow.setRowKind(RowKind.UPDATE_BEFORE);
            out.collect((Object)inputRow);
        }
    }

    protected boolean isInRankEnd(long rank) {
        return rank <= this.rankEnd;
    }

    protected boolean isInRankRange(long rank) {
        return rank <= this.rankEnd && rank >= this.rankStart;
    }

    protected boolean hasOffset() {
        return this.rankStart > 1L;
    }

    private RowData createOutputRow(RowData inputRow, long rank, RowKind rowKind) {
        if (this.outputRankNumber) {
            GenericRowData rankRow = new GenericRowData(1);
            rankRow.setField(0, (Object)rank);
            this.outputRow.replace(inputRow, (RowData)rankRow);
            this.outputRow.setRowKind(rowKind);
            return this.outputRow;
        }
        inputRow.setRowKind(rowKind);
        return inputRow;
    }

    public void setKeyContext(KeyContext keyContext) {
        this.keyContext = keyContext;
    }
}

