/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentCount;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.ConstantArgumentCount;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.Signature;

@Internal
public final class WildcardInputTypeStrategy
implements InputTypeStrategy {
    private static final ArgumentCount PASSING_ARGUMENT_COUNT = ConstantArgumentCount.any();
    private final ArgumentCount argumentCount;

    public WildcardInputTypeStrategy(ArgumentCount argumentCount) {
        this.argumentCount = argumentCount;
    }

    public WildcardInputTypeStrategy() {
        this(PASSING_ARGUMENT_COUNT);
    }

    @Override
    public ArgumentCount getArgumentCount() {
        return this.argumentCount;
    }

    @Override
    public Optional<List<DataType>> inferInputTypes(CallContext callContext, boolean throwOnFailure) {
        return Optional.of(callContext.getArgumentDataTypes());
    }

    @Override
    public List<Signature> getExpectedSignatures(FunctionDefinition definition) {
        return Collections.singletonList(Signature.of(Signature.Argument.of("*")));
    }

    public boolean equals(Object o) {
        return this == o || o instanceof WildcardInputTypeStrategy;
    }

    public int hashCode() {
        return WildcardInputTypeStrategy.class.hashCode();
    }
}

