/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window.triggers;

import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.state.ReducingState;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.table.runtime.operators.window.Window;
import org.apache.flink.table.runtime.operators.window.triggers.Trigger;

public class ElementTriggers {
    private ElementTriggers() {
    }

    public static <W extends Window> EveryElement<W> every() {
        return new EveryElement();
    }

    public static <W extends Window> CountElement<W> count(long countElems) {
        return new CountElement(countElems);
    }

    public static final class CountElement<W extends Window>
    extends Trigger<W> {
        private static final long serialVersionUID = -3823782971498746808L;
        private final long countElems;
        private final ReducingStateDescriptor<Long> countStateDesc;
        private transient Trigger.TriggerContext ctx;

        CountElement(long countElems) {
            this.countElems = countElems;
            this.countStateDesc = new ReducingStateDescriptor("trigger-count-" + countElems, (ReduceFunction)new Sum(), (TypeSerializer)LongSerializer.INSTANCE);
        }

        @Override
        public void open(Trigger.TriggerContext ctx) throws Exception {
            this.ctx = ctx;
        }

        @Override
        public boolean onElement(Object element, long timestamp, W window) throws Exception {
            ReducingState count = (ReducingState)this.ctx.getPartitionedState(this.countStateDesc);
            count.add((Object)1L);
            if ((Long)count.get() >= this.countElems) {
                count.clear();
                return true;
            }
            return false;
        }

        @Override
        public boolean onProcessingTime(long time, W window) throws Exception {
            return false;
        }

        @Override
        public boolean onEventTime(long time, W window) throws Exception {
            return false;
        }

        @Override
        public void clear(W window) throws Exception {
            ((ReducingState)this.ctx.getPartitionedState(this.countStateDesc)).clear();
        }

        @Override
        public boolean canMerge() {
            return true;
        }

        @Override
        public void onMerge(W window, Trigger.OnMergeContext mergeContext) throws Exception {
            mergeContext.mergePartitionedState(this.countStateDesc);
        }

        public String toString() {
            return "Element.count(" + this.countElems + ")";
        }

        private static class Sum
        implements ReduceFunction<Long> {
            private static final long serialVersionUID = 1L;

            private Sum() {
            }

            public Long reduce(Long value1, Long value2) throws Exception {
                return value1 + value2;
            }
        }
    }

    public static final class EveryElement<W extends Window>
    extends Trigger<W> {
        private static final long serialVersionUID = 3942805366646141029L;

        @Override
        public void open(Trigger.TriggerContext ctx) throws Exception {
        }

        @Override
        public boolean onElement(Object element, long timestamp, W window) throws Exception {
            return true;
        }

        @Override
        public boolean onProcessingTime(long time, W window) throws Exception {
            return false;
        }

        @Override
        public boolean onEventTime(long time, W window) throws Exception {
            return false;
        }

        @Override
        public void clear(W window) throws Exception {
        }

        @Override
        public boolean canMerge() {
            return true;
        }

        @Override
        public void onMerge(W window, Trigger.OnMergeContext mergeContext) throws Exception {
        }

        public String toString() {
            return "Element.every()";
        }
    }
}

