/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.function;

import java.util.List;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;
import org.jaxen.function.NumberFunction;
import org.jaxen.function.RoundFunction;
import org.jaxen.function.StringFunction;

public class SubstringFunction
implements Function {
    public Object call(Context context, List args) throws FunctionCallException {
        int argc = args.size();
        if (argc < 2 || argc > 3) {
            throw new FunctionCallException("substring() requires two or three arguments.");
        }
        Navigator nav = context.getNavigator();
        String str = StringFunction.evaluate(args.get(0), nav);
        if (str == null) {
            return "";
        }
        int strlen = str.length();
        if (strlen == 0) {
            return "";
        }
        Double d1 = NumberFunction.evaluate(args.get(1), nav);
        if (d1.isNaN()) {
            return "";
        }
        int start = RoundFunction.evaluate(d1, nav).intValue() - 1;
        int len = strlen;
        if (argc == 3) {
            Double d2 = NumberFunction.evaluate(args.get(2), nav);
            len = !d2.isNaN() ? RoundFunction.evaluate(d2, nav).intValue() : 0;
        }
        int end = start + len;
        if (start < 0) {
            start = 0;
        } else if (start > strlen) {
            return "";
        }
        if (end > strlen) {
            end = strlen;
        }
        return str.substring(start, end);
    }
}

