/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.definitions.references;

import org.apache.flex.abc.semantics.Name;
import org.apache.flex.compiler.common.DependencyType;
import org.apache.flex.compiler.constants.IASLanguageConstants;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.definitions.ITypeDefinition;
import org.apache.flex.compiler.definitions.references.IReference;
import org.apache.flex.compiler.internal.definitions.DefinitionBase;
import org.apache.flex.compiler.internal.scopes.ASScope;
import org.apache.flex.compiler.projects.ICompilerProject;

public class BuiltinReference
implements IReference {
    private final IASLanguageConstants.BuiltinType builtinType;

    public BuiltinReference(IASLanguageConstants.BuiltinType type) {
        this.builtinType = type;
    }

    @Override
    public String getName() {
        return this.builtinType.getName();
    }

    @Override
    public IDefinition resolve(ICompilerProject project, ASScope scope, DependencyType dependencyType, boolean canEscapeWith) {
        ITypeDefinition definition = project.getBuiltinType(this.builtinType);
        scope.addDependencyOnBuiltinType(project, this.builtinType, dependencyType);
        return definition;
    }

    @Override
    public String getDisplayString() {
        return this.builtinType.getName();
    }

    @Override
    public Name getMName(ICompilerProject project, ASScope scope) {
        ITypeDefinition def = project.getBuiltinType(this.builtinType);
        if (def == null) {
            return null;
        }
        return ((DefinitionBase)((Object)def)).getMName(project);
    }
}

