/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.util;

import flex.messaging.util.ObjectTrace;
import flex.messaging.util.PrettyPrintable;
import flex.messaging.util.PrettyPrinter;
import flex.messaging.util.StringUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public class BasicPrettyPrinter
implements PrettyPrinter {
    protected ObjectTrace trace;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String prettify(Object o) {
        try {
            this.trace = new ObjectTrace();
            this.internalPrettify(o);
            String string = this.trace.toString();
            return string;
        }
        catch (Throwable t) {
            String string = this.trace.toString();
            return string;
        }
        finally {
            this.trace = null;
        }
    }

    protected void internalPrettify(Object o) {
        if (o == null) {
            this.trace.writeNull();
        } else if (o instanceof String) {
            String string = (String)o;
            if (string.startsWith("<?xml")) {
                this.trace.write(StringUtils.prettifyXML(string));
            } else {
                this.trace.write(string);
            }
        } else if (o instanceof Number || o instanceof Boolean || o instanceof Date || o instanceof Calendar || o instanceof Character) {
            this.trace.write(o);
        } else {
            this.prettifyComplexType(o);
        }
    }

    protected void prettifyComplexType(Object o) {
        StringBuffer header = new StringBuffer();
        if (o instanceof PrettyPrintable) {
            PrettyPrintable pp = (PrettyPrintable)o;
            header.append(pp.toStringHeader());
        }
        Class<?> c = o.getClass();
        String className = c.getName();
        if (o instanceof Collection) {
            header.append(className).append(" (Collection size:").append(((Collection)o).size()).append(")");
        } else if (o instanceof Map) {
            header.append(className).append(" (Map size:").append(((Map)o).size()).append(")");
        } else if (c.isArray() && c.getComponentType() != null) {
            Class<?> componentType = c.getComponentType();
            className = componentType.getName();
            header.append(className).append("[] (Array length:").append(Array.getLength(o)).append(")");
        } else {
            header.append(className);
        }
        this.trace.startObject(header.toString());
        this.trace.endObject();
    }

    protected boolean hasCustomToStringMethod(Class c) {
        try {
            Method toStringMethod = c.getMethod("toString", null);
            Class<?> declaringClass = toStringMethod.getDeclaringClass();
            if (declaringClass != Object.class && !declaringClass.getName().startsWith("java.util")) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Override
    public Object copy() {
        return new BasicPrettyPrinter();
    }
}

