/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.rep;

import flash.util.StringJoiner;
import flash.util.StringUtils;
import flex2.compiler.Source;
import flex2.compiler.as3.MetaDataParser;
import flex2.compiler.as3.reflect.MetaData;
import flex2.compiler.common.PathResolver;
import flex2.compiler.common.SinglePathResolver;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.media.AbstractTranscoder;
import flex2.compiler.mxml.rep.LineNumberMapped;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.MimeMappings;
import flex2.compiler.util.ThreadLocalToolkit;
import java.util.HashMap;
import java.util.Map;
import macromedia.asc.util.ContextStatics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtEmbed
implements LineNumberMapped {
    private String propName;
    private int lineNumber;
    private Map<String, Object> attributes;
    private boolean strType;

    public AtEmbed(String propName, int lineNumber, Map<String, Object> attrs, boolean strType) {
        this.propName = propName;
        this.lineNumber = lineNumber;
        this.attributes = attrs;
        this.strType = strType;
    }

    private static void addFileAndLine(Map<String, Object> values, String file, int line) {
        if (file.indexOf(92) > -1) {
            values.put("_file", file.replace('\\', '/'));
            values.put("_pathsep", "true");
        } else {
            values.put("_file", file);
        }
        values.put("_line", Integer.toString(line));
    }

    public String getPropName() {
        return this.propName;
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (object instanceof AtEmbed) {
            result = this.propName.equals(((AtEmbed)object).propName);
        }
        return result;
    }

    public int hashCode() {
        return this.propName.hashCode();
    }

    public String toString() {
        return this.propName;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public int getXmlLineNumber() {
        return this.lineNumber;
    }

    public String getType() {
        return this.strType ? "String" : "Class";
    }

    @Override
    public void setXmlLineNumber(int xmlLineNumber) {
        this.lineNumber = xmlLineNumber;
    }

    public String codegenEmbedVar() {
        String lineSep = System.getProperty("line.separator");
        StringJoiner.MapEntryItemWithEquals itemStringer = new StringJoiner.MapEntryItemWithEquals();
        return "    [Embed(" + StringJoiner.join(this.getAttributes().entrySet(), (String)", ", (StringJoiner.ItemStringer)itemStringer) + ")]" + lineSep + "    private static var " + this.getPropName() + ":" + this.getType() + ";" + lineSep;
    }

    private static AtEmbed createResolved(ContextStatics perCompileData, Source source, String value, String path, int line, String prefix, boolean logInvalidEmbedOnMissingFile) {
        String symbolOrMimeType;
        AtEmbed result = null;
        MetaData metaData = MetaDataParser.parse(perCompileData, source, line, value);
        String sourceValue = null;
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (metaData.count() > 1 && metaData.getKey(0) == null && metaData.getKey(1) == null) {
            sourceValue = metaData.getValue(0);
            symbolOrMimeType = metaData.getValue(1);
            if (MimeMappings.getExtension(symbolOrMimeType) != null) {
                values.put("mimeType", symbolOrMimeType);
            } else {
                values.put("symbol", symbolOrMimeType);
            }
        } else if (metaData.count() > 0 && metaData.getKey(0) == null) {
            sourceValue = metaData.getValue(0);
        } else if (metaData.getValue("skinClass") != null && metaData.getValue("source") != null) {
            AtEmbed.logSkinClassWithSourceNotSupported(value, path, line);
        } else if (metaData.getValue("skinClass") != null) {
            symbolOrMimeType = metaData.getValue("skinClass");
        } else {
            sourceValue = metaData.getValue("source");
        }
        if (sourceValue != null && AtEmbed.tokenizeAndResolveSource(sourceValue, values, source, value, path, line, logInvalidEmbedOnMissingFile) || metaData.getValue("skinClass") != null) {
            String transcoderSource;
            for (Map.Entry e : metaData.getValueMap().entrySet()) {
                String key = (String)e.getKey();
                if (values.containsKey(key)) continue;
                String val = ((String)e.getValue()).replace('\\', '/');
                values.put(key, val);
            }
            if (prefix.equals("_embed_css_") && (transcoderSource = (String)values.get("_resolvedSource")) != null) {
                sourceValue = sourceValue + "_" + transcoderSource.hashCode();
            }
            String propName = AtEmbed.createMangledName(source, sourceValue, false, values, prefix);
            AtEmbed.addFileAndLine(values, path, line);
            result = new AtEmbed(propName, line, values, false);
        }
        return result;
    }

    public static AtEmbed create(ContextStatics perCompileData, Source source, String value, int line) {
        AtEmbed result = null;
        String path = source.getName();
        try {
            result = AtEmbed.createResolved(perCompileData, source, value, path, line, "_embed_mxml_", false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result == null) {
            AtEmbed.logUnableToResolve(value, path, line);
        }
        return result;
    }

    public static AtEmbed create(ContextStatics perCompileData, Source source, String value, String path, int line, String prefix) {
        AtEmbed result = null;
        try {
            result = AtEmbed.createResolved(perCompileData, source, value, path, line, prefix, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result == null) {
            AtEmbed.logInvalidEmbed(value, path, line);
        }
        return result;
    }

    public static AtEmbed create(String baseName, Source source, String path, int beginLine, Map<String, Object> attrs, boolean strType) {
        String embedName = AtEmbed.createMangledName(baseName, attrs.hashCode());
        String sourceValue = (String)attrs.get("source");
        if (sourceValue != null && !AtEmbed.tokenizeAndResolveSource(sourceValue, attrs, source, sourceValue, path, beginLine, true)) {
            AtEmbed.logInvalidEmbed(sourceValue, path, beginLine);
        }
        return new AtEmbed(embedName, beginLine, attrs, strType);
    }

    public static AtEmbed create(ContextStatics perCompileData, Source sourceFile, int beginLine, String value, boolean strType) {
        MetaData metaData = MetaDataParser.parse(perCompileData, sourceFile, beginLine, value.substring(1));
        if (metaData == null) {
            return null;
        }
        if (metaData.count() == 0) {
            ThreadLocalToolkit.log((CompilerMessage)new NoEmbedParams(), sourceFile.getNameForReporting(), beginLine);
            return null;
        }
        String source = metaData.getValue("source");
        if (source == null && metaData.getKey(0) == null && metaData.count() == 1) {
            source = metaData.getValue(0);
        }
        Map<String, Object> values = AtEmbed.getMetaDataMap(metaData);
        String embedName = AtEmbed.createMangledName(sourceFile, source, strType, values, "_embed_mxml_");
        return new AtEmbed(embedName, beginLine, values, strType);
    }

    private static Map<String, Object> getMetaDataMap(flex2.compiler.abc.MetaData metaData) {
        int len = metaData.count();
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (int i = 0; i < len; ++i) {
            String key = metaData.getKey(i);
            String value = metaData.getValue(i);
            if (key == null) {
                values.put("source", value);
                continue;
            }
            values.put(key, value);
        }
        return values;
    }

    public static String createMangledName(Source source, String path, boolean strType, Map<String, Object> attrs, String prefix) {
        String symbol;
        StringBuilder buf = new StringBuilder(128);
        if (prefix != null) {
            buf.append(prefix);
        }
        int hash = attrs.hashCode();
        String mimeType = (String)attrs.get("mimeType");
        VirtualFile f = null;
        if (path != null) {
            buf.append(path);
            f = source.resolve(path);
            if (f != null) {
                hash ^= f.hashCode();
            }
        } else if (mimeType != null) {
            buf.append(mimeType);
        }
        if ((symbol = (String)attrs.get("symbol")) != null) {
            buf.append('_');
            buf.append(symbol);
        }
        if (strType) {
            buf.append("_s");
        }
        return AtEmbed.createMangledName(buf.toString(), hash);
    }

    public static String createMangledName(String name, int hash) {
        return StringUtils.replaceAll((String)(name + '_' + Math.abs(hash)), (String)"[^A-Za-z0-9]", (String)"_");
    }

    private static void logInvalidEmbed(String value, String path, int line) {
        InvalidEmbed invalidEmbed = new InvalidEmbed(value);
        invalidEmbed.path = path;
        invalidEmbed.line = line;
        ThreadLocalToolkit.log(invalidEmbed);
    }

    private static void logUnableToResolve(String value, String path, int line) {
        AbstractTranscoder.UnableToResolve unableToResolve = new AbstractTranscoder.UnableToResolve(value);
        unableToResolve.path = path;
        unableToResolve.line = line;
        ThreadLocalToolkit.log(unableToResolve);
    }

    private static void logSkinClassWithSourceNotSupported(String value, String path, int line) {
        SkinClassWithSourceNotSupported skinClassWithSourceNotSupported = new SkinClassWithSourceNotSupported(value);
        skinClassWithSourceNotSupported.path = path;
        skinClassWithSourceNotSupported.line = line;
        ThreadLocalToolkit.log(skinClassWithSourceNotSupported);
    }

    private static VirtualFile resolveSource(Object owner, Source source, VirtualFile file, String sourcePath) {
        PathResolver context = new PathResolver();
        if (sourcePath != null && sourcePath.charAt(0) == '/') {
            VirtualFile pathRoot = source.getPathRoot();
            if (pathRoot != null) {
                context.addSinglePathResolver(pathRoot);
            }
            if (owner instanceof SinglePathResolver) {
                context.addSinglePathResolver((SinglePathResolver)owner);
            }
        } else if (file != null) {
            context.addSinglePathResolver(file);
        }
        context.addSinglePathResolver(ThreadLocalToolkit.getPathResolver());
        VirtualFile result = context.resolve(sourcePath);
        if (result == null) {
            result = source.resolve(sourcePath);
        }
        return result;
    }

    private static boolean tokenizeAndResolveSource(String sourceValue, Map<String, Object> values, Source source, String value, String path, int line, boolean logInvalidEmbedOnMissingFile) {
        boolean result = true;
        int octothorpe = sourceValue.indexOf(35);
        if (octothorpe != -1) {
            values.put("symbol", sourceValue.substring(octothorpe + 1));
            sourceValue = sourceValue.substring(0, octothorpe);
        }
        VirtualFile file = ThreadLocalToolkit.getPathResolver().resolve(path);
        VirtualFile resolvedFile = AtEmbed.resolveSource(source.getOwner(), source, file, sourceValue);
        if (resolvedFile != null) {
            String resolvedName = resolvedFile.getName().replace('\\', '/');
            values.put("original", sourceValue);
            values.put("_resolvedSource", resolvedName);
            ThreadLocalToolkit.addResolvedPath(resolvedName, resolvedFile);
            values.put("source", resolvedName);
        } else {
            if (logInvalidEmbedOnMissingFile) {
                AtEmbed.logInvalidEmbed(value, path, line);
            }
            result = false;
        }
        return result;
    }

    public static class NoEmbedParams
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -4515392639845938644L;
    }

    public static class SkinClassWithSourceNotSupported
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 2013999515517670024L;
        public String source;

        public SkinClassWithSourceNotSupported(String source) {
            this.source = source;
        }
    }

    public static class InvalidEmbed
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -9221239474314713618L;
        public String source;

        public InvalidEmbed(String source) {
            this.source = source;
        }
    }
}

