/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.media;

import flex2.compiler.SymbolTable;
import flex2.compiler.Transcoder;
import flex2.compiler.TranscoderException;
import flex2.compiler.common.PathResolver;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.media.AbstractTranscoder;
import flex2.compiler.media.DataTranscoder;
import flex2.compiler.util.NameFormatter;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PBJTranscoder
extends AbstractTranscoder {
    private DataTranscoder dataTranscoder = new DataTranscoder();

    public PBJTranscoder() {
        super(new String[]{"application/x-pbj"}, null, true);
    }

    @Override
    public Transcoder.TranscodingResults doTranscode(PathResolver context, SymbolTable symbolTable, Map<String, Object> args, String className, boolean generateSource) throws TranscoderException {
        VirtualFile source = this.resolveSource(context, args);
        String byteArrayClassName = className + "ByteArray";
        args.put("exportSymbol", byteArrayClassName);
        Transcoder.TranscodingResults byteArrayResults = this.dataTranscoder.doTranscode(context, symbolTable, args, byteArrayClassName, generateSource);
        byteArrayResults.className = byteArrayClassName;
        Transcoder.TranscodingResults shaderResults = new Transcoder.TranscodingResults(source);
        shaderResults.className = className;
        if (generateSource) {
            shaderResults.generatedCode = this.generateSource(className, byteArrayClassName);
        }
        shaderResults.additionalAssets = new ArrayList<Transcoder.TranscodingResults>();
        shaderResults.additionalAssets.add(byteArrayResults);
        return shaderResults;
    }

    @Override
    public boolean isSupportedAttribute(String attr) {
        return false;
    }

    private String generateSource(String fullClassName, String byteArrayClassName) {
        String packageName = NameFormatter.retrievePackageName(fullClassName);
        String className = NameFormatter.retrieveClassName(fullClassName);
        StringBuilder sb = new StringBuilder();
        sb.append("package ").append(packageName).append("\n");
        sb.append("{\n");
        sb.append("import flash.display.Shader;\n");
        sb.append("import flash.utils.ByteArray;\n");
        sb.append("import mx.core.IFlexAsset;\n");
        if (packageName.length() > 0) {
            sb.append("import ").append(byteArrayClassName).append(";\n");
        }
        sb.append("\n");
        sb.append("public class ").append(className).append(" extends Shader implements IFlexAsset\n");
        sb.append("{\n");
        sb.append("\tpublic function ").append(className).append("()\n");
        sb.append("    {\n");
        sb.append("        super();\n");
        sb.append("        byteCode = new " + byteArrayClassName + "();\n");
        sb.append("    }\n");
        sb.append("}\n");
        sb.append("}\n");
        return sb.toString();
    }
}

