/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3;

import flex2.compiler.ILocalizableMessage;
import flex2.compiler.Logger;
import flex2.compiler.util.AbstractLogAdapter;

public final class CodeFragmentLogAdapter
extends AbstractLogAdapter {
    private int lineNumberOffset;

    public CodeFragmentLogAdapter(Logger original, int lineNumberOffset) {
        super(original);
        this.lineNumberOffset = lineNumberOffset - 1;
    }

    public void logInfo(String path, int line, String info) {
        this.original.logInfo(path, line + this.lineNumberOffset, info);
    }

    public void logDebug(String path, int line, String debug) {
        this.original.logDebug(path, line + this.lineNumberOffset, debug);
    }

    public void logWarning(String path, int line, String warning) {
        this.original.logWarning(path, line + this.lineNumberOffset, warning);
    }

    public void logWarning(String path, int line, String warning, int errorCode) {
        this.original.logWarning(path, line + this.lineNumberOffset, warning, errorCode);
    }

    public void logError(String path, int line, String error) {
        this.original.logError(path, line + this.lineNumberOffset, error);
    }

    public void logError(String path, int line, String error, int errorCode) {
        this.original.logError(path, line + this.lineNumberOffset, error, errorCode);
    }

    public void logInfo(String path, int line, int col, String info) {
        this.original.logInfo(path, line + this.lineNumberOffset, info);
    }

    public void logDebug(String path, int line, int col, String debug) {
        this.original.logDebug(path, line + this.lineNumberOffset, debug);
    }

    public void logWarning(String path, int line, int col, String warning) {
        this.original.logWarning(path, line + this.lineNumberOffset, warning);
    }

    public void logError(String path, int line, int col, String error) {
        this.original.logError(path, line + this.lineNumberOffset, error);
    }

    public void logWarning(String path, int line, int col, String warning, String source) {
        this.original.logWarning(path, line + this.lineNumberOffset, warning);
    }

    public void logWarning(String path, int line, int col, String warning, String source, int errorCode) {
        this.original.logWarning(path, line + this.lineNumberOffset, warning, errorCode);
    }

    public void logError(String path, int line, int col, String error, String source) {
        this.original.logError(path, line + this.lineNumberOffset, error);
    }

    public void logError(String path, int line, int col, String error, String source, int errorCode) {
        this.original.logError(path, line + this.lineNumberOffset, error, errorCode);
    }

    public void log(ILocalizableMessage m) {
        m.setLine(m.getLine() + this.lineNumberOffset);
        this.original.log(m);
    }

    public void log(ILocalizableMessage m, String source) {
        m.setLine(m.getLine() + this.lineNumberOffset);
        this.original.log(m, source);
    }
}

