/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.useradmin.mongodb;

final class KeyCodec {
    private static final String ENCODED_NULL = "%00";
    private static final String ENCODED_UNDERSCORE = "%5F";
    private static final String ENCODED_DOT = "%2E";
    private static final String ENCODED_DOLLAR = "%24";

    KeyCodec() {
    }

    public static String encode(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(input.length());
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\u0000') {
                sb.append(ENCODED_NULL);
                continue;
            }
            if (c == '_') {
                sb.append(ENCODED_UNDERSCORE);
                continue;
            }
            if (c == '.') {
                sb.append(ENCODED_DOT);
                continue;
            }
            if (c == '$') {
                sb.append(ENCODED_DOLLAR);
                continue;
            }
            if (c == '%') {
                sb.append("%%");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String decode(String input) {
        if (input == null) {
            return null;
        }
        boolean percentSeen = false;
        int length = input.length();
        char oldC = input.charAt(0);
        StringBuilder sb = new StringBuilder(input.length());
        for (int i = 1; i < length; ++i) {
            char c = input.charAt(i);
            if (oldC == '%') {
                if (c == '%') {
                    sb.append("%");
                    c = '\u0000';
                    percentSeen = false;
                } else {
                    percentSeen = true;
                }
            } else if (c == '%') {
                percentSeen = true;
            } else if (percentSeen) {
                if (oldC == '0' && c == '0') {
                    sb.append('\u0000');
                    percentSeen = false;
                } else if (oldC == '2' && c == '4') {
                    sb.append("$");
                    percentSeen = false;
                } else if (oldC == '2' && c == 'E') {
                    sb.append(".");
                    percentSeen = false;
                } else if (oldC == '5' && c == 'F') {
                    sb.append("_");
                    percentSeen = false;
                } else {
                    sb.append("%").append(oldC).append(c);
                    percentSeen = false;
                }
            } else {
                if (i == 1) {
                    sb.append(oldC);
                }
                sb.append(c);
            }
            if (percentSeen && i == length - 1) {
                if (oldC != '%' && c != '%') {
                    sb.append("%").append(oldC).append(c);
                } else if (oldC == '%' && c != '%') {
                    sb.append("%").append(c);
                } else if (c == '%') {
                    sb.append("%");
                }
            }
            oldC = c;
        }
        return sb.toString();
    }
}

