/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.upnp.tester.gui;

import java.util.Collection;
import java.util.Iterator;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.felix.upnp.tester.discovery.DeviceNode;
import org.osgi.framework.BundleContext;
import org.osgi.service.upnp.UPnPAction;
import org.osgi.service.upnp.UPnPDevice;
import org.osgi.service.upnp.UPnPService;
import org.osgi.service.upnp.UPnPStateVariable;

public class UPnPDeviceTreeNode
extends DefaultMutableTreeNode {
    public static final String ROOT_DEVICE = "RootDeviceNode";
    public static final String DEVICE = "DeviceNode";
    public static final String SERVICE = "UPnPService";
    public static final String ACTION = "UPnPAction";
    public static final String STATE = "UPnPStateVariable";
    public static final String EVENTED_STATE = "EventedStateVariable";
    public static final String SUBSCRIBED_STATE = "SubscribedStateVariable";
    protected String category;

    public UPnPDeviceTreeNode(String obj) {
        super(obj);
        this.category = obj.getClass().getName();
    }

    public UPnPDeviceTreeNode(DeviceNode obj, BundleContext ctx) {
        super(obj);
        this.category = obj.isRoot() ? ROOT_DEVICE : DEVICE;
        UPnPDevice device = (UPnPDevice)ctx.getService(obj.getReference());
        UPnPService[] services = device.getServices();
        Collection nodeChildren = obj.getChildren();
        if (nodeChildren != null) {
            Iterator list = nodeChildren.iterator();
            while (list.hasNext()) {
                DeviceNode node = (DeviceNode)list.next();
                this.add(new UPnPDeviceTreeNode(node, ctx));
            }
        }
        if (services != null) {
            for (int i = 0; i < services.length; ++i) {
                this.add(new UPnPDeviceTreeNode(services[i]));
            }
        }
    }

    public UPnPDeviceTreeNode(UPnPService obj) {
        super(obj);
        UPnPAction[] actions;
        this.category = SERVICE;
        UPnPStateVariable[] variables = obj.getStateVariables();
        if (variables != null) {
            for (int i = 0; i < variables.length; ++i) {
                this.add(new UPnPDeviceTreeNode(variables[i]));
            }
        }
        if ((actions = obj.getActions()) != null) {
            for (int i = 0; i < actions.length; ++i) {
                this.add(new UPnPDeviceTreeNode(actions[i]));
            }
        }
    }

    public UPnPDeviceTreeNode(UPnPAction obj) {
        super(obj);
        this.category = ACTION;
    }

    public UPnPDeviceTreeNode(UPnPStateVariable obj) {
        super(obj);
        this.category = obj.sendsEvents() ? EVENTED_STATE : STATE;
    }

    public String toString() {
        if (this.category.equals(DEVICE) || this.category.equals(ROOT_DEVICE)) {
            DeviceNode node = (DeviceNode)this.getUserObject();
            return node.toString();
        }
        if (this.category.equals(SERVICE)) {
            UPnPService node = (UPnPService)this.getUserObject();
            return node.getType();
        }
        if (this.category.equals(ACTION)) {
            UPnPAction node = (UPnPAction)this.getUserObject();
            return node.getName();
        }
        if (this.category.equals(STATE) || this.category.equals(EVENTED_STATE) || this.category.equals(SUBSCRIBED_STATE)) {
            UPnPStateVariable node = (UPnPStateVariable)this.getUserObject();
            return node.getName();
        }
        return this.getUserObject().toString();
    }
}

