/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.test.scenarios.annotations;

import org.apache.felix.ipojo.junit4osgi.OSGiTestCase;
import org.apache.felix.ipojo.junit4osgi.helpers.IPOJOHelper;
import org.apache.felix.ipojo.metadata.Element;

public class EventAdmin
extends OSGiTestCase {
    String type = "org.apache.felix.ipojo.test.scenarios.component.event.PubSub";
    String deprecated = "org.apache.felix.ipojo.test.scenarios.component.event.PubSubDeprecated";
    String publishes = "org.apache.felix.ipojo.test.scenarios.component.event.PubSubWithPublishes";
    String namespace = "org.apache.felix.ipojo.handlers.event";
    Element component;
    Element componentDeprecated;
    Element componentWithPublishes;
    private IPOJOHelper helper;

    public void setUp() {
        this.helper = new IPOJOHelper((OSGiTestCase)this);
        this.component = this.helper.getMetadata(this.type);
        this.componentDeprecated = this.helper.getMetadata(this.deprecated);
        this.componentWithPublishes = this.helper.getMetadata(this.publishes);
        EventAdmin.assertNotNull((String)"Check component", (Object)this.component);
        EventAdmin.assertNotNull((String)"Check deprecated", (Object)this.componentDeprecated);
        EventAdmin.assertNotNull((String)"Check publishes", (Object)this.componentWithPublishes);
    }

    public void tearDown() {
        this.component = null;
        this.componentDeprecated = null;
        this.componentWithPublishes = null;
    }

    public void testP1() {
        Element elem = this.getElementByName("p1");
        this.checkPublisher(elem);
        EventAdmin.assertNull((String)"Check topics", (Object)elem.getAttribute("topics"));
        EventAdmin.assertEquals((String)"Check synchronous", (String)"true", (String)elem.getAttribute("synchronous"));
        EventAdmin.assertEquals((String)"Check field", (String)"publisher1", (String)elem.getAttribute("field"));
        EventAdmin.assertNull((String)"Check data_key", (Object)elem.getAttribute("dataKey"));
    }

    public void testP1WithPublishes() {
        Element elem = this.getPublishesByName("p1");
        this.checkPublishes(elem);
        EventAdmin.assertNull((String)"Check topics", (Object)elem.getAttribute("topics"));
        EventAdmin.assertEquals((String)"Check synchronous", (String)"true", (String)elem.getAttribute("synchronous"));
        EventAdmin.assertEquals((String)"Check field", (String)"publisher1", (String)elem.getAttribute("field"));
        EventAdmin.assertNull((String)"Check data_key", (Object)elem.getAttribute("dataKey"));
    }

    public void testP1Deprecated() {
        Element elem = this.getDeprecatedElementByName("p1");
        this.checkPublisher(elem);
        EventAdmin.assertNull((String)"Check topics", (Object)elem.getAttribute("topics"));
        EventAdmin.assertEquals((String)"Check synchronous", (String)"true", (String)elem.getAttribute("synchronous"));
        EventAdmin.assertEquals((String)"Check field", (String)"publisher1", (String)elem.getAttribute("field"));
        EventAdmin.assertNull((String)"Check data_key", (Object)elem.getAttribute("data_key"));
    }

    public void testP2() {
        Element elem = this.getElementByName("p2");
        this.checkPublisher(elem);
        EventAdmin.assertEquals((String)("Check topics (" + elem.getAttribute("topics") + ")"), (String)"foo,bar", (String)elem.getAttribute("topics"));
        EventAdmin.assertEquals((String)"Check synchronous", (String)"false", (String)elem.getAttribute("synchronous"));
        EventAdmin.assertEquals((String)"Check field", (String)"publisher2", (String)elem.getAttribute("field"));
        EventAdmin.assertEquals((String)"Check data_key", (String)"data", (String)elem.getAttribute("dataKey"));
    }

    public void testP2WithPublishes() {
        Element elem = this.getPublishesByName("p2");
        this.checkPublishes(elem);
        EventAdmin.assertEquals((String)("Check topics (" + elem.getAttribute("topics") + ")"), (String)"foo,bar", (String)elem.getAttribute("topics"));
        EventAdmin.assertEquals((String)"Check synchronous", (String)"false", (String)elem.getAttribute("synchronous"));
        EventAdmin.assertEquals((String)"Check field", (String)"publisher2", (String)elem.getAttribute("field"));
        EventAdmin.assertEquals((String)"Check data_key", (String)"data", (String)elem.getAttribute("dataKey"));
    }

    public void testP2Deprecated() {
        Element elem = this.getDeprecatedElementByName("p2");
        this.checkPublisher(elem);
        EventAdmin.assertEquals((String)("Check topics (" + elem.getAttribute("topics") + ")"), (String)"foo,bar", (String)elem.getAttribute("topics"));
        EventAdmin.assertEquals((String)"Check synchronous", (String)"false", (String)elem.getAttribute("synchronous"));
        EventAdmin.assertEquals((String)"Check field", (String)"publisher2", (String)elem.getAttribute("field"));
        EventAdmin.assertEquals((String)"Check data_key", (String)"data", (String)elem.getAttribute("data_key"));
    }

    public void testP3() {
        Element elem = this.getElementByName("p3");
        this.checkPublisher(elem);
        EventAdmin.assertEquals((String)"Check topics", (String)"bar", (String)elem.getAttribute("topics"));
        EventAdmin.assertEquals((String)"Check synchronous", (String)"true", (String)elem.getAttribute("synchronous"));
        EventAdmin.assertEquals((String)"Check field", (String)"publisher3", (String)elem.getAttribute("field"));
        EventAdmin.assertNull((String)"Check data_key", (Object)elem.getAttribute("dataKey"));
    }

    public void testWithPublishesP3() {
        Element elem = this.getPublishesByName("p3");
        this.checkPublishes(elem);
        EventAdmin.assertEquals((String)"Check topics", (String)"bar", (String)elem.getAttribute("topics"));
        EventAdmin.assertEquals((String)"Check synchronous", (String)"true", (String)elem.getAttribute("synchronous"));
        EventAdmin.assertEquals((String)"Check field", (String)"publisher3", (String)elem.getAttribute("field"));
        EventAdmin.assertNull((String)"Check data_key", (Object)elem.getAttribute("dataKey"));
    }

    public void testP3Deprecated() {
        Element elem = this.getDeprecatedElementByName("p3");
        this.checkPublisher(elem);
        EventAdmin.assertEquals((String)"Check topics", (String)"bar", (String)elem.getAttribute("topics"));
        EventAdmin.assertEquals((String)"Check synchronous", (String)"true", (String)elem.getAttribute("synchronous"));
        EventAdmin.assertEquals((String)"Check field", (String)"publisher3", (String)elem.getAttribute("field"));
        EventAdmin.assertNull((String)"Check data_key", (Object)elem.getAttribute("data_key"));
    }

    public void testS1() {
        Element elem = this.getElementByName("s1");
        this.checkSubscriber(elem);
        EventAdmin.assertNull((String)"Check topics", (Object)elem.getAttribute("topics"));
        EventAdmin.assertEquals((String)"Check method", (String)"receive1", (String)elem.getAttribute("method"));
        EventAdmin.assertEquals((String)"Check data_key", (String)"data", (String)elem.getAttribute("dataKey"));
        EventAdmin.assertNull((String)"Check data_type", (Object)elem.getAttribute("dataType"));
        EventAdmin.assertNull((String)"Check filter", (Object)elem.getAttribute("filter"));
    }

    public void testS1Deprecated() {
        Element elem = this.getDeprecatedElementByName("s1");
        this.checkSubscriber(elem);
        EventAdmin.assertNull((String)"Check topics", (Object)elem.getAttribute("topics"));
        EventAdmin.assertEquals((String)"Check method", (String)"receive1", (String)elem.getAttribute("method"));
        EventAdmin.assertEquals((String)"Check data_key", (String)"data", (String)elem.getAttribute("data_key"));
        EventAdmin.assertNull((String)"Check data_type", (Object)elem.getAttribute("data_type"));
        EventAdmin.assertNull((String)"Check filter", (Object)elem.getAttribute("filter"));
    }

    public void testS2() {
        Element elem = this.getElementByName("s2");
        this.checkSubscriber(elem);
        EventAdmin.assertEquals((String)"Check topics", (String)"foo,bar", (String)elem.getAttribute("topics"));
        EventAdmin.assertEquals((String)"Check method", (String)"receive2", (String)elem.getAttribute("method"));
        EventAdmin.assertNull((String)"Check data_key", (Object)elem.getAttribute("dataKey"));
        EventAdmin.assertNull((String)"Check data_type", (Object)elem.getAttribute("dataType"));
        EventAdmin.assertEquals((String)"Check filter", (String)"(foo=true)", (String)elem.getAttribute("filter"));
    }

    public void testS2Deprecated() {
        Element elem = this.getDeprecatedElementByName("s2");
        this.checkSubscriber(elem);
        EventAdmin.assertEquals((String)"Check topics", (String)"foo,bar", (String)elem.getAttribute("topics"));
        EventAdmin.assertEquals((String)"Check method", (String)"receive2", (String)elem.getAttribute("method"));
        EventAdmin.assertNull((String)"Check data_key", (Object)elem.getAttribute("data_key"));
        EventAdmin.assertNull((String)"Check data_type", (Object)elem.getAttribute("data_type"));
        EventAdmin.assertEquals((String)"Check filter", (String)"(foo=true)", (String)elem.getAttribute("filter"));
    }

    public void testS3() {
        Element elem = this.getElementByName("s3");
        this.checkSubscriber(elem);
        EventAdmin.assertEquals((String)"Check topics", (String)"foo", (String)elem.getAttribute("topics"));
        EventAdmin.assertEquals((String)"Check method", (String)"receive3", (String)elem.getAttribute("method"));
        EventAdmin.assertEquals((String)"Check data_key", (String)"data", (String)elem.getAttribute("dataKey"));
        EventAdmin.assertEquals((String)"Check data_type", (String)"java.lang.String", (String)elem.getAttribute("dataType"));
        EventAdmin.assertNull((String)"Check filter", (Object)elem.getAttribute("filter"));
    }

    public void testS3Deprecated() {
        Element elem = this.getDeprecatedElementByName("s3");
        this.checkSubscriber(elem);
        EventAdmin.assertEquals((String)"Check topics", (String)"foo", (String)elem.getAttribute("topics"));
        EventAdmin.assertEquals((String)"Check method", (String)"receive3", (String)elem.getAttribute("method"));
        EventAdmin.assertEquals((String)"Check data_key", (String)"data", (String)elem.getAttribute("data_key"));
        EventAdmin.assertEquals((String)"Check data_type", (String)"java.lang.String", (String)elem.getAttribute("data_type"));
        EventAdmin.assertNull((String)"Check filter", (Object)elem.getAttribute("filter"));
    }

    public Element getElementByName(String name) {
        Element[] elems = this.component.getElements();
        int i = 0;
        while (i < elems.length) {
            if (elems[i].containsAttribute("name") && elems[i].getAttribute("name").equals(name)) {
                return elems[i];
            }
            ++i;
        }
        return null;
    }

    public Element getPublishesByName(String name) {
        Element[] elems = this.componentWithPublishes.getElements();
        int i = 0;
        while (i < elems.length) {
            if (elems[i].containsAttribute("name") && elems[i].getAttribute("name").equals(name)) {
                return elems[i];
            }
            ++i;
        }
        return null;
    }

    public Element getDeprecatedElementByName(String name) {
        Element[] elems = this.componentDeprecated.getElements();
        int i = 0;
        while (i < elems.length) {
            if (elems[i].containsAttribute("name") && elems[i].getAttribute("name").equals(name)) {
                return elems[i];
            }
            ++i;
        }
        return null;
    }

    public void checkSubscriber(Element elem) {
        EventAdmin.assertNotNull((String)"Can't check subscriber : null element", (Object)elem);
        String ns = elem.getNameSpace();
        String nm = elem.getName();
        EventAdmin.assertEquals((String)"Elem is not a subscriber : bad namespace", (String)this.namespace, (String)ns);
        EventAdmin.assertEquals((String)"Elem is not a subscriber : bad name", (String)"subscriber", (String)nm);
    }

    public void checkPublisher(Element elem) {
        EventAdmin.assertNotNull((String)"Can't check publisher : null element", (Object)elem);
        String ns = elem.getNameSpace();
        String nm = elem.getName();
        EventAdmin.assertEquals((String)"Elem is not a publisher : bad namespace", (String)this.namespace, (String)ns);
        EventAdmin.assertEquals((String)"Elem is not a publisher : bad name", (String)"publisher", (String)nm);
    }

    public void checkPublishes(Element elem) {
        EventAdmin.assertNotNull((String)"Can't check publisher : null element", (Object)elem);
        String ns = elem.getNameSpace();
        String nm = elem.getName();
        EventAdmin.assertEquals((String)"Elem is not a publisher : bad namespace", (String)this.namespace, (String)ns);
        EventAdmin.assertEquals((String)"Elem is not a publisher : bad name", (String)"publishes", (String)nm);
    }
}

