/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.connect.felix.framework.capabilityset;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.felix.connect.felix.framework.capabilityset.SimpleFilter;
import org.apache.felix.connect.felix.framework.util.StringComparator;
import org.osgi.resource.Capability;

public class CapabilitySet<T extends Capability> {
    private final Map<String, Map<Object, Set<T>>> m_indices;
    private final Set<T> m_capSet = new HashSet<T>();
    private static final Class<?>[] STRING_CLASS = new Class[]{String.class};

    public CapabilitySet(List<String> indexProps, boolean caseSensitive) {
        this.m_indices = caseSensitive ? new TreeMap<String, Map<Object, Set<T>>>() : new TreeMap(new StringComparator(false));
        for (int i = 0; indexProps != null && i < indexProps.size(); ++i) {
            this.m_indices.put(indexProps.get(i), new HashMap());
        }
    }

    public void addCapability(T cap) {
        this.m_capSet.add(cap);
        for (Map.Entry<String, Map<Object, Set<T>>> entry : this.m_indices.entrySet()) {
            List<Object> value = cap.getAttributes().get(entry.getKey());
            if (value == null) continue;
            if (value.getClass().isArray()) {
                value = CapabilitySet.convertArrayToList(value);
            }
            Map<Object, Set<T>> index = entry.getValue();
            if (value instanceof Collection) {
                Collection c = value;
                for (Object o : c) {
                    this.indexCapability(index, cap, o);
                }
                continue;
            }
            this.indexCapability(index, cap, value);
        }
    }

    private void indexCapability(Map<Object, Set<T>> index, T cap, Object capValue) {
        Set<T> caps = index.get(capValue);
        if (caps == null) {
            caps = new HashSet<T>();
            index.put(capValue, caps);
        }
        caps.add(cap);
    }

    public void removeCapability(T cap) {
        if (this.m_capSet.remove(cap)) {
            for (Map.Entry<String, Map<Object, Set<T>>> entry : this.m_indices.entrySet()) {
                List<Object> value = cap.getAttributes().get(entry.getKey());
                if (value == null) continue;
                if (value.getClass().isArray()) {
                    value = CapabilitySet.convertArrayToList(value);
                }
                Map<Object, Set<T>> index = entry.getValue();
                if (value instanceof Collection) {
                    Collection c = value;
                    for (Object o : c) {
                        this.deindexCapability(index, cap, o);
                    }
                    continue;
                }
                this.deindexCapability(index, cap, value);
            }
        }
    }

    private void deindexCapability(Map<Object, Set<T>> index, T cap, Object value) {
        Set<T> caps = index.get(value);
        if (caps != null) {
            caps.remove(cap);
            if (caps.isEmpty()) {
                index.remove(value);
            }
        }
    }

    public Set<T> match(SimpleFilter sf, boolean obeyMandatory) {
        Set<T> matches = this.match(this.m_capSet, sf);
        return matches;
    }

    private Set<T> match(Set<T> caps, SimpleFilter sf) {
        Set<Object> matches;
        block5: {
            block9: {
                block8: {
                    block7: {
                        block6: {
                            block4: {
                                matches = new HashSet<T>();
                                if (sf.getOperation() != 0) break block4;
                                matches.addAll(caps);
                                break block5;
                            }
                            if (sf.getOperation() != 1) break block6;
                            List sfs = (List)sf.getValue();
                            for (int i = 0; caps.size() > 0 && i < sfs.size(); ++i) {
                                matches = this.match(caps, (SimpleFilter)sfs.get(i));
                                caps = matches;
                            }
                            break block5;
                        }
                        if (sf.getOperation() != 2) break block7;
                        List sfs = (List)sf.getValue();
                        for (SimpleFilter sf1 : sfs) {
                            matches.addAll(this.match(caps, sf1));
                        }
                        break block5;
                    }
                    if (sf.getOperation() != 3) break block8;
                    matches.addAll(caps);
                    List sfs = (List)sf.getValue();
                    for (SimpleFilter sf1 : sfs) {
                        matches.removeAll(this.match(caps, sf1));
                    }
                    break block5;
                }
                Map<Object, Set<T>> index = this.m_indices.get(sf.getName());
                if (sf.getOperation() != 4 || index == null) break block9;
                Set<T> existingCaps = index.get(sf.getValue());
                if (existingCaps == null) break block5;
                matches.addAll(existingCaps);
                matches.retainAll(caps);
                break block5;
            }
            for (Capability cap : caps) {
                Object lhs = cap.getAttributes().get(sf.getName());
                if (lhs == null || !CapabilitySet.compare(lhs, sf.getValue(), sf.getOperation())) continue;
                matches.add(cap);
            }
        }
        return matches;
    }

    private boolean matchesInternal(T cap, SimpleFilter sf) {
        boolean matched = true;
        if (sf.getOperation() == 0) {
            matched = true;
        } else if (sf.getOperation() == 1) {
            List sfs = (List)sf.getValue();
            for (int i = 0; matched && i < sfs.size(); ++i) {
                matched = this.matchesInternal(cap, (SimpleFilter)sfs.get(i));
            }
        } else if (sf.getOperation() == 2) {
            matched = false;
            List sfs = (List)sf.getValue();
            for (int i = 0; !matched && i < sfs.size(); ++i) {
                matched = this.matchesInternal(cap, (SimpleFilter)sfs.get(i));
            }
        } else if (sf.getOperation() == 3) {
            List sfs = (List)sf.getValue();
            for (SimpleFilter sf1 : sfs) {
                matched = !this.matchesInternal(cap, sf1);
            }
        } else {
            matched = false;
            Object lhs = cap.getAttributes().get(sf.getName());
            if (lhs != null) {
                matched = CapabilitySet.compare(lhs, sf.getValue(), sf.getOperation());
            }
        }
        return matched;
    }

    private static boolean compare(Object lhs, Object rhsUnknown, int op) {
        if (lhs == null) {
            return false;
        }
        if (op == 8) {
            return true;
        }
        if (lhs instanceof Comparable) {
            Object rhs;
            if (op == 7 && !(lhs instanceof String)) {
                return false;
            }
            if (op == 7) {
                rhs = rhsUnknown;
            } else {
                try {
                    rhs = CapabilitySet.coerceType(lhs, (String)rhsUnknown);
                }
                catch (Exception ex) {
                    return false;
                }
            }
            switch (op) {
                case 4: {
                    try {
                        return ((Comparable)((Object)lhs)).compareTo(rhs) == 0;
                    }
                    catch (Exception ex) {
                        return false;
                    }
                }
                case 6: {
                    try {
                        return ((Comparable)((Object)lhs)).compareTo(rhs) >= 0;
                    }
                    catch (Exception ex) {
                        return false;
                    }
                }
                case 5: {
                    try {
                        return ((Comparable)((Object)lhs)).compareTo(rhs) <= 0;
                    }
                    catch (Exception ex) {
                        return false;
                    }
                }
                case 9: {
                    return CapabilitySet.compareApproximate(lhs, rhs);
                }
                case 7: {
                    return SimpleFilter.compareSubstring((List)rhs, (String)((Object)lhs));
                }
            }
            throw new RuntimeException("Unknown comparison operator: " + op);
        }
        if (lhs.getClass().isArray()) {
            lhs = CapabilitySet.convertArrayToList(lhs);
        }
        if (lhs instanceof Collection) {
            for (Object o : (Collection)lhs) {
                if (!CapabilitySet.compare(o, rhsUnknown, op)) continue;
                return true;
            }
            return false;
        }
        if (op == 7) {
            return false;
        }
        try {
            return ((Object)lhs).equals(CapabilitySet.coerceType(lhs, (String)rhsUnknown));
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static boolean compareApproximate(Object lhs, Object rhs) {
        if (rhs instanceof String) {
            return CapabilitySet.removeWhitespace((String)lhs).equalsIgnoreCase(CapabilitySet.removeWhitespace((String)rhs));
        }
        if (rhs instanceof Character) {
            return Character.toLowerCase(((Character)lhs).charValue()) == Character.toLowerCase(((Character)rhs).charValue());
        }
        return lhs.equals(rhs);
    }

    private static String removeWhitespace(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            sb.append(s.charAt(i));
        }
        return sb.toString();
    }

    private static Object coerceType(Object lhs, String rhsString) throws Exception {
        Character rhs;
        if (lhs.getClass() == rhsString.getClass()) {
            return rhsString;
        }
        try {
            if (lhs instanceof Character) {
                rhs = Character.valueOf(rhsString.charAt(0));
            } else {
                if (lhs instanceof Number || lhs instanceof Boolean) {
                    rhsString = rhsString.trim();
                }
                Constructor<?> ctor = lhs.getClass().getConstructor(STRING_CLASS);
                ctor.setAccessible(true);
                rhs = ctor.newInstance(rhsString);
            }
        }
        catch (Exception ex) {
            throw new Exception("Could not instantiate class " + lhs.getClass().getName() + " from string constructor with argument '" + rhsString + "' because " + ex);
        }
        return rhs;
    }

    private static List<Object> convertArrayToList(Object array) {
        int len = Array.getLength(array);
        ArrayList<Object> list = new ArrayList<Object>(len);
        for (int i = 0; i < len; ++i) {
            list.add(Array.get(array, i));
        }
        return list;
    }
}

