/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.connect;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.felix.connect.BundleAware;
import org.apache.felix.connect.EntryFilterEnumeration;
import org.apache.felix.connect.PojoSRBundleContext;
import org.apache.felix.connect.Revision;
import org.apache.felix.connect.felix.framework.ServiceRegistry;
import org.apache.felix.connect.felix.framework.util.EventDispatcher;
import org.apache.felix.connect.felix.framework.util.MapToDictionary;
import org.apache.felix.connect.felix.framework.util.StringMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleRevisions;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Wire;

class PojoSRBundle
implements Bundle,
BundleRevisions {
    private final Revision m_revision;
    private final Map<String, String> m_headers;
    private final Version m_version;
    private final String m_location;
    private final Map<Long, Bundle> m_bundles;
    private final ServiceRegistry m_registry;
    private final String m_activatorClass;
    private final long m_id;
    private final String m_symbolicName;
    private volatile BundleActivator m_activator = null;
    volatile int m_state = 4;
    volatile BundleContext m_context = null;
    private final EventDispatcher m_dispatcher;
    private final ClassLoader m_classLoader;
    private final Map<Class, Object> m_services;
    private final Map m_config;
    private final Map<String, Map<String, String>> m_cachedHeaders = new HashMap<String, Map<String, String>>();
    private long m_cachedHeadersTimestamp;

    public PojoSRBundle(ServiceRegistry registry, EventDispatcher dispatcher, Map<Long, Bundle> bundles, String location, long id, String symbolicName, Version version, Revision revision, ClassLoader classLoader, Map<String, String> headers, Map<Class, Object> services, Map<? extends Object, ? extends Object> config) {
        this.m_revision = revision;
        this.m_headers = headers;
        this.m_version = version;
        this.m_location = location;
        this.m_registry = registry;
        this.m_dispatcher = dispatcher;
        this.m_activatorClass = headers.get("Bundle-Activator");
        this.m_id = id;
        this.m_symbolicName = symbolicName;
        this.m_bundles = bundles;
        this.m_classLoader = classLoader;
        this.m_services = services;
        this.m_config = config;
        if (classLoader instanceof BundleAware) {
            ((BundleAware)((Object)classLoader)).setBundle(this);
        }
        if (services != null) {
            for (Object o : services.values()) {
                if (!(o instanceof BundleAware)) continue;
                ((BundleAware)o).setBundle(this);
            }
        }
    }

    @Override
    public int getState() {
        return this.m_state;
    }

    @Override
    public void start(int options) throws BundleException {
        this.start();
    }

    @Override
    public synchronized void start() throws BundleException {
        if (this.m_state != 4) {
            if (this.m_state == 32) {
                return;
            }
            throw new BundleException("Bundle is in wrong state for start");
        }
        try {
            this.m_state = 8;
            this.m_context = new PojoSRBundleContext(this, this.m_registry, this.m_dispatcher, this.m_bundles, this.m_config);
            this.m_dispatcher.fireBundleEvent(new BundleEvent(128, this));
            if (this.m_activatorClass != null) {
                this.m_activator = (BundleActivator)this.m_classLoader.loadClass(this.m_activatorClass).newInstance();
                this.m_activator.start(this.m_context);
            }
            this.m_state = 32;
            this.m_dispatcher.fireBundleEvent(new BundleEvent(2, this));
        }
        catch (Throwable ex) {
            this.m_state = 4;
            this.m_activator = null;
            this.m_dispatcher.fireBundleEvent(new BundleEvent(4, this));
            throw new BundleException("Unable to start bundle", ex);
        }
    }

    @Override
    public void stop(int options) throws BundleException {
        this.stop();
    }

    @Override
    public synchronized void stop() throws BundleException {
        if (this.m_state != 32) {
            if (this.m_state == 4) {
                return;
            }
            throw new BundleException("Bundle is in wrong state for stop");
        }
        try {
            this.m_state = 16;
            this.m_dispatcher.fireBundleEvent(new BundleEvent(256, this));
            if (this.m_activator != null) {
                this.m_activator.stop(this.m_context);
            }
        }
        catch (Throwable ex) {
            throw new BundleException("Error while stopping bundle", ex);
        }
        finally {
            this.m_registry.unregisterServices(this);
            this.m_dispatcher.removeListeners(this.m_context);
            this.m_activator = null;
            this.m_context = null;
            this.m_state = 4;
            this.m_dispatcher.fireBundleEvent(new BundleEvent(4, this));
        }
    }

    @Override
    public void update(InputStream input) throws BundleException {
        throw new BundleException("pojosr bundles can't be updated");
    }

    @Override
    public void update() throws BundleException {
        throw new BundleException("pojosr bundles can't be updated");
    }

    @Override
    public void uninstall() throws BundleException {
        throw new BundleException("pojosr bundles can't be uninstalled");
    }

    @Override
    public Dictionary<String, String> getHeaders() {
        return this.getHeaders(Locale.getDefault().toString());
    }

    @Override
    public long getBundleId() {
        return this.m_id;
    }

    @Override
    public String getLocation() {
        return this.m_location;
    }

    @Override
    public ServiceReference<?>[] getRegisteredServices() {
        return this.m_registry.getRegisteredServices(this);
    }

    @Override
    public ServiceReference<?>[] getServicesInUse() {
        return this.m_registry.getServicesInUse(this);
    }

    @Override
    public boolean hasPermission(Object permission) {
        return true;
    }

    @Override
    public URL getResource(String name) {
        URL result = this.m_classLoader.getResource(name);
        return result;
    }

    @Override
    public Dictionary<String, String> getHeaders(String locale) {
        return new MapToDictionary<String, String>(this.getCurrentLocalizedHeader(locale));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, String> getCurrentLocalizedHeader(String locale) {
        Map<String, Object> result = null;
        if (locale == null || locale.length() == 0) {
            result = new StringMap<String>(this.m_headers, false);
        }
        if (result == null) {
            Map<String, Map<String, String>> map = this.m_cachedHeaders;
            synchronized (map) {
                if (this.getState() == 1) {
                    result = this.m_cachedHeaders.values().iterator().next();
                } else if (this.getLastModified() > this.m_cachedHeadersTimestamp) {
                    this.m_cachedHeaders.clear();
                } else {
                    result = this.m_cachedHeaders.get(locale);
                }
            }
        }
        if (result == null) {
            StringMap<String> headers = new StringMap<String>(this.m_headers, false);
            result = headers;
            boolean localize = false;
            for (String s : headers.values()) {
                if (!s.startsWith("%")) continue;
                localize = true;
                break;
            }
            if (!localize) {
                this.updateHeaderCache(locale, headers);
            } else {
                String basename = (String)headers.get("Bundle-Localization");
                if (basename == null) {
                    basename = "OSGI-INF/l10n/bundle";
                }
                List<String> resourceList = PojoSRBundle.createLocalizationResourceList(basename, locale);
                boolean found = false;
                Properties mergedProperties = new Properties();
                for (String string : resourceList) {
                    URL temp = this.m_revision.getEntry(string + ".properties");
                    if (temp == null) continue;
                    found = true;
                    try {
                        mergedProperties.load(temp.openConnection().getInputStream());
                    }
                    catch (IOException ex) {}
                }
                if (!found && !locale.equals(Locale.getDefault().toString())) {
                    result = this.getCurrentLocalizedHeader(Locale.getDefault().toString());
                } else {
                    for (Map.Entry entry : headers.entrySet()) {
                        String value = (String)entry.getValue();
                        if (!value.startsWith("%")) continue;
                        String key = value.substring(value.indexOf("%") + 1);
                        String newvalue = mergedProperties.getProperty(key);
                        if (newvalue == null) {
                            newvalue = key;
                        }
                        entry.setValue(newvalue);
                    }
                    this.updateHeaderCache(locale, headers);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHeaderCache(String locale, Map<String, String> localizedHeaders) {
        Map<String, Map<String, String>> map = this.m_cachedHeaders;
        synchronized (map) {
            this.m_cachedHeaders.put(locale, localizedHeaders);
            this.m_cachedHeadersTimestamp = System.currentTimeMillis();
        }
    }

    private static List<String> createLocalizationResourceList(String basename, String locale) {
        ArrayList<String> result = new ArrayList<String>(4);
        StringBuilder tempLocale = new StringBuilder(basename);
        result.add(tempLocale.toString());
        if (locale.length() > 0) {
            StringTokenizer tokens = new StringTokenizer(locale, "_");
            while (tokens.hasMoreTokens()) {
                tempLocale.append("_").append(tokens.nextToken());
                result.add(tempLocale.toString());
            }
        }
        return result;
    }

    @Override
    public String getSymbolicName() {
        return this.m_symbolicName;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.m_classLoader.loadClass(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.m_classLoader.getResources(name);
    }

    @Override
    public Enumeration<String> getEntryPaths(String path) {
        return new EntryFilterEnumeration<String>(this.m_revision, false, path, null, false, false);
    }

    @Override
    public URL getEntry(String path) {
        URL result = this.m_revision.getEntry(path);
        return result;
    }

    @Override
    public long getLastModified() {
        return this.m_revision.getLastModified();
    }

    @Override
    public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
        return new EntryFilterEnumeration<URL>(this.m_revision, true, path, filePattern, recurse, true);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.m_context;
    }

    @Override
    public Map<X509Certificate, List<X509Certificate>> getSignerCertificates(int signersType) {
        return new HashMap<X509Certificate, List<X509Certificate>>();
    }

    @Override
    public Version getVersion() {
        return this.m_version;
    }

    public boolean equals(Object o) {
        if (o instanceof PojoSRBundle) {
            return ((PojoSRBundle)o).m_id == this.m_id;
        }
        return false;
    }

    @Override
    public int compareTo(Bundle o) {
        long thatBundleId;
        long thisBundleId = this.getBundleId();
        return thisBundleId < (thatBundleId = o.getBundleId()) ? -1 : (thisBundleId == thatBundleId ? 0 : 1);
    }

    @Override
    public <A> A adapt(Class<A> type) {
        if (this.m_services != null && this.m_services.containsKey(type)) {
            return (A)this.m_services.get(type);
        }
        if (type.isInstance(this)) {
            return (A)this;
        }
        if (type == BundleWiring.class) {
            return (A)new BundleWiringImpl(this, this.m_classLoader);
        }
        if (type == BundleRevision.class) {
            return (A)new BundleRevisionImpl(this);
        }
        if (type == BundleStartLevel.class) {
            return (A)new BundleStartLevelImpl(this);
        }
        return null;
    }

    @Override
    public File getDataFile(String filename) {
        return this.m_context.getDataFile(filename);
    }

    public String toString() {
        String sym = this.getSymbolicName();
        if (sym != null) {
            return sym + " [" + this.getBundleId() + "]";
        }
        return "[" + this.getBundleId() + "]";
    }

    @Override
    public List<BundleRevision> getRevisions() {
        return Arrays.asList(this.adapt(BundleRevision.class));
    }

    @Override
    public Bundle getBundle() {
        return this;
    }

    public static class BundleWiringImpl
    implements BundleWiring {
        private final Bundle bundle;
        private final ClassLoader classLoader;

        public BundleWiringImpl(Bundle bundle, ClassLoader classLoader) {
            this.bundle = bundle;
            this.classLoader = classLoader;
        }

        @Override
        public boolean isInUse() {
            return true;
        }

        @Override
        public boolean isCurrent() {
            return true;
        }

        @Override
        public BundleRevision getRevision() {
            return this.bundle.adapt(BundleRevision.class);
        }

        @Override
        public List<BundleRequirement> getRequirements(String namespace) {
            return Collections.emptyList();
        }

        @Override
        public List<BundleWire> getRequiredWires(String namespace) {
            return Collections.emptyList();
        }

        @Override
        public List<BundleWire> getProvidedWires(String namespace) {
            return Collections.emptyList();
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        @Override
        public List<BundleCapability> getCapabilities(String namespace) {
            return Collections.emptyList();
        }

        @Override
        public List<Capability> getResourceCapabilities(String namespace) {
            return Collections.emptyList();
        }

        @Override
        public List<Requirement> getResourceRequirements(String namespace) {
            return Collections.emptyList();
        }

        @Override
        public List<Wire> getProvidedResourceWires(String namespace) {
            return Collections.emptyList();
        }

        @Override
        public List<Wire> getRequiredResourceWires(String namespace) {
            return Collections.emptyList();
        }

        @Override
        public BundleRevision getResource() {
            return this.getRevision();
        }

        @Override
        public Bundle getBundle() {
            return this.bundle;
        }

        @Override
        public List<URL> findEntries(String path, String filePattern, int options) {
            ArrayList<URL> result = new ArrayList<URL>();
            Enumeration<URL> e = this.bundle.findEntries(path, filePattern, options == 1);
            while (e.hasMoreElements()) {
                result.add(e.nextElement());
            }
            return result;
        }

        @Override
        public Collection<String> listResources(String path, String filePattern, int options) {
            ArrayList<String> result = new ArrayList<String>();
            for (URL u : this.findEntries(path, filePattern, options)) {
                result.add(u.toString());
            }
            return result;
        }
    }

    public static class BundleRevisionImpl
    implements BundleRevision {
        private final Bundle bundle;

        public BundleRevisionImpl(Bundle bundle) {
            this.bundle = bundle;
        }

        @Override
        public String getSymbolicName() {
            return this.bundle.getSymbolicName();
        }

        @Override
        public Version getVersion() {
            return this.bundle.getVersion();
        }

        @Override
        public List<BundleCapability> getDeclaredCapabilities(String namespace) {
            return Collections.emptyList();
        }

        @Override
        public List<BundleRequirement> getDeclaredRequirements(String namespace) {
            return Collections.emptyList();
        }

        @Override
        public int getTypes() {
            if (this.bundle.getHeaders().get("Fragment-Host") != null) {
                return 1;
            }
            return 0;
        }

        @Override
        public BundleWiring getWiring() {
            return this.bundle.adapt(BundleWiring.class);
        }

        @Override
        public List<Capability> getCapabilities(String namespace) {
            return Collections.emptyList();
        }

        @Override
        public List<Requirement> getRequirements(String namespace) {
            return Collections.emptyList();
        }

        @Override
        public Bundle getBundle() {
            return this.bundle;
        }
    }

    public static class BundleStartLevelImpl
    implements BundleStartLevel {
        private final Bundle bundle;

        public BundleStartLevelImpl(Bundle bundle) {
            this.bundle = bundle;
        }

        @Override
        public int getStartLevel() {
            return 1;
        }

        @Override
        public void setStartLevel(int startlevel) {
        }

        @Override
        public boolean isPersistentlyStarted() {
            return true;
        }

        @Override
        public boolean isActivationPolicyUsed() {
            return false;
        }

        @Override
        public Bundle getBundle() {
            return this.bundle;
        }
    }
}

