/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.column;

import java.util.Set;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBQuery;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.xml.XMLUtil;
import org.w3c.dom.Element;

public class DBCountExpr
extends DBColumnExpr {
    private final DBRowSet rowset;
    private final DBColumnExpr column;
    private final boolean distinct;

    public DBCountExpr(DBRowSet rowset) {
        this.rowset = rowset;
        this.column = null;
        this.distinct = false;
    }

    public DBCountExpr(DBColumnExpr expr, boolean distinct) {
        this.rowset = null;
        this.column = expr;
        this.distinct = distinct;
    }

    public final DBDatabase getDatabase() {
        if (this.column != null) {
            return this.column.getDatabase();
        }
        return this.rowset.getDatabase();
    }

    @Override
    public DataType getDataType() {
        return DataType.INTEGER;
    }

    @Override
    public Class<Enum<?>> getEnumType() {
        return null;
    }

    @Override
    public String getName() {
        String colName = this.column != null ? this.column.getName() : this.rowset.getName();
        return StringUtils.isNotEmpty(colName) ? colName + "_COUNT" : "COUNT";
    }

    @Override
    public DBRowSet getRowSet() {
        return this.rowset != null ? this.rowset : this.column.getRowSet();
    }

    @Override
    public DBColumn getUpdateColumn() {
        return this.column != null ? this.column.getUpdateColumn() : null;
    }

    @Override
    public boolean isAggregate() {
        return true;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DBCountExpr) {
            DBCountExpr otherCount = (DBCountExpr)other;
            if (this.column != null) {
                return this.column.equals(otherCount.column);
            }
            if (this.rowset != null) {
                return this.rowset.equals(otherCount.rowset);
            }
        }
        return false;
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
        if (this.column != null) {
            this.column.addReferencedColumns(list);
        } else if (this.rowset instanceof DBQuery) {
            list.add(((DBQuery)this.rowset).getQueryColumns()[0]);
        } else {
            list.add(this.rowset.getColumn(0));
        }
    }

    @Override
    public void addSQL(DBSQLBuilder sql, long context) {
        sql.append("count(");
        if (this.column != null) {
            if (this.distinct) {
                sql.append("distinct ");
            }
            this.column.addSQL(sql, context & 0xFFFFFFFFFFFFFFF7L);
        } else {
            sql.append("*");
        }
        sql.append(")");
    }

    @Override
    public Element addXml(Element parent, long flags) {
        Element elem;
        if (this.column != null) {
            elem = this.column.addXml(parent, flags);
        } else {
            elem = XMLUtil.addElement(parent, "column");
            elem.setAttribute("name", this.getName());
        }
        elem.setAttribute("function", "count");
        return elem;
    }
}

