/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.histogram;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.histogram.ApproximateHistogram;
import org.apache.druid.query.aggregation.histogram.ApproximateHistogramPostAggregator;
import org.apache.druid.query.aggregation.histogram.FixedBucketsHistogram;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnType;

@JsonTypeName(value="quantile")
public class QuantilePostAggregator
extends ApproximateHistogramPostAggregator {
    static final Comparator COMPARATOR = Comparator.comparingDouble(o -> ((Number)o).doubleValue());
    private final float probability;

    @JsonCreator
    public QuantilePostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="probability") float probability) {
        super(name, fieldName);
        this.probability = probability;
        if (probability < 0.0f || probability > 1.0f) {
            throw new IAE("Illegal probability[%s], must be strictly between 0 and 1", new Object[]{Float.valueOf(probability)});
        }
    }

    @Override
    public Comparator getComparator() {
        return COMPARATOR;
    }

    public Set<String> getDependentFields() {
        return Sets.newHashSet((Object[])new String[]{this.fieldName});
    }

    @Override
    public Object compute(Map<String, Object> values) {
        Object value = values.get(this.fieldName);
        if (value instanceof ApproximateHistogram) {
            ApproximateHistogram ah = (ApproximateHistogram)value;
            return Float.valueOf(ah.getQuantiles(new float[]{this.probability})[0]);
        }
        FixedBucketsHistogram fbh = (FixedBucketsHistogram)value;
        float x = fbh.percentilesFloat(new double[]{(double)this.probability * 100.0})[0];
        return Float.valueOf(x);
    }

    public ColumnType getType(ColumnInspector signature) {
        return ColumnType.FLOAT;
    }

    public PostAggregator decorate(Map<String, AggregatorFactory> aggregators) {
        return this;
    }

    @JsonProperty
    public float getProbability() {
        return this.probability;
    }

    @Override
    public String toString() {
        return "QuantilePostAggregator{name='" + this.name + "', fieldName='" + this.fieldName + "', probability=" + this.probability + "}";
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(15).appendString(this.fieldName).appendFloat(this.probability).build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        QuantilePostAggregator that = (QuantilePostAggregator)o;
        return Float.compare(that.probability, this.probability) == 0;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), Float.valueOf(this.probability));
    }
}

