/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.histogram;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.histogram.FixedBucketsHistogram;
import org.apache.druid.query.aggregation.histogram.FixedBucketsHistogramBufferAggregatorHelper;
import org.apache.druid.segment.vector.VectorValueSelector;

public class FixedBucketsHistogramVectorAggregator
implements VectorAggregator {
    private final VectorValueSelector selector;
    private final FixedBucketsHistogramBufferAggregatorHelper innerAggregator;

    public FixedBucketsHistogramVectorAggregator(VectorValueSelector selector, double lowerLimit, double upperLimit, int numBuckets, FixedBucketsHistogram.OutlierHandlingMode outlierHandlingMode) {
        this.selector = selector;
        this.innerAggregator = new FixedBucketsHistogramBufferAggregatorHelper(lowerLimit, upperLimit, numBuckets, outlierHandlingMode);
    }

    public void init(ByteBuffer buf, int position) {
        this.innerAggregator.init(buf, position);
    }

    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        double[] vector = this.selector.getDoubleVector();
        boolean[] isNull = this.selector.getNullVector();
        FixedBucketsHistogram histogram = this.innerAggregator.get(buf, position);
        for (int i = startRow; i < endRow; ++i) {
            histogram.combine(this.toObject(vector, isNull, i));
        }
        this.innerAggregator.put(buf, position, histogram);
    }

    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        double[] vector = this.selector.getDoubleVector();
        boolean[] isNull = this.selector.getNullVector();
        for (int i = 0; i < numRows; ++i) {
            int position = positions[i] + positionOffset;
            int index = rows != null ? rows[i] : i;
            Double val = this.toObject(vector, isNull, index);
            this.innerAggregator.aggregate(buf, position, val);
        }
    }

    @Nullable
    public Object get(ByteBuffer buf, int position) {
        return this.innerAggregator.get(buf, position);
    }

    public void close() {
    }

    @Nullable
    private Double toObject(double[] vector, @Nullable boolean[] isNull, int index) {
        return isNull != null && isNull[index] ? null : Double.valueOf(vector[index]);
    }
}

