/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.histogram;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.histogram.ApproximateHistogram;
import org.apache.druid.query.aggregation.histogram.ApproximateHistogramBufferAggregatorHelper;
import org.apache.druid.segment.vector.VectorValueSelector;

public class ApproximateHistogramVectorAggregator
implements VectorAggregator {
    private final VectorValueSelector selector;
    private final ApproximateHistogramBufferAggregatorHelper innerAggregator;

    public ApproximateHistogramVectorAggregator(VectorValueSelector selector, int resolution) {
        this.selector = selector;
        this.innerAggregator = new ApproximateHistogramBufferAggregatorHelper(resolution);
    }

    public void init(ByteBuffer buf, int position) {
        this.innerAggregator.init(buf, position);
    }

    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        boolean[] isValueNull = this.selector.getNullVector();
        float[] vector = this.selector.getFloatVector();
        ApproximateHistogram histogram = this.innerAggregator.get(buf, position);
        for (int i = startRow; i < endRow; ++i) {
            if (isValueNull != null && isValueNull[i]) continue;
            histogram.offer(vector[i]);
        }
        this.innerAggregator.put(buf, position, histogram);
    }

    public Object get(ByteBuffer buf, int position) {
        return this.innerAggregator.get(buf, position);
    }

    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        float[] vector = this.selector.getFloatVector();
        boolean[] isValueNull = this.selector.getNullVector();
        for (int i = 0; i < numRows; ++i) {
            if (isValueNull != null && isValueNull[i]) continue;
            int position = positions[i] + positionOffset;
            this.innerAggregator.aggregate(buf, position, vector[rows != null ? rows[i] : i]);
        }
    }

    public void close() {
    }
}

