/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata.input;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.druid.metadata.MetadataStorageConnectorConfig;
import org.apache.druid.metadata.SQLInputSourceDatabaseConnector;
import org.apache.druid.metadata.storage.mysql.MySQLConnectorDriverConfig;
import org.apache.druid.server.initialization.JdbcAccessSecurityConfig;
import org.apache.druid.utils.ConnectionUriUtils;
import org.skife.jdbi.v2.DBI;

@JsonTypeName(value="mysql")
public class MySQLInputSourceDatabaseConnector
extends SQLInputSourceDatabaseConnector {
    private final DBI dbi;
    private final MetadataStorageConnectorConfig connectorConfig;
    @Nullable
    private final String driverClassName;

    @JsonCreator
    public MySQLInputSourceDatabaseConnector(@JsonProperty(value="connectorConfig") MetadataStorageConnectorConfig connectorConfig, @JsonProperty(value="driverClassName") @Nullable String driverClassName, @JacksonInject JdbcAccessSecurityConfig securityConfig, @JacksonInject MySQLConnectorDriverConfig mySQLConnectorDriverConfig) {
        this.connectorConfig = connectorConfig;
        this.driverClassName = driverClassName;
        BasicDataSource datasource = this.getDatasource(connectorConfig, securityConfig);
        datasource.setDriverClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        if (driverClassName != null) {
            datasource.setDriverClassName(driverClassName);
        } else {
            datasource.setDriverClassName(mySQLConnectorDriverConfig.getDriverClassName());
        }
        this.dbi = new DBI((DataSource)datasource);
    }

    @JsonProperty
    public MetadataStorageConnectorConfig getConnectorConfig() {
        return this.connectorConfig;
    }

    @Nullable
    @JsonProperty
    public String getDriverClassName() {
        return this.driverClassName;
    }

    public DBI getDBI() {
        return this.dbi;
    }

    public Set<String> findPropertyKeysFromConnectURL(String connectUrl, boolean allowUnknown) {
        return ConnectionUriUtils.tryParseJdbcUriParameters((String)connectUrl, (boolean)allowUnknown);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        MySQLInputSourceDatabaseConnector that = (MySQLInputSourceDatabaseConnector)((Object)o);
        return this.connectorConfig.equals((Object)that.connectorConfig) && Objects.equals(this.driverClassName, that.driverClassName);
    }

    public int hashCode() {
        return Objects.hash(this.connectorConfig, this.driverClassName);
    }
}

