/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.basic.authorization.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.druid.security.basic.authorization.entity.BasicAuthorizerPermission;
import org.apache.druid.security.basic.authorization.entity.BasicAuthorizerRole;
import org.apache.druid.security.basic.authorization.entity.BasicAuthorizerRoleFull;
import org.apache.druid.server.security.ResourceAction;

public class BasicAuthorizerRoleSimplifiedPermissions {
    private final String name;
    private final Set<String> users;
    private final List<ResourceAction> permissions;

    @JsonCreator
    public BasicAuthorizerRoleSimplifiedPermissions(@JsonProperty(value="name") String name, @JsonProperty(value="users") Set<String> users, @JsonProperty(value="permissions") List<ResourceAction> permissions) {
        this.name = name;
        this.users = users;
        this.permissions = permissions == null ? new ArrayList() : permissions;
    }

    public BasicAuthorizerRoleSimplifiedPermissions(BasicAuthorizerRole role, Set<String> users) {
        this(role.getName(), users, BasicAuthorizerRoleSimplifiedPermissions.convertPermissions(role.getPermissions()));
    }

    public BasicAuthorizerRoleSimplifiedPermissions(BasicAuthorizerRoleFull role) {
        this(role.getName(), role.getUsers(), BasicAuthorizerRoleSimplifiedPermissions.convertPermissions(role.getPermissions()));
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public List<ResourceAction> getPermissions() {
        return this.permissions;
    }

    @JsonProperty
    public Set<String> getUsers() {
        return this.users;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicAuthorizerRoleSimplifiedPermissions that = (BasicAuthorizerRoleSimplifiedPermissions)o;
        if (this.getName() != null ? !this.getName().equals(that.getName()) : that.getName() != null) {
            return false;
        }
        if (this.getUsers() != null ? !this.getUsers().equals(that.getUsers()) : that.getUsers() != null) {
            return false;
        }
        return this.getPermissions() != null ? this.getPermissions().equals(that.getPermissions()) : that.getPermissions() == null;
    }

    public int hashCode() {
        int result = this.getName() != null ? this.getName().hashCode() : 0;
        result = 31 * result + (this.getUsers() != null ? this.getUsers().hashCode() : 0);
        result = 31 * result + (this.getPermissions() != null ? this.getPermissions().hashCode() : 0);
        return result;
    }

    public static List<ResourceAction> convertPermissions(List<BasicAuthorizerPermission> permissions) {
        return Lists.transform(permissions, permission -> permission.getResourceAction());
    }

    public static Set<BasicAuthorizerRoleSimplifiedPermissions> convertRoles(Set<BasicAuthorizerRole> roles) {
        HashSet<BasicAuthorizerRoleSimplifiedPermissions> newRoles = new HashSet<BasicAuthorizerRoleSimplifiedPermissions>();
        for (BasicAuthorizerRole role : roles) {
            newRoles.add(new BasicAuthorizerRoleSimplifiedPermissions(role, null));
        }
        return newRoles;
    }
}

