/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CopyImageRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CopyImageRequestMarshaller
implements Marshaller<Request<CopyImageRequest>, CopyImageRequest> {
    public Request<CopyImageRequest> marshall(CopyImageRequest copyImageRequest) {
        SdkInternalList copyImageRequestTagSpecificationsList;
        if (copyImageRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)copyImageRequest, "AmazonEC2");
        request.addParameter("Action", "CopyImage");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (copyImageRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)copyImageRequest.getClientToken()));
        }
        if (copyImageRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)copyImageRequest.getDescription()));
        }
        if (copyImageRequest.getEncrypted() != null) {
            request.addParameter("Encrypted", StringUtils.fromBoolean((Boolean)copyImageRequest.getEncrypted()));
        }
        if (copyImageRequest.getKmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)copyImageRequest.getKmsKeyId()));
        }
        if (copyImageRequest.getName() != null) {
            request.addParameter("Name", StringUtils.fromString((String)copyImageRequest.getName()));
        }
        if (copyImageRequest.getSourceImageId() != null) {
            request.addParameter("SourceImageId", StringUtils.fromString((String)copyImageRequest.getSourceImageId()));
        }
        if (copyImageRequest.getSourceRegion() != null) {
            request.addParameter("SourceRegion", StringUtils.fromString((String)copyImageRequest.getSourceRegion()));
        }
        if (copyImageRequest.getDestinationOutpostArn() != null) {
            request.addParameter("DestinationOutpostArn", StringUtils.fromString((String)copyImageRequest.getDestinationOutpostArn()));
        }
        if (copyImageRequest.getCopyImageTags() != null) {
            request.addParameter("CopyImageTags", StringUtils.fromBoolean((Boolean)copyImageRequest.getCopyImageTags()));
        }
        if (!(copyImageRequestTagSpecificationsList = (SdkInternalList)copyImageRequest.getTagSpecifications()).isEmpty() || !copyImageRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification copyImageRequestTagSpecificationsListValue : copyImageRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (copyImageRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)copyImageRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)copyImageRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        return request;
    }
}

