/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.PrefixListState;
import com.amazonaws.services.ec2.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ManagedPrefixList
implements Serializable,
Cloneable {
    private String prefixListId;
    private String addressFamily;
    private String state;
    private String stateMessage;
    private String prefixListArn;
    private String prefixListName;
    private Integer maxEntries;
    private Long version;
    private SdkInternalList<Tag> tags;
    private String ownerId;

    public void setPrefixListId(String prefixListId) {
        this.prefixListId = prefixListId;
    }

    public String getPrefixListId() {
        return this.prefixListId;
    }

    public ManagedPrefixList withPrefixListId(String prefixListId) {
        this.setPrefixListId(prefixListId);
        return this;
    }

    public void setAddressFamily(String addressFamily) {
        this.addressFamily = addressFamily;
    }

    public String getAddressFamily() {
        return this.addressFamily;
    }

    public ManagedPrefixList withAddressFamily(String addressFamily) {
        this.setAddressFamily(addressFamily);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public ManagedPrefixList withState(String state) {
        this.setState(state);
        return this;
    }

    public ManagedPrefixList withState(PrefixListState state) {
        this.state = state.toString();
        return this;
    }

    public void setStateMessage(String stateMessage) {
        this.stateMessage = stateMessage;
    }

    public String getStateMessage() {
        return this.stateMessage;
    }

    public ManagedPrefixList withStateMessage(String stateMessage) {
        this.setStateMessage(stateMessage);
        return this;
    }

    public void setPrefixListArn(String prefixListArn) {
        this.prefixListArn = prefixListArn;
    }

    public String getPrefixListArn() {
        return this.prefixListArn;
    }

    public ManagedPrefixList withPrefixListArn(String prefixListArn) {
        this.setPrefixListArn(prefixListArn);
        return this;
    }

    public void setPrefixListName(String prefixListName) {
        this.prefixListName = prefixListName;
    }

    public String getPrefixListName() {
        return this.prefixListName;
    }

    public ManagedPrefixList withPrefixListName(String prefixListName) {
        this.setPrefixListName(prefixListName);
        return this;
    }

    public void setMaxEntries(Integer maxEntries) {
        this.maxEntries = maxEntries;
    }

    public Integer getMaxEntries() {
        return this.maxEntries;
    }

    public ManagedPrefixList withMaxEntries(Integer maxEntries) {
        this.setMaxEntries(maxEntries);
        return this;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public Long getVersion() {
        return this.version;
    }

    public ManagedPrefixList withVersion(Long version) {
        this.setVersion(version);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public ManagedPrefixList withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public ManagedPrefixList withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public ManagedPrefixList withOwnerId(String ownerId) {
        this.setOwnerId(ownerId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPrefixListId() != null) {
            sb.append("PrefixListId: ").append(this.getPrefixListId()).append(",");
        }
        if (this.getAddressFamily() != null) {
            sb.append("AddressFamily: ").append(this.getAddressFamily()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getStateMessage() != null) {
            sb.append("StateMessage: ").append(this.getStateMessage()).append(",");
        }
        if (this.getPrefixListArn() != null) {
            sb.append("PrefixListArn: ").append(this.getPrefixListArn()).append(",");
        }
        if (this.getPrefixListName() != null) {
            sb.append("PrefixListName: ").append(this.getPrefixListName()).append(",");
        }
        if (this.getMaxEntries() != null) {
            sb.append("MaxEntries: ").append(this.getMaxEntries()).append(",");
        }
        if (this.getVersion() != null) {
            sb.append("Version: ").append(this.getVersion()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getOwnerId() != null) {
            sb.append("OwnerId: ").append(this.getOwnerId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedPrefixList)) {
            return false;
        }
        ManagedPrefixList other = (ManagedPrefixList)obj;
        if (other.getPrefixListId() == null ^ this.getPrefixListId() == null) {
            return false;
        }
        if (other.getPrefixListId() != null && !other.getPrefixListId().equals(this.getPrefixListId())) {
            return false;
        }
        if (other.getAddressFamily() == null ^ this.getAddressFamily() == null) {
            return false;
        }
        if (other.getAddressFamily() != null && !other.getAddressFamily().equals(this.getAddressFamily())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getStateMessage() == null ^ this.getStateMessage() == null) {
            return false;
        }
        if (other.getStateMessage() != null && !other.getStateMessage().equals(this.getStateMessage())) {
            return false;
        }
        if (other.getPrefixListArn() == null ^ this.getPrefixListArn() == null) {
            return false;
        }
        if (other.getPrefixListArn() != null && !other.getPrefixListArn().equals(this.getPrefixListArn())) {
            return false;
        }
        if (other.getPrefixListName() == null ^ this.getPrefixListName() == null) {
            return false;
        }
        if (other.getPrefixListName() != null && !other.getPrefixListName().equals(this.getPrefixListName())) {
            return false;
        }
        if (other.getMaxEntries() == null ^ this.getMaxEntries() == null) {
            return false;
        }
        if (other.getMaxEntries() != null && !other.getMaxEntries().equals(this.getMaxEntries())) {
            return false;
        }
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        if (other.getVersion() != null && !other.getVersion().equals(this.getVersion())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getOwnerId() == null ^ this.getOwnerId() == null) {
            return false;
        }
        return other.getOwnerId() == null || other.getOwnerId().equals(this.getOwnerId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPrefixListId() == null ? 0 : this.getPrefixListId().hashCode());
        hashCode = 31 * hashCode + (this.getAddressFamily() == null ? 0 : this.getAddressFamily().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getStateMessage() == null ? 0 : this.getStateMessage().hashCode());
        hashCode = 31 * hashCode + (this.getPrefixListArn() == null ? 0 : this.getPrefixListArn().hashCode());
        hashCode = 31 * hashCode + (this.getPrefixListName() == null ? 0 : this.getPrefixListName().hashCode());
        hashCode = 31 * hashCode + (this.getMaxEntries() == null ? 0 : this.getMaxEntries().hashCode());
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getOwnerId() == null ? 0 : this.getOwnerId().hashCode());
        return hashCode;
    }

    public ManagedPrefixList clone() {
        try {
            return (ManagedPrefixList)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

